/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.mutable;

import com.github.roookeee.datus.api.Mapper;
import com.github.roookeee.datus.mutable.MappingOptimizer;
import com.github.roookeee.datus.mutable.MutableConstructionStep;
import com.github.roookeee.datus.mutable.MutableMapperImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MutableMappingBuilder<In, Out> {
    private final List<BiFunction<? super In, ? super Out, ? extends Out>> mappers = new ArrayList<BiFunction<? super In, ? super Out, ? extends Out>>();
    private final Supplier<? extends Out> generator;

    public MutableMappingBuilder(Supplier<? extends Out> generator) {
        this.generator = generator;
    }

    public <A> MutableConstructionStep<In, A, Out> from(Function<? super In, ? extends A> getter) {
        return new MutableConstructionStep(this, getter);
    }

    public MutableMappingBuilder<In, Out> process(BiFunction<? super In, ? super Out, ? extends Out> processor) {
        this.mappers.add(processor);
        return this;
    }

    public MutableMappingBuilder<In, Out> spy(BiConsumer<? super In, ? super Out> consumer) {
        this.process((in, out) -> {
            consumer.accept((Object)in, (Object)out);
            return out;
        });
        return this;
    }

    public Mapper<In, Out> build() {
        BiFunction<? super In, ? extends Out, ? extends Out> mappingProcess = MappingOptimizer.flattenAndOptimizeMappings(this.mappers);
        return new MutableMapperImpl<In, Out>(mappingProcess, this.generator);
    }

    void addMapper(BiFunction<? super In, ? super Out, ? extends Out> mapper) {
        this.mappers.add(mapper);
    }
}

