/*
 * Decompiled with CFR 0.152.
 */
package com.github.saiprasadkrishnamurthy.sk8s;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.github.saiprasadkrishnamurthy.sk8s.DiffLog;
import com.github.saiprasadkrishnamurthy.sk8s.GenerateGitManifestsRequest;
import com.github.saiprasadkrishnamurthy.sk8s.GitManifestsGenerator;
import com.github.saiprasadkrishnamurthy.sk8s.VersionMetadata;
import io.reflectoring.diffparser.api.model.Diff;
import io.reflectoring.diffparser.api.model.Hunk;
import io.reflectoring.diffparser.api.model.Line;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002JD\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u001d\u001a\u00020\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010#\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)\u00a8\u0006+"}, d2={"Lcom/github/saiprasadkrishnamurthy/sk8s/GitManifestsGenerator;", "", "()V", "contents", "", "diff", "Lio/reflectoring/diffparser/api/model/Diff;", "lineType", "databaseDump", "", "Lcom/github/saiprasadkrishnamurthy/sk8s/DiffLog;", "generateGitManifestsRequest", "Lcom/github/saiprasadkrishnamurthy/sk8s/GenerateGitManifestsRequest;", "versionMetadata", "", "Lcom/github/saiprasadkrishnamurthy/sk8s/VersionMetadata;", "diffs", "v", "prevMavenVersion", "mavenVersionCanonicalNameA", "mavenVersionCanonicalNameB", "lastGitSha", "extractVariableNames", "", "value", "regex", "Ljava/util/regex/Pattern;", "generateManifests", "", "loadToDB", "pstmt", "Ljava/sql/PreparedStatement;", "artifactId", "pomVersion", "sha", "runCommand", "workingDir", "Ljava/io/File;", "timeoutAmount", "", "timeoutUnit", "Ljava/util/concurrent/TimeUnit;", "Factory", "springboot-manifest-maven-plugin"})
public final class GitManifestsGenerator {
    private static final String GIT_LOG_ENTRIES_DELIMITER = "|||||_|||||";
    public static final Factory Factory = new Factory(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void generateManifests(@NotNull GenerateGitManifestsRequest generateGitManifestsRequest) {
        boolean shouldRun;
        Object object;
        Object it;
        String currBranch;
        block23: {
            boolean bl;
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)generateGitManifestsRequest, (String)"generateGitManifestsRequest");
            String checkBranchCommand = "git branch";
            Object $this$filter$iv = StringsKt.split$default((CharSequence)String.valueOf(GitManifestsGenerator.runCommand$default(this, checkBranchCommand, new File(generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null)), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it2, (String)"*", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = StringsKt.replace$default((String)((String)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)1).get(0)), (String)"*", (String)"", (boolean)false, (int)4, null);
            $i$f$filter = false;
            Object object2 = $this$filter$iv;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            currBranch = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
            Iterable $this$any$iv = generateGitManifestsRequest.getExecuteOnBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block22: {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        Pattern pattern = Pattern.compile((String)it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(it)");
                        Iterable $this$any$iv2 = this.extractVariableNames(currBranch, pattern);
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it3 = (String)element$iv2;
                                boolean bl5 = false;
                                object = it3;
                                boolean bl6 = false;
                                String string = object;
                                if (string == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                object = ((Object)StringsKt.trim((CharSequence)string)).toString();
                                bl6 = false;
                                if (!(!StringsKt.isBlank((CharSequence)object))) continue;
                                bl3 = true;
                                break block22;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block23;
                }
                bl = shouldRun = false;
            }
        }
        if (shouldRun) {
            String string;
            Object object3;
            String historyCommand = "git --no-pager log --oneline --decorate";
            List logs = StringsKt.split$default((CharSequence)String.valueOf(GitManifestsGenerator.runCommand$default(this, historyCommand, new File(generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null)), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            List versionMetadata2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)logs), (int)generateGitManifestsRequest.getMaxRevisions()), (Function1)generateManifests.versionMetadata.1.INSTANCE), (Function1)generateManifests.versionMetadata.2.INSTANCE), (Function1)((Function1)new Function1<String, VersionMetadata>(this, generateGitManifestsRequest, sdf){
                final /* synthetic */ GitManifestsGenerator this$0;
                final /* synthetic */ GenerateGitManifestsRequest $generateGitManifestsRequest;
                final /* synthetic */ SimpleDateFormat $sdf;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final VersionMetadata invoke(@NotNull String sha) {
                    void $this$mapTo$iv$iv;
                    Object list$iv$iv;
                    String it;
                    Iterable $this$flatMapTo$iv$iv;
                    Object object;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)sha, (String)"sha");
                    Iterable $this$filter$iv = StringsKt.split$default((CharSequence)String.valueOf(GitManifestsGenerator.runCommand$default(this.this$0, "git --no-pager show --pretty= --name-status " + sha + " --first-parent", new File(this.$generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null)), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo22 = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl = false;
                        object = it2;
                        boolean bl2 = false;
                        if (!(object.length() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List entries = (List)destination$iv$iv;
                    List details = StringsKt.split$default((CharSequence)String.valueOf(GitManifestsGenerator.runCommand$default(this.this$0, "git --no-pager show -s --pretty=\"%an" + GitManifestsGenerator.access$getGIT_LOG_ENTRIES_DELIMITER$cp() + "%at|||||_|||||%cn|||||_|||||%s\" " + sha, new File(this.$generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null)), (String[])new String[]{GitManifestsGenerator.access$getGIT_LOG_ENTRIES_DELIMITER$cp()}, (boolean)false, (int)0, (int)6, null);
                    String author = (String)details.get(0);
                    String $i$f$filterTo22 = (String)details.get(1);
                    boolean bl = false;
                    long timestamp = Long.parseLong($i$f$filterTo22);
                    String authorName = (String)details.get(2);
                    String message = (String)details.get(3);
                    Iterable $this$flatMap$iv = this.$generateGitManifestsRequest.getTicketPatterns();
                    boolean $i$f$flatMap = false;
                    object = $this$flatMap$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl3 = false;
                        Pattern pattern = Pattern.compile(it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(it)");
                        list$iv$iv = GitManifestsGenerator.access$extractVariableNames(this.this$0, message, pattern);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$map = false;
                    $this$flatMapTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        list$iv$iv = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl4 = false;
                        String string = it;
                        boolean bl5 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        collection.add(string3);
                    }
                    List tickets = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                    String mavenVersion = GitManifestsGenerator.access$pomVersion(this.this$0, sha, this.$generateGitManifestsRequest);
                    Date date = new Date();
                    date.setTime(timestamp * (long)1000);
                    String string = StringsKt.replace$default((String)StringsKt.replace$default((String)message, (String)"\"", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
                    String string4 = StringsKt.replace$default((String)(author + " (" + authorName + ')'), (String)"\"", (String)"", (boolean)false, (int)4, null);
                    List list = CollectionsKt.distinct((Iterable)tickets);
                    String string5 = this.$sdf.format(date);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sdf.format(date)");
                    object = string5;
                    List list2 = list;
                    List list3 = entries;
                    String string6 = string4;
                    String string7 = string;
                    return new VersionMetadata(sha, mavenVersion, timestamp, string6, string7, list2, list3, (String)object);
                }
                {
                    this.this$0 = gitManifestsGenerator;
                    this.$generateGitManifestsRequest = generateGitManifestsRequest;
                    this.$sdf = simpleDateFormat;
                    super(1);
                }
            })), (Function1)generateManifests.versionMetadata.4.INSTANCE));
            it = versionMetadata2;
            boolean bl4 = false;
            if (!it.isEmpty()) {
                void $this$mapTo$iv$iv;
                String currentVersion = ((VersionMetadata)versionMetadata2.get(0)).getMavenVersion();
                Iterable $this$map$iv = versionMetadata2;
                boolean $i$f$map = false;
                Iterable $i$f$any2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void v;
                    object = (VersionMetadata)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl = false;
                    string = Intrinsics.areEqual((Object)v.getMavenVersion(), (Object)currentVersion) ^ true && StringsKt.contains((CharSequence)v.getMavenVersion(), (CharSequence)"snapshot", (boolean)true) ? VersionMetadata.copy$default((VersionMetadata)v, null, StringsKt.replace((String)v.getMavenVersion(), (String)"-snapshot", (String)"", (boolean)true), 0L, null, null, null, null, null, 253, null) : v;
                    object3.add(string);
                }
                versionMetadata2 = (List)destination$iv$iv;
            }
            String json = ExtensionsKt.jacksonObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)versionMetadata2);
            Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "versionInfo.json"), (CharSequence)json, new OpenOption[0]);
            String htmlTemplate = IOUtils.toString((InputStream)GitManifestsGenerator.class.getClassLoader().getResourceAsStream("templates/index.html"), (Charset)Charset.defaultCharset());
            String js = IOUtils.toString((InputStream)GitManifestsGenerator.class.getClassLoader().getResourceAsStream("templates/index.js"), (Charset)Charset.defaultCharset());
            String css = IOUtils.toString((InputStream)GitManifestsGenerator.class.getClassLoader().getResourceAsStream("templates/styles.css"), (Charset)Charset.defaultCharset());
            String string2 = htmlTemplate;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"htmlTemplate");
            String string3 = json;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"json");
            String html = StringsKt.replace$default((String)string2, (String)"{{json}}", (String)string3, (boolean)false, (int)4, null);
            html = StringsKt.replace$default((String)html, (String)"{{artifactId}}", (String)generateGitManifestsRequest.getArtifactId(), (boolean)false, (int)4, null);
            Collection $i$f$mapTo = versionMetadata2;
            string = "{{version}}";
            object3 = html;
            boolean it3 = false;
            boolean bl = !$i$f$mapTo.isEmpty();
            html = StringsKt.replace$default((String)object3, (String)string, (String)(bl ? ((VersionMetadata)versionMetadata2.get(0)).getMavenVersion() : ""), (boolean)false, (int)4, null);
            String ddTemplate = IOUtils.toString((InputStream)GitManifestsGenerator.class.getClassLoader().getResourceAsStream("templates/detailed_diff.js"), (Charset)Charset.defaultCharset());
            if (generateGitManifestsRequest.getMaxNoOfMavenVersionsForDiffsDump() > 0) {
                List<DiffLog> diffs = this.databaseDump(generateGitManifestsRequest, versionMetadata2);
                String diffJsonString = ExtensionsKt.jacksonObjectMapper().writeValueAsString(diffs);
                String string4 = ddTemplate;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ddTemplate");
                String string5 = diffJsonString;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"diffJsonString");
                ddTemplate = StringsKt.replace$default((String)string4, (String)"{{diffJson}}", (String)string5, (boolean)false, (int)4, null);
                Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "diffs.json"), (CharSequence)diffJsonString, new OpenOption[0]);
                Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "detailed_diff.js"), (CharSequence)ddTemplate, new OpenOption[0]);
            } else {
                String string6 = ddTemplate;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"ddTemplate");
                ddTemplate = StringsKt.replace$default((String)string6, (String)"{{diffJson}}", (String)"[]", (boolean)false, (int)4, null);
                Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "detailed_diff.js"), (CharSequence)ddTemplate, new OpenOption[0]);
            }
            Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "index.html"), (CharSequence)html, Charset.defaultCharset(), new OpenOption[0]);
            Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "index.js"), (CharSequence)js, Charset.defaultCharset(), new OpenOption[0]);
            Files.writeString(Paths.get(generateGitManifestsRequest.getOutputDir(), "styles.css"), (CharSequence)css, Charset.defaultCharset(), new OpenOption[0]);
            if (generateGitManifestsRequest.getTransitiveDepsDatabaseDump()) {
                String releaseDB = generateGitManifestsRequest.getOutputDir() + "/" + generateGitManifestsRequest.getArtifactId() + ".db";
                Connection connection = DriverManager.getConnection("jdbc:sqlite:" + releaseDB);
                Statement statement = connection.createStatement();
                statement.executeUpdate("create table VERSION_INFO (gitSha string, artifactId, mavenVersion string, timestamp long, author string, commitMessage string, tickets text, entries text, day string)");
                statement.executeUpdate("CREATE INDEX artifactId ON VERSION_INFO (artifactId)");
                statement.executeUpdate("CREATE INDEX mavenVersion ON VERSION_INFO (mavenVersion)");
                statement.executeUpdate("CREATE INDEX author ON VERSION_INFO (author)");
                statement.executeUpdate("CREATE INDEX gitSha ON VERSION_INFO (gitSha)");
                Statement statement2 = statement;
                Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"statement");
                statement2.setQueryTimeout(30);
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO VERSION_INFO(gitSha, artifactId, mavenVersion, timestamp, author, commitMessage, tickets, entries, day) VALUES(?,?,?,?,?,?,?,?,?)");
                try {
                    Iterable $this$forEach$iv = generateGitManifestsRequest.getDependencyArtifacts();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Artifact a = (Artifact)element$iv;
                        boolean bl7 = false;
                        JarFile jarFile = new JarFile(a.getFile());
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            byte[] byArray;
                            List vi2;
                            Charset charset;
                            String string7;
                            JarEntry element;
                            JarEntry jarEntry = element = entries.nextElement();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"element");
                            String string8 = jarEntry.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"element.name");
                            if (!StringsKt.endsWith$default((String)string8, (String)"versionInfo.json", (boolean)false, (int)2, null)) continue;
                            InputStream istream = jarFile.getInputStream(element);
                            String contents2 = IOUtils.toString((InputStream)istream, (Charset)Charset.defaultCharset());
                            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
                            Intrinsics.checkExpressionValueIsNotNull((Object)contents2, (String)"contents");
                            Intrinsics.checkExpressionValueIsNotNull((Object)Charset.defaultCharset(), (String)"Charset.defaultCharset()");
                            ObjectMapper objectMapper2 = objectMapper;
                            boolean bl8 = false;
                            String string9 = string7;
                            if (string9 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string9.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                            List list = vi2 = (List)objectMapper2.readValue(byArray, (TypeReference)new TypeReference<List<? extends VersionMetadata>>(){});
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"vi");
                            PreparedStatement preparedStatement = pstmt;
                            Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"pstmt");
                            String string10 = a.getArtifactId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"a.artifactId");
                            this.loadToDB(list, preparedStatement, string10);
                        }
                    }
                    PreparedStatement preparedStatement = pstmt;
                    Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"pstmt");
                    this.loadToDB(versionMetadata2, preparedStatement, generateGitManifestsRequest.getArtifactId());
                }
                finally {
                    pstmt.close();
                    statement.close();
                    connection.close();
                }
            }
        } else {
            String string = "Not generating the GIT manifests as the plugin is not configured to run on the branch:  " + currBranch;
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    private final void loadToDB(List<VersionMetadata> versionMetadata2, PreparedStatement pstmt, String artifactId) {
        Iterable $this$forEach$iv = versionMetadata2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VersionMetadata vm = (VersionMetadata)element$iv;
            boolean bl = false;
            pstmt.setString(1, vm.getGitSha());
            pstmt.setString(2, artifactId);
            pstmt.setString(3, vm.getMavenVersion());
            pstmt.setLong(4, vm.getTimestamp());
            pstmt.setString(5, vm.getAuthor());
            pstmt.setString(6, vm.getCommitMessage());
            pstmt.setString(7, CollectionsKt.joinToString$default((Iterable)vm.getTickets(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            pstmt.setString(8, CollectionsKt.joinToString$default((Iterable)vm.getEntries(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            pstmt.setString(9, vm.getDay());
            pstmt.addBatch();
        }
        pstmt.executeBatch();
    }

    private final String pomVersion(String sha, GenerateGitManifestsRequest generateGitManifestsRequest) {
        String string;
        try {
            String string2;
            String pomContents = GitManifestsGenerator.runCommand$default(this, "git show " + sha + ":pom.xml", new File(generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null);
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPathExpression xPath = xpFactory.newXPath().compile("//*[local-name() = 'version']");
            Object object = xPath.evaluate(new InputSource(new StringReader(pomContents)), XPathConstants.NODESET);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.NodeList");
            }
            NodeList nodeList = (NodeList)object;
            if (nodeList.getLength() > 0) {
                Node node;
                Node node2 = node = nodeList.item(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
                Node node3 = node2.getParentNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"node.parentNode");
                if (Intrinsics.areEqual((Object)node3.getLocalName(), (Object)"parent")) {
                    node = nodeList.item(1);
                }
                Node node4 = node;
                Intrinsics.checkExpressionValueIsNotNull((Object)node4, (String)"node");
                String string3 = node4.getTextContent();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.textContent");
            } else {
                string2 = "";
            }
            string = string2;
        }
        catch (Exception ex) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DiffLog> databaseDump(GenerateGitManifestsRequest generateGitManifestsRequest, List<VersionMetadata> versionMetadata2) {
        void $this$mapTo$iv$iv;
        Object $this$map$iv = versionMetadata2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VersionMetadata versionMetadata3 = (VersionMetadata)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String string = it.getMavenVersion();
            collection.add(string);
        }
        List mavenVersions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        $this$map$iv = "Found Maven Versions: " + mavenVersions;
        $i$f$map = false;
        System.out.println($this$map$iv);
        $i$f$map = false;
        List diffs = new ArrayList();
        if (mavenVersions.size() > 1) {
            List mv = CollectionsKt.take((Iterable)mavenVersions, (int)generateGitManifestsRequest.getMaxNoOfMavenVersionsForDiffsDump());
            boolean destination$iv$iv2 = false;
            Set traversed = new LinkedHashSet();
            Iterable $this$forEach$iv = mv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String a = (String)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = mv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$filterTo$iv$iv;
                    void $this$filterTo$iv$iv2;
                    String b = (String)element$iv2;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)a, (Object)b) ^ true) || traversed.contains(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])new String[]{a, b})), (CharSequence)",", null, null, (int)0, null, null, (int)62, null))) continue;
                    traversed.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])new String[]{a, b})), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    Iterable $this$filter$iv = versionMetadata2;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Iterable destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        VersionMetadata it = (VersionMetadata)element$iv$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getMavenVersion(), (Object)a)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List i = (List)destination$iv$iv3;
                    Iterable $this$filter$iv2 = versionMetadata2;
                    boolean $i$f$filter2 = false;
                    destination$iv$iv3 = $this$filter$iv2;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        VersionMetadata it = (VersionMetadata)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getMavenVersion(), (Object)b)) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    List j = (List)destination$iv$iv4;
                    String lastGitSha = ((VersionMetadata)j.get(0)).getGitSha();
                    int idx = mavenVersions.indexOf(a);
                    String mavenVersionCanonicalNameA = idx == 0 ? "CURRENT" : "CURRENT-" + idx;
                    String mavenVersionCanonicalNameB = "CURRENT-(" + (idx - 1);
                    diffs.addAll((Collection)this.diffs(i, ((VersionMetadata)j.get(0)).getMavenVersion(), mavenVersionCanonicalNameA, mavenVersionCanonicalNameB, lastGitSha, generateGitManifestsRequest));
                }
            }
        }
        return diffs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DiffLog> diffs(List<VersionMetadata> v, String prevMavenVersion, String mavenVersionCanonicalNameA, String mavenVersionCanonicalNameB, String lastGitSha, GenerateGitManifestsRequest generateGitManifestsRequest) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = v;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            VersionMetadata it = (VersionMetadata)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getEntries();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CharSequence charSequence;
                void $this$filterTo$iv$iv;
                void f;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                CharSequence charSequence2 = (CharSequence)f;
                String string2 = "\\s";
                int n = 0;
                string2 = new Regex(string2);
                n = 0;
                boolean bl3 = false;
                Iterable $this$filter$iv = string2.split(charSequence2, n);
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv2;
                    boolean bl4 = false;
                    charSequence = it2;
                    boolean bl5 = false;
                    String string3 = charSequence;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    charSequence = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    bl5 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                String file = (String)((List)destination$iv$iv3).get(1);
                String cmd = "git diff " + it.getGitSha() + ' ' + lastGitSha + ' ' + file;
                String d = String.valueOf(GitManifestsGenerator.runCommand$default(this, cmd, new File(generateGitManifestsRequest.getBaseDir()), 0L, null, 6, null));
                object = mavenVersionCanonicalNameB;
                String string4 = mavenVersionCanonicalNameA;
                String string5 = it.getCommitMessage();
                long l = it.getTimestamp();
                String string6 = it.getAuthor();
                String string7 = d;
                charSequence = file;
                DiffLog diffLog = new DiffLog(it.getMavenVersion(), prevMavenVersion, it.getGitSha(), lastGitSha, string6, l, (String)charSequence, string7, string5, string4, (String)object);
                collection.add(diffLog);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String contents(Diff diff, String lineType) {
        void $this$filterTo$iv$iv;
        Hunk hunk = diff.getLatestHunk();
        Intrinsics.checkExpressionValueIsNotNull((Object)hunk, (String)"diff.latestHunk");
        List list = hunk.getLines();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"diff.latestHunk.lines");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Line it = (Line)element$iv$iv;
            boolean bl = false;
            Line line = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)line, (String)"it");
            if (!Intrinsics.areEqual((Object)line.getLineType().name(), (Object)lineType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)contents.2.INSTANCE, (int)30, null);
    }

    private final Set<String> extractVariableNames(String value, Pattern regex) {
        Matcher matchPattern = regex.matcher(value);
        HashSet<String> vars = new HashSet<String>();
        while (matchPattern.find()) {
            vars.add(matchPattern.group(0));
        }
        return vars;
    }

    @Nullable
    public final String runCommand(@NotNull String $this$runCommand, @NotNull File workingDir, long timeoutAmount, @NotNull TimeUnit timeoutUnit) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$runCommand, (String)"$this$runCommand");
        Intrinsics.checkParameterIsNotNull((Object)workingDir, (String)"workingDir");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeoutUnit), (String)"timeoutUnit");
        try {
            object = $this$runCommand;
            String string = "\\s";
            int n = 0;
            Object object2 = new Regex(string);
            string = object2;
            n = 0;
            boolean bl = false;
            Object object3 = object2 = string.split((CharSequence)object, n);
            object = new ProcessBuilder((List<String>)object3).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            boolean bl2 = false;
            n = 0;
            Object $this$apply = object;
            boolean bl3 = false;
            ((Process)$this$apply).waitFor(timeoutAmount, timeoutUnit);
            Object object4 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"ProcessBuilder(split(\"\\\\\u2026outAmount, timeoutUnit) }");
            InputStream inputStream = ((Process)object4).getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"ProcessBuilder(split(\"\\\\\u2026             .inputStream");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            n = 0;
            Object object5 = object;
            int n2 = 0;
            object5 = new InputStreamReader((InputStream)object5, charset);
            n2 = 8192;
            boolean bl4 = false;
            object = TextStreamsKt.readText((Reader)(object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n2)));
        }
        catch (IOException e) {
            e.printStackTrace();
            object = "";
        }
        return object;
    }

    public static /* synthetic */ String runCommand$default(GitManifestsGenerator gitManifestsGenerator, String string, File file, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File(".");
        }
        if ((n & 2) != 0) {
            l = 60L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return gitManifestsGenerator.runCommand(string, file, l, timeUnit);
    }

    static {
        GIT_LOG_ENTRIES_DELIMITER = GIT_LOG_ENTRIES_DELIMITER;
    }

    public static final /* synthetic */ String access$getGIT_LOG_ENTRIES_DELIMITER$cp() {
        return GIT_LOG_ENTRIES_DELIMITER;
    }

    public static final /* synthetic */ Set access$extractVariableNames(GitManifestsGenerator $this, String value, Pattern regex) {
        return $this.extractVariableNames(value, regex);
    }

    public static final /* synthetic */ String access$pomVersion(GitManifestsGenerator $this, String sha, GenerateGitManifestsRequest generateGitManifestsRequest) {
        return $this.pomVersion(sha, generateGitManifestsRequest);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/saiprasadkrishnamurthy/sk8s/GitManifestsGenerator$Factory;", "", "()V", "GIT_LOG_ENTRIES_DELIMITER", "", "newInstance", "Lcom/github/saiprasadkrishnamurthy/sk8s/GitManifestsGenerator;", "springboot-manifest-maven-plugin"})
    public static final class Factory {
        @NotNull
        public final GitManifestsGenerator newInstance() {
            return new GitManifestsGenerator();
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

