/*
 * Decompiled with CFR 0.152.
 */
package com.github.saiprasadkrishnamurthy.sk8s;

import com.github.saiprasadkrishnamurthy.sk8s.GeneratePropsDocRequest;
import com.github.saiprasadkrishnamurthy.sk8s.YmlPropertiesDocumentationGenerator;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/saiprasadkrishnamurthy/sk8s/GenerateConfigDocsMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "configFileType", "", "outputDir", "project", "Lorg/apache/maven/project/MavenProject;", "skip", "", "execute", "", "springboot-manifest-maven-plugin"})
@Mojo(name="generate-config-docs", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public final class GenerateConfigDocsMojo
extends AbstractMojo {
    @Parameter(property="project")
    private MavenProject project;
    @Parameter(property="skip")
    private boolean skip;
    @Parameter(property="outputDir", defaultValue="target/manifests/k8s")
    private String outputDir;
    @Parameter(property="configFileType")
    private String configFileType = "yml";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().warn((CharSequence)" GenerateConfigDocsMojo disabled ");
        } else {
            try {
                MavenProject mavenProject = this.project;
                if (mavenProject == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                String groupId = mavenProject.getGroupId();
                MavenProject mavenProject2 = this.project;
                if (mavenProject2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                String artifactId = mavenProject2.getArtifactId();
                MavenProject mavenProject3 = this.project;
                if (mavenProject3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                String version = mavenProject3.getVersion();
                String string = this.outputDir;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
                }
                Paths.get(string, artifactId).toFile().mkdirs();
                Object object = StringCompanionObject.INSTANCE;
                String string2 = " Generating Config Docs for:  %s:%s:%s";
                Object object2 = new Object[]{groupId, artifactId, version};
                Log log = this.getLog();
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                log.info((CharSequence)string4);
                if (Intrinsics.areEqual((Object)this.configFileType, (Object)"yml") || Intrinsics.areEqual((Object)this.configFileType, (Object)"yaml")) {
                    YmlPropertiesDocumentationGenerator ymlPropertiesDocumentationGenerator = YmlPropertiesDocumentationGenerator.Factory.newInstance();
                    String string5 = artifactId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"artifactId");
                    String string6 = version;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"version");
                    MavenProject mavenProject4 = this.project;
                    if (mavenProject4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    }
                    File file = mavenProject4.getBasedir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.basedir");
                    String string7 = file.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"project.basedir.absolutePath");
                    String string8 = this.outputDir;
                    if (string8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
                    }
                    object = ((Object)Paths.get(string8, artifactId)).toString();
                    string2 = string7;
                    object2 = string6;
                    String string9 = string5;
                    ymlPropertiesDocumentationGenerator.generateDoc(new GeneratePropsDocRequest((String)object, string9, (String)object2, string2));
                } else {
                    this.getLog().error((CharSequence)"Unsupported Config Files format!");
                }
            }
            catch (Exception ex) {
                this.getLog().error((Throwable)ex);
                throw (Throwable)new RuntimeException(ex);
            }
        }
    }
}

