/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivemqLocalBroker
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(ActivemqLocalBroker.class);
    private final String hostName;
    private final Integer port;
    private final String queueName;
    private final String storeDir;
    private final String uriPrefix;
    private final String uriPostfix;
    private BrokerService broker;
    private Destination dest;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer producer;

    private ActivemqLocalBroker(Builder builder) {
        this.hostName = builder.hostName;
        this.port = builder.port;
        this.queueName = builder.queueName;
        this.storeDir = builder.storeDir;
        this.uriPrefix = builder.uriPrefix;
        this.uriPostfix = builder.uriPostfix;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public String getUriPostfix() {
        return this.uriPostfix;
    }

    public void start() throws Exception {
        String uri = this.uriPrefix + this.hostName + ":" + this.port;
        LOG.info("ACTIVEMQ: Starting ActiveMQ on {}", (Object)uri);
        this.configure();
        this.broker = new BrokerService();
        this.broker.addConnector(uri);
        this.broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri + this.uriPostfix);
        Connection conn = factory.createConnection();
        conn.start();
        this.session = conn.createSession(false, 1);
        this.dest = this.session.createQueue(this.queueName);
        this.consumer = this.session.createConsumer(this.dest);
        this.producer = this.session.createProducer(this.dest);
        this.producer.setDeliveryMode(1);
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("ACTIVEMQ: Stopping ActiveMQ");
        this.consumer.close();
        this.session.close();
        this.broker.stop();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        Properties props = System.getProperties();
        props.setProperty("activemq.store.dir", this.storeDir);
    }

    public void cleanUp() throws Exception {
        FileUtils.deleteFolder((String)this.storeDir);
    }

    public void sendTextMessage(String text) throws JMSException {
        TextMessage msg = this.session.createTextMessage(text);
        this.producer.send(this.dest, (Message)msg);
    }

    public String getTextMessage() throws JMSException {
        Message msg = this.consumer.receive(100L);
        return ((TextMessage)msg).getText();
    }

    public static class Builder {
        private String hostName;
        private Integer port;
        private String queueName;
        private String storeDir;
        private String uriPrefix;
        private String uriPostfix;

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder setStoreDir(String storeDir) {
            this.storeDir = storeDir;
            return this;
        }

        public Builder setUriPrefix(String uriPrefix) {
            this.uriPrefix = uriPrefix;
            return this;
        }

        public Builder setUriPostfix(String uriPostfix) {
            this.uriPostfix = uriPostfix;
            return this;
        }

        public ActivemqLocalBroker build() {
            ActivemqLocalBroker activemqLocalBroker = new ActivemqLocalBroker(this);
            this.validateObject(activemqLocalBroker);
            return activemqLocalBroker;
        }

        private void validateObject(ActivemqLocalBroker activemqLocalBroker) {
            if (activemqLocalBroker.hostName == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ HostName");
            }
            if (activemqLocalBroker.port == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ Port");
            }
            if (activemqLocalBroker.queueName == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ Queue Name");
            }
            if (activemqLocalBroker.storeDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ Store Dir");
            }
            if (activemqLocalBroker.uriPrefix == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ Uri Prefix");
            }
            if (activemqLocalBroker.uriPostfix == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: ActiveMQ Uri Postfix");
            }
        }
    }
}

