/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.auth;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class Jaas
extends Configuration {
    private static final String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    public static final String NL = "\n";
    private Map<String, AppConfigurationEntry> entries = new HashMap<String, AppConfigurationEntry>();

    public Jaas addServiceEntry(String name, String principal, String keytab, String serviceName) {
        Map<String, Object> options = Jaas.common(principal, keytab);
        options.put("serviceName", serviceName);
        this.entries.put(name, new AppConfigurationEntry(krb5LoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options));
        return this;
    }

    public Jaas addEntry(String name, String principal, String keytab) {
        Map<String, Object> options = Jaas.common(principal, keytab);
        this.entries.put(name, new AppConfigurationEntry(krb5LoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options));
        return this;
    }

    protected static Map<String, Object> common(String principal, String keytab) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("keyTab", keytab);
        options.put("principal", principal);
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("useTicketCache", "false");
        options.put("debug", "true");
        return options;
    }

    public void removeEntry(String name) {
        this.entries.remove(name);
    }

    public void clear() {
        this.entries.clear();
    }

    public Map<String, AppConfigurationEntry> getEntries() {
        return this.entries;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{this.entries.get(name)};
    }

    public String toFile() {
        StringBuilder builder = new StringBuilder();
        this.entries.forEach((e, v) -> {
            builder.append((String)e).append(" {").append(NL).append("\t").append(krb5LoginModuleName).append(" requiered").append(NL);
            v.getOptions().forEach((o, p) -> builder.append("\t").append((String)o).append(" = ").append("\"" + p + "\"").append(NL));
            builder.append("}");
        });
        return builder.toString();
    }
}

