/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    private static final String PROXY_PROPERTY_NAME = "HTTP_PROXY";
    private static final String ALL_PROXY_PROPERTY_NAME = "ALL_PROXY";

    public static void downloadFileWithProgress(String fileUrl, String outputFilePath) throws IOException {
        String fileName = fileUrl.substring(fileUrl.lastIndexOf(47) + 1);
        URL url = new URL(fileUrl);
        Proxy proxySettings = HttpUtils.returnProxyIfEnabled();
        HttpURLConnection httpURLConnection = proxySettings != null ? (HttpURLConnection)url.openConnection(proxySettings) : (HttpURLConnection)url.openConnection();
        long fileSize = httpURLConnection.getContentLength();
        if (!new File(outputFilePath).getParentFile().isDirectory()) {
            new File(outputFilePath).getParentFile().mkdirs();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(outputFilePath);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
        byte[] data = new byte[1024];
        long downloadedFileSize = 0L;
        Integer previousProgress = 0;
        int x = 0;
        while ((x = bufferedInputStream.read(data, 0, 1024)) >= 0) {
            int currentProgress = (int)((double)(downloadedFileSize += (long)x) / (double)fileSize * 100.0);
            if (!previousProgress.equals(currentProgress)) {
                LOG.info("HTTP: Download Status: Filename {} - {}% ({}/{})", new Object[]{fileName, currentProgress, downloadedFileSize, fileSize});
                previousProgress = currentProgress;
            }
            bufferedOutputStream.write(data, 0, x);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static Proxy returnProxyIfEnabled() {
        LOG.debug("returnProxyIfEnabled() start!!");
        String proxyStarturl = "http://";
        String proxyURLString = System.getProperty(PROXY_PROPERTY_NAME) != null ? System.getProperty(PROXY_PROPERTY_NAME) : System.getProperty(PROXY_PROPERTY_NAME.toLowerCase());
        String allproxyURLString = System.getProperty(ALL_PROXY_PROPERTY_NAME) != null ? System.getProperty(ALL_PROXY_PROPERTY_NAME) : System.getProperty(ALL_PROXY_PROPERTY_NAME.toLowerCase());
        String finalProxyString = proxyURLString != null ? proxyURLString : allproxyURLString;
        URL proxyURL = null;
        try {
            if (finalProxyString != null && finalProxyString.toLowerCase().startsWith(proxyStarturl)) {
                proxyURL = HttpUtils.returnParsedURL(finalProxyString);
                LOG.debug("protocol of proxy used is: " + proxyURL.getProtocol());
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort()));
            }
            if (finalProxyString != null && !finalProxyString.contains("://") && finalProxyString.split(":").length == 2) {
                LOG.debug("protocol of proxy used is: http default");
                proxyURL = HttpUtils.returnParsedURL(proxyStarturl.concat(finalProxyString));
                return proxyURL != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort())) : null;
            }
            if (finalProxyString != null && finalProxyString.toLowerCase().startsWith("sock") && finalProxyString.split("://").length == 2) {
                LOG.debug("protocol of proxy used is: Socks");
                proxyURL = HttpUtils.returnParsedURL(proxyStarturl.concat(finalProxyString.split("://")[1]));
                return proxyURL != null ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort())) : null;
            }
        }
        catch (MalformedURLException | URISyntaxException mUE) {
            LOG.error("Can not configure Proxy because URL {} is incorrect: " + mUE, (Object)finalProxyString);
        }
        return null;
    }

    private static URL returnParsedURL(String urlString) throws MalformedURLException, URISyntaxException {
        if (urlString != null) {
            URL url = new URL(urlString);
            url.toURI();
            LOG.info("System has been set to use proxy. Hence, configuring proxy URL: {}", (Object)urlString);
            return url;
        }
        return null;
    }
}

