/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void deleteFolder(String directory, final boolean quietly) {
        try {
            Path directoryPath = Paths.get(directory, new String[0]).toAbsolutePath();
            if (!quietly) {
                LOG.info("FILEUTILS: Deleting contents of directory: {}", (Object)directoryPath.toAbsolutePath().toString());
            }
            Files.walkFileTree(directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    if (!quietly) {
                        LOG.info("Removing file: {}", (Object)file.toAbsolutePath().toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    if (!quietly) {
                        LOG.info("Removing directory: {}", (Object)dir.toAbsolutePath().toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("FILEUTILS: Unable to remove {}", (Object)directory);
        }
    }

    public static void deleteFolder(String directory) {
        FileUtils.deleteFolder(directory, false);
    }

    public String toString() {
        return "FileUtils";
    }
}

