/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.util;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsLibsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsLibsUtils.class);

    public static void setHadoopHome() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String windowsLibDir = WindowsLibsUtils.getHadoopHome();
            LOG.info("WINDOWS: Setting hadoop.home.dir: {}", (Object)windowsLibDir);
            System.setProperty("hadoop.home.dir", windowsLibDir);
            System.load(new File(windowsLibDir + "/" + "lib" + "/" + "hadoop.dll").getAbsolutePath());
            System.load(new File(windowsLibDir + "/" + "lib" + "/" + "hdfs.dll").getAbsolutePath());
        }
    }

    public static String getHadoopHome() {
        LOG.info("HADOOP_HOME: " + System.getProperty("HADOOP_HOME"));
        if (System.getProperty("HADOOP_HOME") != null) {
            return System.getProperty("HADOOP_HOME");
        }
        File windowsLibDir = new File("./windows_libs/" + System.getProperty("hdp.release.version"));
        if (!windowsLibDir.exists() && !(windowsLibDir = new File("../" + windowsLibDir)).exists()) {
            LOG.error("WINDOWS: ERROR: Could not find windows native libs");
        }
        return windowsLibDir.getAbsolutePath();
    }
}

