/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbLocalServer
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MongodbLocalServer.class);
    private String ip;
    private Integer port;
    private MongodStarter starter;
    private MongodExecutable mongodExe;
    private MongodProcess mongod;
    private IMongodConfig conf;

    private MongodbLocalServer(Builder builder) {
        this.ip = builder.ip;
        this.port = builder.port;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void start() throws Exception {
        LOG.info("MONGODB: Starting MongoDB on {}:{}", (Object)this.ip, (Object)this.port);
        this.starter = MongodStarter.getDefaultInstance();
        this.configure();
        this.mongodExe = (MongodExecutable)this.starter.prepare((IExecutableProcessConfig)this.conf);
        this.mongod = (MongodProcess)this.mongodExe.start();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("MONGODB: Stopping MongoDB on {}:{}", (Object)this.ip, (Object)this.port);
        this.mongod.stop();
        this.mongodExe.stop();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        this.conf = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.PRODUCTION).net(new Net(this.ip, this.port.intValue(), false)).build();
    }

    public void cleanUp() throws Exception {
    }

    public static class Builder {
        private String ip;
        private Integer port;

        public Builder setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public MongodbLocalServer build() {
            MongodbLocalServer mongodbLocalServer = new MongodbLocalServer(this);
            this.validateObject(mongodbLocalServer);
            return mongodbLocalServer;
        }

        private void validateObject(MongodbLocalServer mongodbLocalServer) {
            if (mongodbLocalServer.ip == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: MongoDB IP");
            }
            if (mongodbLocalServer.port == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: MongoDB Port");
            }
        }
    }
}

