/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.kafka.producer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaReadfileProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaReadfileProducer.class);
    private String kafkaHostname;
    private Integer kafkaPort;
    private String topic;
    private String inputFileName;

    private KafkaReadfileProducer(Builder builder) {
        this.kafkaHostname = builder.kafkaHostname;
        this.kafkaPort = builder.kafkaPort;
        this.topic = builder.topic;
        this.inputFileName = builder.inputFileName;
    }

    public String getKafkaHostname() {
        return this.kafkaHostname;
    }

    public Integer getKafkaPort() {
        return this.kafkaPort;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceMessages() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.getKafkaHostname() + ":" + this.getKafkaPort());
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        ProducerConfig config = new ProducerConfig(props);
        try (Producer<Object, String> producer = new Producer<Object, String>(config);
             BufferedReader br = new BufferedReader(new FileReader(this.getInputFileName()));){
            String line = br.readLine();
            while (line != null) {
                KeyedMessage<Object, String> data = new KeyedMessage<Object, String>(this.getTopic(), null, line);
                producer.send(data);
                System.out.println(line);
                Thread.sleep(100L);
                line = br.readLine();
            }
        }
    }

    public static class Builder {
        private String kafkaHostname;
        private Integer kafkaPort;
        private String topic;
        private String inputFileName;

        public Builder setKafkaHostname(String kafkaHostname) {
            this.kafkaHostname = kafkaHostname;
            return this;
        }

        public Builder setKafkaPort(Integer kafkaPort) {
            this.kafkaPort = kafkaPort;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setInputFileName(String inputFileName) {
            this.inputFileName = inputFileName;
            return this;
        }

        public KafkaReadfileProducer build() {
            KafkaReadfileProducer kafkaReadfileProducer = new KafkaReadfileProducer(this);
            return kafkaReadfileProducer;
        }
    }
}

