/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.propertyparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParser {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyParser.class);
    private Properties props = new Properties();
    private String propFileName;

    public PropertyParser(String propFileName) {
        this.propFileName = propFileName;
    }

    public String getPropFileName() {
        return this.propFileName;
    }

    public void setPropFileName(String propFileName) {
        this.propFileName = propFileName;
    }

    public String getProperty(String key) {
        return this.props.get(key).toString();
    }

    public void parsePropsFile() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.propFileName);
        try {
            if (null == inputStream) {
                throw new IOException("Could not load property file from the resources directory, trying local");
            }
            this.props.load(inputStream);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
            try {
                inputStream = new FileInputStream(new File(this.propFileName).getAbsolutePath());
                this.props.load(inputStream);
            }
            catch (IOException ex) {
                LOG.error("Could not load property file at " + new File(this.propFileName).getAbsolutePath());
                ex.printStackTrace();
                throw ex;
            }
        }
    }
}

