/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.PartitionMetadata;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartitionMetadata$
implements ScalaObject,
Serializable {
    public static final PartitionMetadata$ MODULE$;

    static {
        new PartitionMetadata$();
    }

    public PartitionMetadata readFrom(ByteBuffer buffer$2, Map<Object, BrokerEndPoint> brokers) {
        short errorCode = ApiUtils$.MODULE$.readShortInRange(buffer$2, "error code", new Tuple2<Object, Object>(BoxesRunTime.boxToShort((short)-1), BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
        int partitionId = ApiUtils$.MODULE$.readIntInRange(buffer$2, "partition id", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        int leaderId = buffer$2.getInt();
        Option<BrokerEndPoint> leader = brokers.get(BoxesRunTime.boxToInteger(leaderId));
        int numReplicas = ApiUtils$.MODULE$.readIntInRange(buffer$2, "number of all replicas", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        IndexedSeq<Object> replicaIds = Predef$.MODULE$.intWrapper(0).until(numReplicas).map(new Serializable(buffer$2){
            public static final long serialVersionUID;
            private final ByteBuffer buffer$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int v1) {
                return this.buffer$2.getInt();
            }
            {
                this.buffer$2 = byteBuffer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq<BrokerEndPoint> replicas = replicaIds.map(brokers, IndexedSeq$.MODULE$.canBuildFrom());
        int numIsr = ApiUtils$.MODULE$.readIntInRange(buffer$2, "number of in-sync replicas", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        IndexedSeq<Object> isrIds = Predef$.MODULE$.intWrapper(0).until(numIsr).map(new Serializable(buffer$2){
            public static final long serialVersionUID;
            private final ByteBuffer buffer$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int x$3) {
                return this.apply$mcII$sp(x$3);
            }

            public int apply$mcII$sp(int v1) {
                return this.buffer$2.getInt();
            }
            {
                this.buffer$2 = byteBuffer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq<BrokerEndPoint> isr = isrIds.map(brokers, IndexedSeq$.MODULE$.canBuildFrom());
        return new PartitionMetadata(partitionId, leader, replicas, isr, errorCode);
    }

    public short init$default$5() {
        return ErrorMapping$.MODULE$.NoError();
    }

    public Seq init$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option unapply(PartitionMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple5<Integer, Option<BrokerEndPoint>, Seq<BrokerEndPoint>, Seq<BrokerEndPoint>, Short>>(new Tuple5<Integer, Option<BrokerEndPoint>, Seq<BrokerEndPoint>, Seq<BrokerEndPoint>, Short>(BoxesRunTime.boxToInteger(x$0.partitionId()), x$0.leader(), x$0.replicas(), x$0.isr(), BoxesRunTime.boxToShort(x$0.errorCode())));
    }

    public PartitionMetadata apply(int partitionId, Option leader, Seq replicas, Seq isr, short errorCode) {
        return new PartitionMetadata(partitionId, leader, replicas, isr, errorCode);
    }

    public short apply$default$5() {
        return ErrorMapping$.MODULE$.NoError();
    }

    public Seq apply$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Object readResolve() {
        return MODULE$;
    }

    private PartitionMetadata$() {
        MODULE$ = this;
    }
}

