/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements ScalaObject,
Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        Option<Object> option;
        block9: {
            if (brokerInfoString == null) {
                throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %s does not exist").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            Broker exceptionResult1 = null;
            try {
                Map map2;
                int version;
                Object a;
                option = Json$.MODULE$.parseFull(brokerInfoString);
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                Object m = a = some.x();
                Map brokerInfo = (Map)m;
                int n = version = BoxesRunTime.unboxToInt(brokerInfo.apply("version"));
                switch (n) {
                    default: {
                        throw new KafkaException(new StringBuilder().append((Object)"Unknown version of broker registration. Only versions 1 and 2 are supported.").append((Object)brokerInfoString).toString());
                    }
                    case 2: {
                        List listeners = (List)brokerInfo.apply("endpoints");
                        map2 = ((TraversableOnce)listeners.map(new Serializable(){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Tuple2<SecurityProtocol, EndPoint> apply(String listener) {
                                EndPoint ep = EndPoint$.MODULE$.createEndPoint(listener);
                                return new Tuple2<SecurityProtocol, EndPoint>(ep.protocolType(), ep);
                            }
                        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                        break;
                    }
                    case 1: {
                        String host = (String)brokerInfo.apply("host");
                        int port = BoxesRunTime.unboxToInt(brokerInfo.apply("port"));
                        map2 = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(SecurityProtocol.PLAINTEXT).$minus$greater(new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                    }
                }
                Map endpoints = map2;
                exceptionResult1 = new Broker(id, endpoints);
                return exceptionResult1;
            }
            catch (Throwable throwable) {
                throw new KafkaException(new StringBuilder().append((Object)"Failed to parse the broker info from zookeeper: ").append((Object)brokerInfoString).toString(), throwable);
            }
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        throw new MatchError(option);
    }

    public Broker readFrom(ByteBuffer buffer$1) {
        int id = buffer$1.getInt();
        int numEndpoints = buffer$1.getInt();
        Map<SecurityProtocol, EndPoint> endpoints = ((TraversableOnce)((TraversableLike)((TraversableLike)List$.MODULE$.range(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(numEndpoints), Numeric$IntIsIntegral$.MODULE$)).map(new Serializable(buffer$1){
            public static final long serialVersionUID;
            private final ByteBuffer buffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final EndPoint apply(int i) {
                return EndPoint$.MODULE$.readFrom(this.buffer$1);
            }
            {
                this.buffer$1 = byteBuffer;
            }
        }, List$.MODULE$.canBuildFrom())).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<SecurityProtocol, EndPoint> apply(EndPoint ep) {
                return Predef$.MODULE$.any2ArrowAssoc(ep.protocolType()).$minus$greater(ep);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return new Broker(id, endpoints);
    }

    public SecurityProtocol init$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Option unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Integer, Map<SecurityProtocol, EndPoint>>>(new Tuple2<Integer, Map<SecurityProtocol, EndPoint>>(BoxesRunTime.boxToInteger(x$0.id()), x$0.endPoints()));
    }

    public Broker apply(int id, Map endPoints) {
        return new Broker(id, endPoints);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

