/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements ScalaObject,
Serializable {
    public static final BrokerEndPoint$ MODULE$;

    static {
        new BrokerEndPoint$();
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        List<String> list;
        String string2;
        Regex uriParseExp = Predef$.MODULE$.augmentString("\\[?([0-9a-z\\-.:]*)\\]?:([0-9]+)").r();
        Option<List<String>> option = uriParseExp.unapplySeq(string2 = connectionString);
        if (!option.isEmpty() && ((list = option.get()) == null ? false : list.lengthCompare(2) == 0)) {
            return new BrokerEndPoint(brokerId, (String)list.apply(0), Predef$.MODULE$.augmentString((String)list.apply(1)).toInt());
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unable to parse ").append((Object)connectionString).append((Object)" to a broker endpoint").toString());
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public Option unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, String, Integer>>(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(x$0.id()), x$0.host(), BoxesRunTime.boxToInteger(x$0.port())));
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
    }
}

