/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.EndPoint$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ut!B\u0001\u0003\u0011\u000b9\u0011\u0001C#oIB{\u0017N\u001c;\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u000bY!\u0001C#oIB{\u0017N\u001c;\u0014\t%aAC\u0007\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\")a$\u0003C\u0001?\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u0006C%!\tAI\u0001\te\u0016\fGM\u0012:p[R\u00191%a\u0011\u0011\u0005!!c\u0001\u0002\u0006\u0003\u0001\u0016\u001aR\u0001\n\u0007\u0015Mi\u0001\"!F\u0014\n\u0005!2\"a\u0002)s_\u0012,8\r\u001e\u0005\tU\u0011\u0012)\u001a!C\u0001W\u0005!\u0001n\\:u+\u0005a\u0003CA\u00171\u001d\t)b&\u0003\u00020-\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyc\u0003\u0003\u00055I\tE\t\u0015!\u0003-\u0003\u0015Awn\u001d;!\u0011!1DE!f\u0001\n\u00039\u0014\u0001\u00029peR,\u0012\u0001\u000f\t\u0003+eJ!A\u000f\f\u0003\u0007%sG\u000f\u0003\u0005=I\tE\t\u0015!\u00039\u0003\u0015\u0001xN\u001d;!\u0011!qDE!f\u0001\n\u0003y\u0014\u0001\u00049s_R|7m\u001c7UsB,W#\u0001!\u0011\u0005\u0005[U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00039s_R|7m\u001c7\u000b\u0005\u00153\u0015AB2p[6|gN\u0003\u0002\u0006\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\ta%I\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"Aa\n\nB\tB\u0003%\u0001)A\u0007qe>$xnY8m)f\u0004X\r\t\u0005\u0006=\u0011\"\t\u0001\u0015\u000b\u0005GE\u00136\u000bC\u0003+\u001f\u0002\u0007A\u0006C\u00037\u001f\u0002\u0007\u0001\bC\u0003?\u001f\u0002\u0007\u0001\tC\u0003VI\u0011\u0005a+\u0001\td_:tWm\u0019;j_:\u001cFO]5oOR\tA\u0006C\u0003YI\u0011\u0005\u0011,A\u0004xe&$X\rV8\u0015\u0005ik\u0006CA\u000b\\\u0013\tafC\u0001\u0003V]&$\b\"\u00020X\u0001\u0004y\u0016A\u00022vM\u001a,'\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002c!\u0005\u0019a.[8\n\u0005\u0011\f'A\u0003\"zi\u0016\u0014UO\u001a4fe\")a\r\nC\u0001o\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u001dAG%!A\u0005\u0002%\fAaY8qsR!1E[6m\u0011\u001dQs\r%AA\u00021BqAN4\u0011\u0002\u0003\u0007\u0001\bC\u0004?OB\u0005\t\u0019\u0001!\t\u000f9$\u0013\u0013!C\u0001_\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00019+\u00051\n8&\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t9h#\u0001\u0006b]:|G/\u0019;j_:L!!\u001f;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004|IE\u0005I\u0011\u0001?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tQP\u000b\u00029c\"Aq\u0010JI\u0001\n\u0003\t\t!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\r!F\u0001!r\u0011\u001d\t9\u0001\nC!\u0003\u0013\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002q!1\u0011Q\u0002\u0013\u0005BY\u000b\u0001\u0002^8TiJLgn\u001a\u0005\b\u0003#!C\u0011IA\n\u0003\u0019)\u0017/^1mgR!\u0011QCA\u000e!\r)\u0012qC\u0005\u0004\u000331\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003;\ty!!AA\u0002\u0005}\u0011a\u0001=%cA\u0019Q#!\t\n\u0007\u0005\rbCA\u0002B]fDq!a\n%\t\u0003\nI#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\u00012!DA\u0017\u0013\t\td\u0002\u0003\u0004\u00022\u0011\"\teN\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\b\u0003k!C\u0011IA\u001c\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\b\u0002:!I\u0011QDA\u001a\u0003\u0003\u0005\r\u0001\u000f\u0005\b\u0003{!C\u0011IA \u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u000b\u0003\u0003B!\"!\b\u0002<\u0005\u0005\t\u0019AA\u0010\u0011\u0015q\u0006\u00051\u0001`\u0011\u001d\t9%\u0003C\u0001\u0003\u0013\nab\u0019:fCR,WI\u001c3Q_&tG\u000fF\u0002$\u0003\u0017Ba!VA#\u0001\u0004a\u0003\"CA(\u0013\u0005\u0005I\u0011QA)\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0019\u00131KA+\u0003/BaAKA'\u0001\u0004a\u0003B\u0002\u001c\u0002N\u0001\u0007\u0001\b\u0003\u0004?\u0003\u001b\u0002\r\u0001\u0011\u0005\n\u00037J\u0011\u0011!CA\u0003;\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002`\u0005-\u0004#B\u000b\u0002b\u0005\u0015\u0014bAA2-\t1q\n\u001d;j_:\u0004b!FA4Ya\u0002\u0015bAA5-\t1A+\u001e9mKNBq!!\u001c\u0002Z\u0001\u00071%A\u0002yIABq!!\u001d\n\t#\t\u0019(A\u0006sK\u0006$'+Z:pYZ,G#\u0001\u0007")
public class EndPoint
implements Product,
Serializable {
    private final String host;
    private final int port;
    private final SecurityProtocol protocolType;

    public static final EndPoint createEndPoint(String string2) {
        return EndPoint$.MODULE$.createEndPoint(string2);
    }

    public static final EndPoint readFrom(ByteBuffer byteBuffer) {
        return EndPoint$.MODULE$.readFrom(byteBuffer);
    }

    @Override
    public Iterator<Object> productIterator() {
        return Product$class.productIterator(this);
    }

    @Override
    public Iterator<Object> productElements() {
        return Product$class.productElements(this);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public SecurityProtocol protocolType() {
        return this.protocolType;
    }

    public String connectionString() {
        String hostport = this.host() == null ? new StringBuilder().append((Object)":").append(BoxesRunTime.boxToInteger(this.port())).toString() : Utils.formatAddress(this.host(), Predef$.MODULE$.int2Integer(this.port()));
        return new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd((Object)this.protocolType()).$plus("://")).append((Object)hostport).toString();
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.putInt(this.port());
        ApiUtils$.MODULE$.writeShortString(buffer, this.host());
        buffer.putShort(this.protocolType().id);
    }

    public int sizeInBytes() {
        return 4 + ApiUtils$.MODULE$.shortStringLength(this.host()) + 2;
    }

    public EndPoint copy(String host, int port, SecurityProtocol protocolType) {
        return new EndPoint(host, port, protocolType);
    }

    public SecurityProtocol copy$default$3() {
        return this.protocolType();
    }

    public int copy$default$2() {
        return this.port();
    }

    public String copy$default$1() {
        return this.host();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        SecurityProtocol securityProtocol;
        SecurityProtocol protocolType$1;
        int n;
        int port$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof EndPoint)) return false;
        EndPoint endPoint = (EndPoint)object2;
        String string2 = endPoint.host();
        String host$1 = string2;
        if (!this.gd1$1(host$1, port$1 = (n = endPoint.port()), protocolType$1 = (securityProtocol = endPoint.protocolType()))) return false;
        boolean bl = ((EndPoint)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    @Override
    public String productPrefix() {
        return "EndPoint";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
            }
            case 0: {
                object = this.host();
                break;
            }
            case 2: {
                object = this.protocolType();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger(this.port());
            }
        }
        return object;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof EndPoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd1$1(String string2, int n, SecurityProtocol securityProtocol) {
        String string3 = string2;
        String string4 = this.host();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (n != this.port()) return false;
        SecurityProtocol securityProtocol2 = securityProtocol;
        SecurityProtocol securityProtocol3 = this.protocolType();
        if (securityProtocol2 == null) {
            if (securityProtocol3 == null) return true;
            return false;
        } else {
            if (!((Object)((Object)securityProtocol2)).equals((Object)securityProtocol3)) return false;
            return true;
        }
    }

    public EndPoint(String host, int port, SecurityProtocol protocolType) {
        this.host = host;
        this.port = port;
        this.protocolType = protocolType;
        Product$class.$init$(this);
    }
}

