/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.NotEnoughReplicasException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.OffsetCheckpoint;
import kafka.server.OffsetManager;
import kafka.server.OffsetManager$;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011#\u0002\u0001\t!Ya\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\u000f5,GO]5dg&\u00111\u0004\u0007\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\bCA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"aC*dC2\fwJ\u00196fGRD\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u0006i>\u0004\u0018nY\u000b\u0002KA\u0011a%\u000b\b\u0003;\u001dJ!\u0001\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QyA\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0011=\u0002!Q1A\u0005\u0002A\n1\u0002]1si&$\u0018n\u001c8JIV\t\u0011\u0007\u0005\u0002\u001ee%\u00111G\b\u0002\u0004\u0013:$\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0011]\u0002!\u0011!Q\u0001\na\nA\u0001^5nKB\u0011\u0011#O\u0005\u0003uI\u0011A\u0001V5nK\"AA\b\u0001B\u0001B\u0003%Q(\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011AB:feZ,'/\u0003\u0002C\u007f\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0003G\u0011&S5\n\u0005\u0002H\u00015\t!\u0001C\u0003$\u0007\u0002\u0007Q\u0005C\u00030\u0007\u0002\u0007\u0011\u0007C\u00038\u0007\u0002\u0007\u0001\bC\u0003=\u0007\u0002\u0007Q\bC\u0004N\u0001\t\u0007I\u0011\u0002\u0019\u0002\u001b1|7-\u00197Ce>\\WM]%e\u0011\u0019y\u0005\u0001)A\u0005c\u0005qAn\\2bY\n\u0013xn[3s\u0013\u0012\u0004\u0003bB)\u0001\u0005\u0004%IAU\u0001\u000bY><W*\u00198bO\u0016\u0014X#A*\u0011\u0005Q;V\"A+\u000b\u0005Y#\u0011a\u00017pO&\u0011\u0001,\u0016\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bB\u0002.\u0001A\u0003%1+A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0003b\u0002/\u0001\u0005\u0004%I!X\u0001\tu.\u001cE.[3oiV\ta\f\u0005\u0002`M6\t\u0001M\u0003\u0002bE\u0006A!p[2mS\u0016tGO\u0003\u0002dI\u00061\u0011\nM%uK\u000eT\u0011!Z\u0001\u0004_J<\u0017BA4a\u0005!Q6n\u00117jK:$\bBB5\u0001A\u0003%a,A\u0005{W\u000ec\u0017.\u001a8uA!91\u000e\u0001b\u0001\n\u0013a\u0017AE1tg&<g.\u001a3SKBd\u0017nY1NCB,\u0012!\u001c\t\u0005#9\f\u0004/\u0003\u0002p%\t!\u0001k\\8m!\t9\u0015/\u0003\u0002s\u0005\t9!+\u001a9mS\u000e\f\u0007B\u0002;\u0001A\u0003%Q.A\nbgNLwM\\3e%\u0016\u0004H.[2b\u001b\u0006\u0004\b\u0005C\u0004w\u0001\t\u0007I\u0011B<\u0002'1,\u0017\rZ3s\u0013N\u0014X\u000b\u001d3bi\u0016dunY6\u0016\u0003a\u00042!_A\u0001\u001b\u0005Q(BA>}\u0003\u0015awnY6t\u0015\tih0\u0001\u0006d_:\u001cWO\u001d:f]RT!a \u0007\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0007Q(A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\u000f\u0005\u001d\u0001\u0001)A\u0005q\u0006!B.Z1eKJL5O]+qI\u0006$X\rT8dW\u0002B\u0001\"a\u0003\u0001\u0001\u0004%I\u0001M\u0001\nu.4VM]:j_:D\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\u0002\u001bi\\g+\u001a:tS>tw\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007u\t)\"C\u0002\u0002\u0018y\u0011A!\u00168ji\"I\u00111DA\u0007\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0004bBA\u0010\u0001\u0001\u0006K!M\u0001\u000bu.4VM]:j_:\u0004\u0003\u0002CA\u0012\u0001\u0001\u0007I\u0011\u0002\u0019\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003S\tq\u0002\\3bI\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0005\u0003'\tY\u0003C\u0005\u0002\u001c\u0005\u0015\u0012\u0011!a\u0001c!9\u0011q\u0006\u0001!B\u0013\t\u0014\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0003\u0006BA\u0017\u0003g\u00012!HA\u001b\u0013\r\t9D\b\u0002\tm>d\u0017\r^5mK\"I\u00111\b\u0001A\u0002\u0013\u0005\u0011QH\u0001\u0013Y\u0016\fG-\u001a:SKBd\u0017nY1JI>\u0003H/\u0006\u0002\u0002@A!Q$!\u00112\u0013\r\t\u0019E\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u001d\u0003\u00011A\u0005\u0002\u0005%\u0013A\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR|F%Z9\u0015\t\u0005M\u00111\n\u0005\u000b\u00037\t)%!AA\u0002\u0005}\u0002\u0002CA(\u0001\u0001\u0006K!a\u0010\u0002'1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u0012|\u0005\u000f\u001e\u0011)\t\u00055\u00131\u0007\u0005\n\u0003+\u0002\u0001\u0019!C\u0001\u0003/\na\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7/\u0006\u0002\u0002ZA)\u00111LA3a6\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005j[6,H/\u00192mK*\u0019\u00111\r\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005u#aA*fi\"I\u00111\u000e\u0001A\u0002\u0013\u0005\u0011QN\u0001\u0013S:\u001c\u0016P\\2SKBd\u0017nY1t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005=\u0004BCA\u000e\u0003S\n\t\u00111\u0001\u0002Z!A\u00111\u000f\u0001!B\u0013\tI&A\bj]NKhn\u0019*fa2L7-Y:!Q\u0011\t\t(a\r\t\u0011\u0005e\u0004\u00011A\u0005\nA\nqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\n\u0003{\u0002\u0001\u0019!C\u0005\u0003\u007f\n1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$B!a\u0005\u0002\u0002\"I\u00111DA>\u0003\u0003\u0005\r!\r\u0005\b\u0003\u000b\u0003\u0001\u0015)\u00032\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007\u0005C\u0004\u0002\n\u0002!I!a#\u0002\u001d%\u001c(+\u001a9mS\u000e\fGj\\2bYR!\u0011QRAJ!\ri\u0012qR\u0005\u0004\u0003#s\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+\u000b9\t1\u00012\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0001\u0002\u001c\u0006!A/Y4t+\t\ti\n\u0005\u0005\u0002\\\u0005}\u00151UAR\u0013\u0011\t\t+!\u0018\u0003\u00075\u000b\u0007\u000fE\u0002\n\u0003KK!A\u000b\u0006\t\u0011\u0005%\u0006\u0001)A\u0005\u0003;\u000bQ\u0001^1hg\u0002Bq!!,\u0001\t\u0003\ty+A\tjgVsG-\u001a:SKBd\u0017nY1uK\u0012$\"!!$\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006\u0011r-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2b)\r\u0001\u0018q\u0017\u0005\n\u0003+\u000b\t\f%AA\u0002EBq!a/\u0001\t\u0003\ti,\u0001\u0006hKR\u0014V\r\u001d7jG\u0006$B!a0\u0002BB!Q$!\u0011q\u0011%\t)*!/\u0011\u0002\u0003\u0007\u0011\u0007C\u0004\u0002F\u0002!\t!a2\u0002)1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m)\t\ty\fC\u0004\u0002L\u0002!\t!!4\u0002+\u0005$GMU3qY&\u001c\u0017-\u00134O_R,\u00050[:ugR\u0019\u0001/a4\t\u000f\u0005E\u0017\u0011\u001aa\u0001a\u00069!/\u001a9mS\u000e\f\u0007bBAk\u0001\u0011\u0005\u0011q[\u0001\u0011CN\u001c\u0018n\u001a8fIJ+\u0007\u000f\\5dCN$\"!!\u0017\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006i!/Z7pm\u0016\u0014V\r\u001d7jG\u0006$B!a\u0005\u0002`\"9\u0011QSAm\u0001\u0004\t\u0004bBAr\u0001\u0011\u0005\u0011Q]\u0001\u0007I\u0016dW\r^3\u0015\u0005\u0005M\u0001bBAu\u0001\u0011\u0005\u00111^\u0001\u000fO\u0016$H*Z1eKJ,\u0005o\\2i)\u0005\t\u0004bBAx\u0001\u0011\u0005\u0011\u0011_\u0001\u000b[\u0006\\W\rT3bI\u0016\u0014HCCAG\u0003g\f9Pa\u0002\u0003\f!9\u0011Q_Aw\u0001\u0004\t\u0014\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0002CA}\u0003[\u0004\r!a?\u0002%A\f'\u000f^5uS>t7\u000b^1uK&sgm\u001c\t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*\u0019!\u0011\u0001\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\u0006\u0005}(A\u0005)beRLG/[8o'R\fG/Z%oM>DqA!\u0003\u0002n\u0002\u0007\u0011'A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\t\u0005\u001b\ti\u000f1\u0001\u0003\u0010\u0005iqN\u001a4tKRl\u0015M\\1hKJ\u00042A\u0010B\t\u0013\r\u0011\u0019b\u0010\u0002\u000e\u001f\u001a47/\u001a;NC:\fw-\u001a:\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005aQ.Y6f\r>dGn\\<feRQ\u0011Q\u0012B\u000e\u0005;\u0011yB!\t\t\u000f\u0005U(Q\u0003a\u0001c!A\u0011\u0011 B\u000b\u0001\u0004\tY\u0010C\u0004\u0003\n\tU\u0001\u0019A\u0019\t\u0011\t5!Q\u0003a\u0001\u0005\u001fAqA!\n\u0001\t\u0003\u00119#\u0001\u000eva\u0012\fG/\u001a*fa2L7-\u0019'pOJ+\u0017\r\u001a*fgVdG\u000f\u0006\u0004\u0002\u0014\t%\"1\u0006\u0005\b\u0003+\u0013\u0019\u00031\u00012\u0011!\u0011iCa\tA\u0002\t=\u0012!\u00047pOJ+\u0017\r\u001a*fgVdG\u000fE\u0002?\u0005cI1Aa\r@\u00055aun\u001a*fC\u0012\u0014Vm];mi\"9!q\u0007\u0001\u0005\u0002\te\u0012AD7bs\n,W\t\u001f9b]\u0012L5O\u001d\u000b\u0005\u0003'\u0011Y\u0004C\u0004\u0002\u0016\nU\u0002\u0019A\u0019\t\u000f\t}\u0002\u0001\"\u0001\u0003B\u0005q2\r[3dW\u0016sw.^4i%\u0016\u0004H.[2bgJ+\u0017m\u00195PM\u001a\u001cX\r\u001e\u000b\u0005\u0005\u0007\u0012y\u0005E\u0004\u001e\u0005\u000b\niI!\u0013\n\u0007\t\u001dcD\u0001\u0004UkBdWM\r\t\u0004;\t-\u0013b\u0001B'=\t)1\u000b[8si\"A!\u0011\u000bB\u001f\u0001\u0004\u0011\u0019&\u0001\bsKF,\u0018N]3e\u001f\u001a47/\u001a;\u0011\u0007u\u0011)&C\u0002\u0003Xy\u0011A\u0001T8oO\"9!1\f\u0001\u0005\n\tu\u0013AF7bs\n,\u0017J\\2sK6,g\u000e\u001e'fC\u0012,'\u000fS,\u0015\t\u0005M!q\f\u0005\b\u0005C\u0012I\u00061\u0001q\u00035aW-\u00193feJ+\u0007\u000f\\5dC\"9!Q\r\u0001\u0005\u0002\t\u001d\u0014AD7bs\n,7\u000b\u001b:j].L5O\u001d\u000b\u0005\u0003'\u0011I\u0007\u0003\u0005\u0003l\t\r\u0004\u0019\u0001B*\u0003M\u0011X\r\u001d7jG\u0006l\u0015\r\u001f'bORKW.Z't\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005c\nAcZ3u\u001fV$xJZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001cHCBA-\u0005g\u0012)\bC\u0004\u0003b\t5\u0004\u0019\u00019\t\u0011\t]$Q\u000ea\u0001\u0005'\n\u0001\"\\1y\u0019\u0006<Wj\u001d\u0005\b\u0005w\u0002A\u0011\u0001B?\u0003Y\t\u0007\u000f]3oI6+7o]1hKN$v\u000eT3bI\u0016\u0014HC\u0002B@\u0005\u000b\u0013)\nE\u0002U\u0005\u0003K1Aa!V\u00055aunZ!qa\u0016tG-\u00138g_\"A!q\u0011B=\u0001\u0004\u0011I)\u0001\u0005nKN\u001c\u0018mZ3t!\u0011\u0011YI!%\u000e\u0005\t5%b\u0001BH\t\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BJ\u0005\u001b\u0013ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\b\"\u0003BL\u0005s\u0002\n\u00111\u00012\u00031\u0011X-];je\u0016$\u0017iY6t\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;\u000b\u0011\"\u001e9eCR,\u0017j\u001d:\u0015\t\u0005M!q\u0014\u0005\t\u0005C\u0013I\n1\u0001\u0002Z\u00051a.Z<JgJDqA!*\u0001\t\u0013\t)/\u0001\fsK6|g/\u001a)beRLG/[8o\u001b\u0016$(/[2t\u0011\u001d\u0011I\u000b\u0001C!\u0005W\u000ba!Z9vC2\u001cH\u0003BAG\u0005[C\u0001Ba,\u0003(\u0002\u0007!\u0011W\u0001\u0005i\"\fG\u000fE\u0002\u001e\u0005gK1A!.\u001f\u0005\r\te.\u001f\u0005\b\u0005s\u0003A\u0011IAv\u0003!A\u0017m\u001d5D_\u0012,\u0007b\u0002B_\u0001\u0011\u0005#qX\u0001\ti>\u001cFO]5oOR\tQ\u0005C\u0005\u0003D\u0002\t\n\u0011\"\u0001\u0003F\u0006ar-\u001a;Pe\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bI\u0011,g-Y;mi\u0012\nTC\u0001BdU\r\t$\u0011Z\u0016\u0003\u0005\u0017\u0004BA!4\u0003X6\u0011!q\u001a\u0006\u0005\u0005#\u0014\u0019.A\u0005v]\u000eDWmY6fI*\u0019!Q\u001b\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003Z\n='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\u001c\u0001\u0012\u0002\u0013\u0005!QY\u0001\u0015O\u0016$(+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000fJ\u0019\t\u0013\t\u0005\b!%A\u0005\u0002\t\u0015\u0017\u0001I1qa\u0016tG-T3tg\u0006<Wm\u001d+p\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uII\u0002")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    public final Time kafka$cluster$Partition$$time;
    public final ReplicaManager kafka$cluster$Partition$$replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager kafka$cluster$Partition$$logManager;
    private final ZkClient zkClient;
    private final Pool<Object, Replica> kafka$cluster$Partition$$assignedReplicaMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private volatile int kafka$cluster$Partition$$leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile scala.collection.immutable.Set<Replica> inSyncReplicas;
    private int kafka$cluster$Partition$$controllerEpoch;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Partition partition2 = this;
        synchronized (partition2) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    public final LogManager kafka$cluster$Partition$$logManager() {
        return this.kafka$cluster$Partition$$logManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public final Pool<Object, Replica> kafka$cluster$Partition$$assignedReplicaMap() {
        return this.kafka$cluster$Partition$$assignedReplicaMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    public final void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int kafka$cluster$Partition$$leaderEpoch() {
        return this.kafka$cluster$Partition$$leaderEpoch;
    }

    public final void kafka$cluster$Partition$$leaderEpoch_$eq(int n) {
        this.kafka$cluster$Partition$$leaderEpoch = n;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> option) {
        this.leaderReplicaIdOpt = option;
    }

    public scala.collection.immutable.Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(scala.collection.immutable.Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private int kafka$cluster$Partition$$controllerEpoch() {
        return this.kafka$cluster$Partition$$controllerEpoch;
    }

    public final void kafka$cluster$Partition$$controllerEpoch_$eq(int n) {
        this.kafka$cluster$Partition$$controllerEpoch = n;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.kafka$cluster$Partition$$localBrokerId();
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public boolean isUnderReplicated() {
        Option<Replica> option;
        block5: {
            boolean bl;
            block4: {
                block3: {
                    option = this.leaderReplicaIfLocal();
                    if (!(option instanceof Some)) break block3;
                    bl = this.inSyncReplicas().size() < this.assignedReplicas().size();
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public Replica getOrCreateReplica(int replicaId) {
        Option<Replica> option;
        block8: {
            Replica replica;
            block7: {
                Replica replica2;
                block6: {
                    Option<Replica> replicaOpt = this.getReplica(replicaId);
                    option = replicaOpt;
                    if (!(option instanceof Some)) break block6;
                    replica = (Replica)((Some)option).x();
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                if (this.isReplicaLocal(replicaId)) {
                    LogConfig config = LogConfig$.MODULE$.fromProps(this.kafka$cluster$Partition$$logManager().defaultConfig().toProps(), AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient(), this.topic()));
                    Log log2 = this.kafka$cluster$Partition$$logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                    OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.kafka$cluster$Partition$$replicaManager.highWatermarkCheckpoints().apply(log2.dir().getParentFile().getAbsolutePath());
                    Map<TopicAndPartition, Object> offsetMap = checkpoint.read();
                    if (!offsetMap.contains(new TopicAndPartition(this.topic(), this.partitionId()))) {
                        this.info((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;
                            private final Partition $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("No checkpointed highwatermark is found for partition [%s,%d]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                    }
                    long offset = BoxesRunTime.unboxToLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong(offsetMap.getOrElse(new TopicAndPartition(this.topic(), this.partitionId()), new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }))).min(BoxesRunTime.boxToLong(log2.logEndOffset())));
                    Replica localReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, offset, new Some<Log>(log2));
                    replica2 = this.addReplicaIfNotExists(localReplica);
                } else {
                    Replica remoteReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(remoteReplica);
                }
                replica = this.getReplica(replicaId).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.kafka$cluster$Partition$$assignedReplicaMap().get(BoxesRunTime.boxToInteger(replicaId));
        return replica == null ? None$.MODULE$ : new Some<Replica>(replica);
    }

    public int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Option<Object> option;
        block5: {
            Option option2;
            block4: {
                block3: {
                    option = this.leaderReplicaIdOpt();
                    if (!(option instanceof Some)) break block3;
                    option2 = BoxesRunTime.unboxToInt(((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.kafka$cluster$Partition$$assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger(replica.brokerId()), replica);
    }

    public scala.collection.immutable.Set<Replica> assignedReplicas() {
        return this.kafka$cluster$Partition$$assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.kafka$cluster$Partition$$assignedReplicaMap().remove(BoxesRunTime.boxToInteger(replicaId));
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this){
            public static final long serialVersionUID;
            private final Partition $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$cluster$Partition$$assignedReplicaMap().clear();
                this.$outer.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Set$.MODULE$.empty());
                this.$outer.leaderReplicaIdOpt_$eq(None$.MODULE$);
                try {
                    this.$outer.kafka$cluster$Partition$$logManager().deleteLog(new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId()));
                    this.$outer.kafka$cluster$Partition$$removePartitionMetrics();
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$delete$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Error deleting the log for partition [%s,%d]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, iOException){
                        public static final long serialVersionUID;
                        private final IOException e$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final IOException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = iOException;
                        }
                    }));
                    Runtime.getRuntime().halt(1);
                }
            }

            public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public int getLeaderEpoch() {
        return this.kafka$cluster$Partition$$leaderEpoch();
    }

    public boolean makeLeader(int controllerId, PartitionStateInfo partitionStateInfo$1, int correlationId, OffsetManager offsetManager$1) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, partitionStateInfo$1, offsetManager$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final PartitionStateInfo partitionStateInfo$1;
            private final OffsetManager offsetManager$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<Object> allReplicas = this.partitionStateInfo$1.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.partitionStateInfo$1.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                this.$outer.kafka$cluster$Partition$$controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                allReplicas.foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeader$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Replica apply(int replica) {
                        return this.$outer.kafka$cluster$Partition$$anonfun$$$outer().getOrCreateReplica(replica);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                scala.collection.immutable.Set<Replica> newInSyncReplicas = ((TraversableOnce)leaderAndIsr.isr().map(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeader$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Replica apply(int r) {
                        return this.$outer.kafka$cluster$Partition$$anonfun$$$outer().getOrCreateReplica(r);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.$outer.assignedReplicas().map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(Replica replica) {
                        return replica.brokerId();
                    }
                }, Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeader$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int n) {
                        this.apply$mcVI$sp(n);
                    }

                    public void apply$mcVI$sp(int v1) {
                        this.$outer.kafka$cluster$Partition$$anonfun$$$outer().removeReplica(v1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.inSyncReplicas_$eq(newInSyncReplicas);
                this.$outer.kafka$cluster$Partition$$leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                this.$outer.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                this.$outer.leaderReplicaIdOpt_$eq(new Some<Object>(BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$localBrokerId())));
                Replica newLeaderReplica = this.$outer.getReplica(this.$outer.getReplica$default$1()).get();
                newLeaderReplica.convertHWToLocalOffsetMetadata();
                this.$outer.assignedReplicas().foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeader$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Replica r) {
                        if (r.brokerId() != this.$outer.kafka$cluster$Partition$$anonfun$$$outer().kafka$cluster$Partition$$localBrokerId()) {
                            r.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(newLeaderReplica);
                String string2 = this.$outer.topic();
                String string3 = OffsetManager$.MODULE$.OffsetsTopicName();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.offsetManager$1.loadOffsetsFromLog(this.$outer.partitionId());
                }
                return true;
            }

            public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionStateInfo$1 = partitionStateInfo;
                this.offsetManager$1 = offsetManager;
            }
        }));
    }

    public boolean makeFollower(int controllerId, PartitionStateInfo partitionStateInfo$2, int correlationId, OffsetManager offsetManager$2) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, partitionStateInfo$2, offsetManager$2){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final PartitionStateInfo partitionStateInfo$2;
            public final OffsetManager offsetManager$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                Set<Object> allReplicas = this.partitionStateInfo$2.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.partitionStateInfo$2.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                int newLeaderBrokerId = leaderAndIsr.leader();
                this.$outer.kafka$cluster$Partition$$controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                allReplicas.foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeFollower$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Replica apply(int r) {
                        return this.$outer.kafka$cluster$Partition$$anonfun$$$outer().getOrCreateReplica(r);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ((IterableLike)((Subtractable)this.$outer.assignedReplicas().map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(Replica replica) {
                        return replica.brokerId();
                    }
                }, Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeFollower$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int n) {
                        this.apply$mcVI$sp(n);
                    }

                    public void apply$mcVI$sp(int v1) {
                        this.$outer.kafka$cluster$Partition$$anonfun$$$outer().removeReplica(v1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.inSyncReplicas_$eq((scala.collection.immutable.Set<Replica>)Set$.MODULE$.empty());
                this.$outer.kafka$cluster$Partition$$leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                this.$outer.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                this.$outer.leaderReplicaIdOpt().foreach(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$makeFollower$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int leaderReplica) {
                        this.apply$mcVI$sp(leaderReplica);
                    }

                    public void apply$mcVI$sp(int v1) {
                        String string2 = this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic();
                        String string3 = OffsetManager$.MODULE$.OffsetsTopicName();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && v1 == this.$outer.kafka$cluster$Partition$$anonfun$$$outer().kafka$cluster$Partition$$localBrokerId()) {
                            this.$outer.offsetManager$2.clearOffsetsInPartition(this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt(this.$outer.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                    bl = false;
                } else {
                    this.$outer.leaderReplicaIdOpt_$eq(new Some<Object>(BoxesRunTime.boxToInteger(newLeaderBrokerId)));
                    bl = true;
                }
                return bl;
            }

            public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionStateInfo$2 = partitionStateInfo;
                this.offsetManager$2 = offsetManager;
            }
        }));
    }

    public void updateReplicaLogReadResult(int replicaId$1, LogReadResult logReadResult$1) {
        Option<Replica> option = this.getReplica(replicaId$1);
        if (option instanceof Some) {
            ((Replica)((Some)option).x()).updateLogReadResult(logReadResult$1);
            this.maybeExpandIsr(replicaId$1);
            this.debug((Function0<String>)((Object)new Serializable(this, replicaId$1, logReadResult$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final int replicaId$1;
                private final LogReadResult logReadResult$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Recorded replica %d log end offset (LEO) position %d for partition %s.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replicaId$1), BoxesRunTime.boxToLong(this.logReadResult$1.info().fetchOffsetMetadata().messageOffset()), new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.replicaId$1 = n;
                    this.logReadResult$1 = logReadResult;
                }
            }));
            return;
        }
        None$ none$ = None$.MODULE$;
        Option<Replica> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new NotAssignedReplicaException(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d since the replica is not recognized to be one of the assigned replicas %s for partition [%s,%d]").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger(replicaId$1), logReadResult$1.info().fetchOffsetMetadata(), ((TraversableOnce)this.assignedReplicas().map(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Replica replica) {
                    return replica.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(","), this.topic(), BoxesRunTime.boxToInteger(this.partitionId())})));
        }
        throw new MatchError(option);
    }

    public void maybeExpandIsr(int replicaId$2) {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, replicaId$2){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final int replicaId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option<Replica> option;
                block6: {
                    block5: {
                        block4: {
                            Replica replica;
                            option = this.$outer.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Replica leaderReplica = replica = (Replica)some.x();
                            Replica replica2 = this.$outer.getReplica(this.replicaId$2).get();
                            LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                            if (!this.$outer.inSyncReplicas().contains(replica2) && ((SetLike)this.$outer.assignedReplicas().map(new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final int apply(Replica replica) {
                                    return replica.brokerId();
                                }
                            }, Set$.MODULE$.canBuildFrom())).contains(BoxesRunTime.boxToInteger(this.replicaId$2)) && replica2.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                                scala.collection.immutable.Set newInSyncReplicas$1 = (scala.collection.immutable.Set)this.$outer.inSyncReplicas().$plus(replica2);
                                this.$outer.info((Function0<String>)((Object)new Serializable(this, newInSyncReplicas$1){
                                    public static final long serialVersionUID;
                                    private final $anonfun$maybeExpandIsr$1 $outer;
                                    private final scala.collection.immutable.Set newInSyncReplicas$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Expanding ISR for partition [%s,%d] from %s to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), ((TraversableOnce)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().inSyncReplicas().map(new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$1.map(new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.newInSyncReplicas$1 = set;
                                    }
                                }));
                                this.$outer.kafka$cluster$Partition$$updateIsr(newInSyncReplicas$1);
                                this.$outer.kafka$cluster$Partition$$replicaManager.isrExpandRate().mark();
                            }
                            this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(leaderReplica);
                            break block5;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    }
                    return;
                }
                throw new MatchError(option);
            }

            public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$2 = n;
            }
        });
    }

    public Tuple2<Object, Object> checkEnoughReplicasReachOffset(long requiredOffset$1) {
        Option<Replica> option;
        block5: {
            Tuple2<Boolean, Short> tuple2;
            block4: {
                block3: {
                    Replica replica;
                    option = this.leaderReplicaIfLocal();
                    if (!(option instanceof Some)) break block3;
                    Some some = (Some)option;
                    Replica leaderReplica = replica = (Replica)some.x();
                    scala.collection.immutable.Set<Replica> curInSyncReplicas = this.inSyncReplicas();
                    int numAcks$1 = curInSyncReplicas.count((Function1<Replica, Object>)((Object)new Serializable(this, requiredOffset$1){
                        public static final long serialVersionUID;
                        private final Partition $outer;
                        public final long requiredOffset$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Replica r$1) {
                            boolean bl;
                            if (r$1.isLocal()) {
                                bl = true;
                            } else if (r$1.logEndOffset().messageOffset() >= this.requiredOffset$1) {
                                this.$outer.trace((Function0<String>)((Object)new Serializable(this, r$1){
                                    public static final long serialVersionUID;
                                    private final $anonfun$3 $outer;
                                    private final Replica r$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Replica %d of %s-%d received offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.r$1.brokerId()), this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), BoxesRunTime.boxToLong(this.$outer.requiredOffset$1)}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.r$1 = replica;
                                    }
                                }));
                                bl = true;
                            } else {
                                bl = false;
                            }
                            return bl;
                        }

                        public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.requiredOffset$1 = l;
                        }
                    }));
                    this.trace((Function0<String>)((Object)new Serializable(this, numAcks$1){
                        public static final long serialVersionUID;
                        private final Partition $outer;
                        private final int numAcks$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("%d acks satisfied for %s-%d with acks = -1").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.numAcks$1), this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.numAcks$1 = n;
                        }
                    }));
                    int minIsr = leaderReplica.log().get().config().minInSyncReplicas();
                    tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset$1 ? (minIsr <= curInSyncReplicas.size() ? new Tuple2<Boolean, Short>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NoError())) : new Tuple2<Boolean, Short>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NotEnoughReplicasAfterAppendCode()))) : new Tuple2<Boolean, Short>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NoError()));
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                tuple2 = new Tuple2<Boolean, Short>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    public final void kafka$cluster$Partition$$maybeIncrementLeaderHW(Replica leaderReplica) {
        scala.collection.immutable.Set allLogEndOffsets$1 = this.inSyncReplicas().map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LogOffsetMetadata apply(Replica replica) {
                return replica.logEndOffset();
            }
        }, Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark$1 = (LogOffsetMetadata)allLogEndOffsets$1.min(new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark$1 = leaderReplica.highWatermark();
        if (oldHighWatermark$1.precedes(newHighWatermark$1)) {
            leaderReplica.highWatermark_$eq(newHighWatermark$1);
            this.debug((Function0<String>)((Object)new Serializable(this, newHighWatermark$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("High watermark for partition [%s,%d] updated to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = logOffsetMetadata;
                }
            }));
            TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topic(), this.partitionId());
            this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(requestKey);
            this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedProduce(requestKey);
        } else {
            this.debug((Function0<String>)((Object)new Serializable(this, allLogEndOffsets$1, newHighWatermark$1, oldHighWatermark$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final scala.collection.immutable.Set allLogEndOffsets$1;
                private final LogOffsetMetadata newHighWatermark$1;
                private final LogOffsetMetadata oldHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Skipping update high watermark since Old hw %s is larger than new hw %s for partition [%s,%d]. All leo's are %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.oldHighWatermark$1, this.newHighWatermark$1, this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), this.allLogEndOffsets$1.mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allLogEndOffsets$1 = set;
                    this.newHighWatermark$1 = logOffsetMetadata;
                    this.oldHighWatermark$1 = logOffsetMetadata2;
                }
            }));
        }
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs$1) {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), new Serializable(this, replicaMaxLagTimeMs$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final long replicaMaxLagTimeMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option<Replica> option;
                block7: {
                    block6: {
                        block5: {
                            option = this.$outer.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Replica replica = (Replica)some.x();
                            Replica leaderReplica = replica;
                            scala.collection.immutable.Set<Replica> outOfSyncReplicas = this.$outer.getOutOfSyncReplicas(leaderReplica, this.replicaMaxLagTimeMs$1);
                            if (outOfSyncReplicas.size() > 0) {
                                scala.collection.immutable.Set newInSyncReplicas$2 = (scala.collection.immutable.Set)this.$outer.inSyncReplicas().$minus$minus((GenTraversableOnce<Replica>)outOfSyncReplicas);
                                Predef$.MODULE$.assert(newInSyncReplicas$2.size() > 0);
                                this.$outer.info((Function0<String>)((Object)new Serializable(this, newInSyncReplicas$2){
                                    public static final long serialVersionUID;
                                    private final $anonfun$maybeShrinkIsr$1 $outer;
                                    private final scala.collection.immutable.Set newInSyncReplicas$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Shrinking ISR for partition [%s,%d] from %s to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$cluster$Partition$$anonfun$$$outer().topic(), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$anonfun$$$outer().partitionId()), ((TraversableOnce)this.$outer.kafka$cluster$Partition$$anonfun$$$outer().inSyncReplicas().map(new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$2.map(new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.newInSyncReplicas$2 = set;
                                    }
                                }));
                                this.$outer.kafka$cluster$Partition$$updateIsr(newInSyncReplicas$2);
                                this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(leaderReplica);
                                this.$outer.kafka$cluster$Partition$$replicaManager.isrShrinkRate().mark();
                            }
                            break block6;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    }
                    return;
                }
                throw new MatchError(option);
            }

            public Partition kafka$cluster$Partition$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaMaxLagTimeMs$1 = l;
            }
        });
    }

    public scala.collection.immutable.Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs$1) {
        LogOffsetMetadata leaderLogEndOffset = leaderReplica.logEndOffset();
        scala.collection.immutable.Set candidateReplicas = (scala.collection.immutable.Set)this.inSyncReplicas().$minus(leaderReplica);
        scala.collection.immutable.Set laggingReplicas$1 = (scala.collection.immutable.Set)candidateReplicas.filter(new Serializable(this, maxLagMs$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final long maxLagMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica r) {
                return this.$outer.kafka$cluster$Partition$$time.milliseconds() - r.lastCaughtUpTimeMs() > this.maxLagMs$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxLagMs$1 = l;
            }
        });
        if (laggingReplicas$1.size() > 0) {
            this.debug((Function0<String>)((Object)new Serializable(this, laggingReplicas$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final scala.collection.immutable.Set laggingReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Lagging replicas for partition %s are %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{new TopicAndPartition(this.$outer.topic(), this.$outer.partitionId()), ((TraversableOnce)this.laggingReplicas$1.map(new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.laggingReplicas$1 = set;
                }
            }));
        }
        return laggingReplicas$1;
    }

    public LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages$1, int requiredAcks$1) {
        return (LogAppendInfo)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), new Serializable(this, messages$1, requiredAcks$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final ByteBufferMessageSet messages$1;
            private final int requiredAcks$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LogAppendInfo apply() {
                Option<Replica> leaderReplicaOpt = this.$outer.leaderReplicaIfLocal();
                Option<Replica> option = leaderReplicaOpt;
                if (option instanceof Some) {
                    Replica replica;
                    Some some = (Some)option;
                    Replica leaderReplica = replica = (Replica)some.x();
                    Log log2 = leaderReplica.log().get();
                    int minIsr = log2.config().minInSyncReplicas();
                    int inSyncSize = this.$outer.inSyncReplicas().size();
                    if (inSyncSize < minIsr && this.requiredAcks$1 == -1) {
                        throw new NotEnoughReplicasException(Predef$.MODULE$.augmentString("Number of insync replicas for partition [%s,%d] is [%d], below required minimum [%d]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), BoxesRunTime.boxToInteger(inSyncSize), BoxesRunTime.boxToInteger(minIsr)})));
                    }
                    LogAppendInfo info = log2.append(this.messages$1, true);
                    this.$outer.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.$outer.topic(), this.$outer.partitionId()));
                    this.$outer.kafka$cluster$Partition$$maybeIncrementLeaderHW(leaderReplica);
                    return info;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$localBrokerId())})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$1 = byteBufferMessageSet;
                this.requiredAcks$1 = n;
            }
        });
    }

    public int appendMessagesToLeader$default$2() {
        return 0;
    }

    public final void kafka$cluster$Partition$$updateIsr(scala.collection.immutable.Set<Replica> newIsr$1) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.kafka$cluster$Partition$$leaderEpoch(), ((TraversableOnce)newIsr$1.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Replica r) {
                return r.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), this.topic(), this.partitionId(), newLeaderAndIsr, this.kafka$cluster$Partition$$controllerEpoch(), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2<Object, Object> tuple22 = new Tuple2<Object, Object>(tuple2._1(), tuple2._2());
            boolean updateSucceeded = BoxesRunTime.unboxToBoolean(tuple22._1());
            int newVersion = tuple22._2$mcI$sp();
            if (updateSucceeded) {
                this.inSyncReplicas_$eq(newIsr$1);
                this.kafka$cluster$Partition$$zkVersion_$eq(newVersion);
                this.trace((Function0<String>)((Object)new Serializable(this, newIsr$1){
                    public static final long serialVersionUID;
                    private final Partition $outer;
                    private final scala.collection.immutable.Set newIsr$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.newIsr$1.mkString(","), BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newIsr$1 = set;
                    }
                }));
            } else {
                this.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Partition $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public final void kafka$cluster$Partition$$removePartitionMetrics() {
        this.removeMetric("UnderReplicated", this.tags());
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            Partition other = (Partition)that;
            return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
        partitionString.append(new StringBuilder().append((Object)"; Partition: ").append(BoxesRunTime.boxToInteger(this.partitionId())).toString());
        partitionString.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
        partitionString.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.kafka$cluster$Partition$$assignedReplicaMap().keys().mkString(",")).toString());
        partitionString.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Replica replica) {
                return replica.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
        return partitionString.toString();
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.kafka$cluster$Partition$$time = time;
        this.kafka$cluster$Partition$$replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.kafka$cluster$Partition$$logManager = replicaManager.logManager();
        this.zkClient = replicaManager.zkClient();
        this.kafka$cluster$Partition$$assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.kafka$cluster$Partition$$leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.kafka$cluster$Partition$$controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partitionId), BoxesRunTime.boxToInteger(this.kafka$cluster$Partition$$localBrokerId())})));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("topic").$minus$greater(topic), Predef$.MODULE$.any2ArrowAssoc("partition").$minus$greater(((Object)BoxesRunTime.boxToInteger(partitionId)).toString())}));
        this.newGauge("UnderReplicated", new Gauge<Object>(this){
            private final Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

