/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005A!M]8lKJLE-F\u0001 !\t9\u0002%\u0003\u0002\"1\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\tI!A\u000b\u0002\u0003\u0013A\u000b'\u000f^5uS>t\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003\u0011!\u0018.\\3\u0011\u0005E\u0001\u0014BA\u0019\u0013\u0005\u0011!\u0016.\\3\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011q#N\u0005\u0003ma\u0011A\u0001T8oO\"A\u0001\b\u0001BC\u0002\u0013\u0005\u0011(A\u0002m_\u001e,\u0012A\u000f\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005\u0019y\u0005\u000f^5p]B\u0011a\bQ\u0007\u0002\u007f)\u0011\u0001\bB\u0005\u0003\u0003~\u00121\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u0013Q\u0014\u0001\u00027pO\u0002BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u0002)\u0001!)Q\u0004\u0012a\u0001?!)Q\u0005\u0012a\u0001O!9a\u0006\u0012I\u0001\u0002\u0004y\u0003bB\u001aE!\u0003\u0005\r\u0001\u000e\u0005\bq\u0011\u0003\n\u00111\u0001;\u0011\u0019q\u0005\u0001)Q\u0005\u001f\u0006)\u0002.[4i/\u0006$XM]7be.lU\r^1eCR\f\u0007C\u0001)T\u001b\u0005\t&B\u0001*\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011A+\u0015\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007FA'W!\t9r+\u0003\u0002Y1\tAao\u001c7bi&dW\r\u0003\u0004[\u0001\u0001\u0006KaT\u0001\u0015Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1)\u0005e3\u0006bB/\u0001\u0005\u0004%\tAX\u0001\u0006i>\u0004\u0018nY\u000b\u0002?B\u0011\u0001m\u0019\b\u0003/\u0005L!A\u0019\r\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003EbAaa\u001a\u0001!\u0002\u0013y\u0016A\u0002;pa&\u001c\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u0001\u0010\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B\u0010\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000b5\u0004A\u0011\u00018\u0002\u000f%\u001cHj\\2bYV\tq\u000e\u0005\u0002\u0018a&\u0011\u0011\u000f\u0007\u0002\b\u0005>|G.Z1o\u0011\u0019\u0019\b\u0001)A\u0005i\u0006aB.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z't+:$WM\u001d7zS:<\u0007CA;}\u001b\u00051(BA<y\u0003\u0019\tGo\\7jG*\u0011\u0011P_\u0001\u000bG>t7-\u001e:sK:$(BA>\r\u0003\u0011)H/\u001b7\n\u0005u4(AC!u_6L7\rT8oO\"1q\u0010\u0001C\u0001\u0003\u0003\t!\u0003\\1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3NgV\tA\u0007C\u0004\u0002\u0006\u0001!\t!a\u0002\u0002'U\u0004H-\u0019;f\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\t\u0005%\u0011q\u0002\t\u0004/\u0005-\u0011bAA\u00071\t!QK\\5u\u0011!\t\t\"a\u0001A\u0002\u0005M\u0011!\u00047pOJ+\u0017\r\u001a*fgVdG\u000fE\u0002Q\u0003+I1!a\u0006R\u00055aun\u001a*fC\u0012\u0014Vm];mi\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011\u0001\u00057pO\u0016sGm\u00144gg\u0016$x\fJ3r)\u0011\tI!a\b\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001\u001f\u0006ya.Z<M_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002&\u0001!\t!a\n\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0016\u0003=Cq!a\u000b\u0001\t\u0003\ti#A\tiS\u001eDw+\u0019;fe6\f'o[0%KF$B!!\u0003\u00020!9\u0011\u0011GA\u0015\u0001\u0004y\u0015\u0001\u00058fo\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u001d\t)\u0004\u0001C\u0001\u0003O\tQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u001fG>tg/\u001a:u\u0011^#v\u000eT8dC2|eMZ:fi6+G/\u00193bi\u0006$\"!!\u0003\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\u00051Q-];bYN$2a\\A\"\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013\u0001\u0002;iCR\u00042aFA%\u0013\r\tY\u0005\u0007\u0002\u0004\u0003:L\bbBA(\u0001\u0011\u0005\u0013\u0011K\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0004C\u0004\u0002V\u0001!\t%a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012aX\u0004\n\u00037\u0012\u0011\u0011!E\u0003\u0003;\nqAU3qY&\u001c\u0017\rE\u0002)\u0003?2\u0001\"\u0001\u0002\u0002\u0002#\u0015\u0011\u0011M\n\u0005\u0003?Ba\u0003C\u0004F\u0003?\"\t!!\u001a\u0015\u0005\u0005u\u0003BCA5\u0003?\n\n\u0011\"\u0001\u0002l\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012\u001aTCAA7U\ry\u0013qN\u0016\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0010\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0000\u0005U$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111QA0#\u0003%\t!!\"\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0011\u0016\u0004i\u0005=\u0004BCAF\u0003?\n\n\u0011\"\u0001\u0002\u000e\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012*TCAAHU\rQ\u0014q\u000e")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private final String topic;
    private final int partitionId;
    private final AtomicLong lastCaughtUpTimeMsUnderlying;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Option init$default$5() {
        return Replica$.MODULE$.init$default$5();
    }

    public static final long init$default$4() {
        return Replica$.MODULE$.init$default$4();
    }

    public static final Time init$default$3() {
        return Replica$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Replica replica = this;
        synchronized (replica) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isLocal() {
        Option<Log> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.log();
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public long lastCaughtUpTimeMs() {
        return this.lastCaughtUpTimeMsUnderlying.get();
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        if (logReadResult.isReadFromLogEnd()) {
            this.lastCaughtUpTimeMsUnderlying.set(this.time.milliseconds());
        }
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Should not set log end offset on partition [%s,%d]'s local replica %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final Replica $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? this.log().get().logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark$1) {
        if (this.isLocal()) {
            this.highWatermarkMetadata = newHighWatermark$1;
            this.trace((Function0<String>)((Object)new scala.Serializable(this, newHighWatermark$1){
                public static final long serialVersionUID;
                private final Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Setting high watermark for replica %d partition [%s,%d] on broker %d to [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = logOffsetMetadata;
                }
            }));
            return;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Should not set high watermark on partition [%s,%d]'s non-local replica %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = this.log().get().convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
            return;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Should not construct complete high watermark on partition [%s,%d]'s non-local replica %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica other = (Replica)that;
            return this.topic().equals(other.topic()) && this.brokerId() == other.brokerId() && this.partition().equals(other.partition());
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append(BoxesRunTime.boxToInteger(this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append(BoxesRunTime.boxToInteger(this.partition().partitionId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append(BoxesRunTime.boxToBoolean(this.isLocal())).toString());
        Serializable serializable = this.isLocal() ? replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append(this.highWatermark()).toString()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition2, Time time, long initialHighWatermarkValue, Option<Log> log2) {
        this.brokerId = brokerId;
        this.partition = partition2;
        this.time = time;
        this.log = log2;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.init$default$2(), LogOffsetMetadata$.MODULE$.init$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.topic = partition2.topic();
        this.partitionId = partition2.partitionId();
        this.lastCaughtUpTimeMsUnderlying = new AtomicLong(time.milliseconds());
    }
}

