/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.text.NumberFormat;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Log$
implements ScalaObject {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.LogFileSuffix()).toString());
    }

    public File indexFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.IndexFileSuffix()).toString());
    }

    public TopicAndPartition parseTopicPartitionName(File dir) {
        String name = dir.getName();
        if (name == null || name.isEmpty() || !Predef$.MODULE$.augmentString(name).contains(BoxesRunTime.boxToCharacter('-'))) {
            this.throwException(dir);
        }
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partition2 = name.substring(index + 1);
        if (topic.length() < 1 || partition2.length() < 1) {
            this.throwException(dir);
        }
        return new TopicAndPartition(topic, Predef$.MODULE$.augmentString(partition2).toInt());
    }

    public void throwException(File dir) {
        throw new KafkaException(new StringBuilder().append((Object)"Found directory ").append((Object)dir.getCanonicalPath()).append((Object)", ").append((Object)"'").append((Object)dir.getName()).append((Object)"' is not in the form of topic-partition\n").append((Object)"If a directory does not contain Kafka topic data it should not exist in Kafka's log ").append((Object)"directory").toString());
    }

    public Time init$default$5() {
        return SystemTime$.MODULE$;
    }

    public long init$default$3() {
        return 0L;
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
    }
}

