/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.InvalidMessageSizeException;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.MessageSetSizeTooLargeException;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r5d\u0001B\u0001\u0003\u0001\u001d\u00111\u0001T8h\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n1\u0001Z5s+\u0005)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\r\u0003\tIw.\u0003\u0002+O\t!a)\u001b7f\u0011!a\u0003A!A!\u0002\u0013)\u0013\u0001\u00023je\u0002B\u0001B\f\u0001\u0003\u0002\u0004%\taL\u0001\u0007G>tg-[4\u0016\u0003A\u0002\"!\r\u001a\u000e\u0003\tI!a\r\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u001b\u0001\u0005\u0003\u0007I\u0011\u0001\u001c\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u00028uA\u0011Q\u0004O\u0005\u0003sy\u0011A!\u00168ji\"91\bNA\u0001\u0002\u0004\u0001\u0014a\u0001=%c!AQ\b\u0001B\u0001B\u0003&\u0001'A\u0004d_:4\u0017n\u001a\u0011)\u0005qz\u0004CA\u000fA\u0013\t\teD\u0001\u0005w_2\fG/\u001b7f\u0011!\u0019\u0005A!a\u0001\n\u0003!\u0015!\u0004:fG>4XM]=Q_&tG/F\u0001F!\tib)\u0003\u0002H=\t!Aj\u001c8h\u0011!I\u0005A!a\u0001\n\u0003Q\u0015!\u0005:fG>4XM]=Q_&tGo\u0018\u0013fcR\u0011qg\u0013\u0005\bw!\u000b\t\u00111\u0001F\u0011!i\u0005A!A!B\u0013)\u0015A\u0004:fG>4XM]=Q_&tG\u000f\t\u0015\u0003\u0019~B\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U\u0001\ng\u000eDW\rZ;mKJ\u0004\"!\u0005*\n\u0005M\u0013\"!C*dQ\u0016$W\u000f\\3s\u0011!)\u0006A!A!\u0002\u00131\u0016\u0001\u0002;j[\u0016\u0004\"!E,\n\u0005a\u0013\"\u0001\u0002+j[\u0016DQA\u0017\u0001\u0005\u0002m\u000ba\u0001P5oSRtDC\u0002/^=~\u0003\u0017\r\u0005\u00022\u0001!)1%\u0017a\u0001K!)a&\u0017a\u0001a!91)\u0017I\u0001\u0002\u0004)\u0005\"\u0002)Z\u0001\u0004\t\u0006bB+Z!\u0003\u0005\rA\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0003\u0011awnY6\u0016\u0003!AaA\u001a\u0001!\u0002\u0013A\u0011!\u00027pG.\u0004\u0003b\u00025\u0001\u0005\u0004%I![\u0001\u0010Y\u0006\u001cHO\u001a7vg\",G\rV5nKV\t!\u000e\u0005\u0002le6\tAN\u0003\u0002n]\u00061\u0011\r^8nS\u000eT!a\u001c9\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002r\u0019\u0005!Q\u000f^5m\u0013\t\u0019HN\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa!\u001e\u0001!\u0002\u0013Q\u0017\u0001\u00057bgR4G.^:iK\u0012$\u0016.\\3!\u0011\u001d9\bA1A\u0005\na\f\u0001b]3h[\u0016tGo]\u000b\u0002sB!!p_?\u0000\u001b\u0005q\u0017B\u0001?o\u0005Y\u0019uN\\2veJ,g\u000e\u001e(bm&<\u0017M\u00197f\u001b\u0006\u0004\bCA\u0005\u007f\u0013\t9%\u0002E\u00022\u0003\u0003I1!a\u0001\u0003\u0005)aunZ*fO6,g\u000e\u001e\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003z\u0003%\u0019XmZ7f]R\u001c\b\u0005C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0001\u0002\u000e\u0005\u0011b.\u001a=u\u001f\u001a47/\u001a;NKR\fG-\u0019;b+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005e\u00111\u0003\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007\"CA\u000f\u0001\u0001\u0007I\u0011AA\u0010\u0003YqW\r\u001f;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1`I\u0015\fHcA\u001c\u0002\"!I1(a\u0007\u0002\u0002\u0003\u0007\u0011q\u0002\u0005\t\u0003K\u0001\u0001\u0015)\u0003\u0002\u0010\u0005\u0019b.\u001a=u\u001f\u001a47/\u001a;NKR\fG-\u0019;bA!\u001a\u00111E \t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0012!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]V\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0003\u0002\r\r|W.\\8o\u0013\u0011\tI$a\r\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0018\u0003I!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0011\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0013\u0001\u0002;bON,\"!!\u0012\u0011\u0011\u0005\u001d\u0013\u0011KA+\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nS6lW\u000f^1cY\u0016T1!a\u0014\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\nIEA\u0002NCB\u00042!CA,\u0013\r\tIF\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005u\u0003\u0001)A\u0005\u0003\u000b\nQ\u0001^1hg\u0002Bq!!\u0019\u0001\t\u0003\t\u0019'\u0001\u0003oC6,WCAA+\u0011\u001d\t9\u0007\u0001C\u0005\u0003S\nA\u0002\\8bIN+w-\\3oiN$\u0012a\u000e\u0005\b\u0003[\u0002A\u0011BA8\u0003I)\b\u000fZ1uK2{w-\u00128e\u001f\u001a47/\u001a;\u0015\u0007]\n\t\bC\u0004\u0002t\u0005-\u0004\u0019A#\u0002\u001b5,7o]1hK>3gm]3u\u0011\u001d\t9\b\u0001C\u0005\u0003S\n!B]3d_Z,'\u000fT8h\u0011\u001d\tY\b\u0001C\u0005\u0003{\nA\u0003[1t\u00072,\u0017M\\*ikR$wn\u001e8GS2,GCAA@!\ri\u0012\u0011Q\u0005\u0004\u0003\u0007s\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003AqW/\u001c2fe>37+Z4nK:$8/\u0006\u0002\u0002\fB\u0019Q$!$\n\u0007\u0005=eDA\u0002J]RDq!a%\u0001\t\u0003\tI'A\u0003dY>\u001cX\rC\u0004\u0002\u0018\u0002!\t!!'\u0002\r\u0005\u0004\b/\u001a8e)\u0019\tY*!)\u00022B\u0019\u0011'!(\n\u0007\u0005}%AA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\t\u0003G\u000b)\n1\u0001\u0002&\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tY\u000bB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty+!+\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011)\t\u0019,!&\u0011\u0002\u0003\u0007\u0011qP\u0001\u000eCN\u001c\u0018n\u001a8PM\u001a\u001cX\r^:\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\u0006a\u0012M\\1msj,\u0017I\u001c3WC2LG-\u0019;f\u001b\u0016\u001c8/Y4f'\u0016$H\u0003BAN\u0003wC\u0001\"a)\u00026\u0002\u0007\u0011Q\u0015\u0005\b\u0003\u007f\u0003A\u0011BAa\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0004\u0002&\u0006\r\u0017Q\u0019\u0005\t\u0003G\u000bi\f1\u0001\u0002&\"A\u0011qYA_\u0001\u0004\tY*\u0001\u0003j]\u001a|\u0007bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0005e\u0016\fG\r\u0006\u0005\u0002P\u0006U\u0017\u0011\\Ao!\u0011\t\t\"!5\n\t\u0005M\u00171\u0003\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u000f\u0005]\u0017\u0011\u001aa\u0001\u000b\u0006Y1\u000f^1si>3gm]3u\u0011!\tY.!3A\u0002\u0005-\u0015!C7bq2+gn\u001a;i\u0011)\ty.!3\u0011\u0002\u0003\u0007\u0011\u0011]\u0001\n[\u0006DxJ\u001a4tKR\u0004B!HAr\u000b&\u0019\u0011Q\u001d\u0010\u0003\r=\u0003H/[8o\u0011\u001d\tI\u000f\u0001C\u0001\u0003W\fqcY8om\u0016\u0014H\u000fV8PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\t\u0005=\u0011Q\u001e\u0005\b\u0003_\f9\u000f1\u0001F\u0003\u0019ygMZ:fi\"9\u00111\u001f\u0001\u0005\u0002\u0005U\u0018!\u00053fY\u0016$Xm\u00147e'\u0016<W.\u001a8ugR!\u00111RA|\u0011!\tI0!=A\u0002\u0005m\u0018!\u00039sK\u0012L7-\u0019;f!\u0019i\u0012Q`@\u0002\u0000%\u0019\u0011q \u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0002B\u0002\u0001\u0011\u0005A)\u0001\u0003tSj,\u0007B\u0002B\u0004\u0001\u0011\u0005A)\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t-\u0001\u0001\"\u0001\u0002\u000e\u0005!Bn\\4F]\u0012|eMZ:fi6+G/\u00193bi\u0006DaAa\u0004\u0001\t\u0003!\u0015\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bb\u0002B\n\u0001\u0011%!QC\u0001\n[\u0006L(-\u001a*pY2$2a B\f\u0011!\u0011IB!\u0005A\u0002\u0005-\u0015\u0001D7fgN\fw-Z:TSj,\u0007b\u0002B\u000f\u0001\u0011\u0005!qD\u0001\u0005e>dG\u000eF\u0001\u0000\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005K\t\u0011#\u001e8gYV\u001c\b.\u001a3NKN\u001c\u0018mZ3t)\u0005)\u0005b\u0002B\u0015\u0001\u0011\u0005\u0011\u0011N\u0001\u0006M2,8\u000f\u001b\u0005\b\u0005S\u0001A\u0011\u0001B\u0017)\r9$q\u0006\u0005\b\u0003_\u0014Y\u00031\u0001F\u0011!\u0011\u0019\u0004\u0001C\u0001\u0005\u0005%\u0014A\u00023fY\u0016$X\r\u0003\u0005\u00038\u0001!\tA\u0001B\u001d\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004o\tm\u0002b\u0002B\u001f\u0005k\u0001\r!R\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\t\u0005\u0003\u0002A\u0011\u0001\u0002\u0003D\u00059BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0004o\t\u0015\u0003b\u0002B$\u0005\u007f\u0001\r!R\u0001\n]\u0016<xJ\u001a4tKRDqAa\u0013\u0001\t\u0003\u0011)#A\u0007mCN$h\t\\;tQRKW.\u001a\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u00035\t7\r^5wKN+w-\\3oiV\tq\u0010C\u0004\u0003V\u0001!\tAa\u0016\u0002\u00171|wmU3h[\u0016tGo]\u000b\u0003\u00053\u0002RAa\u0017\u0003l}tAA!\u0018\u0003h9!!q\fB3\u001b\t\u0011\tGC\u0002\u0003d\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0007\t%d$A\u0004qC\u000e\\\u0017mZ3\n\t\t5$q\u000e\u0002\t\u0013R,'/\u00192mK*\u0019!\u0011\u000e\u0010\t\u000f\tU\u0003\u0001\"\u0001\u0003tQ1!\u0011\fB;\u0005sBqAa\u001e\u0003r\u0001\u0007Q)\u0001\u0003ge>l\u0007b\u0002B>\u0005c\u0002\r!R\u0001\u0003i>DqAa \u0001\t\u0003\u0012\t)\u0001\u0005u_N#(/\u001b8h)\t\t)\u0006C\u0004\u0003\u0006\u0002!IAa\"\u0002\u001b\u0011,G.\u001a;f'\u0016<W.\u001a8u)\r9$\u0011\u0012\u0005\b\u0005\u0017\u0013\u0019\t1\u0001\u0000\u0003\u001d\u0019XmZ7f]RDqAa$\u0001\t\u0013\u0011\t*\u0001\nbgft7\rR3mKR,7+Z4nK:$HcA\u001c\u0003\u0014\"9!1\u0012BG\u0001\u0004y\b\u0002\u0003BL\u0001\u0011\u0005!A!'\u0002\u001fI,\u0007\u000f\\1dKN+w-\\3oiN$ra\u000eBN\u0005?\u0013I\u000bC\u0004\u0003\u001e\nU\u0005\u0019A@\u0002\u00159,woU3h[\u0016tG\u000f\u0003\u0005\u0003\"\nU\u0005\u0019\u0001BR\u0003-yG\u000eZ*fO6,g\u000e^:\u0011\u000b\tm#QU@\n\t\t\u001d&q\u000e\u0002\u0004'\u0016\f\bB\u0003BV\u0005+\u0003\n\u00111\u0001\u0002\u0000\u0005\u0019\u0012n\u001d*fG>4XM]3e'^\f\u0007OR5mK\"A!q\u0016\u0001\u0005\u0002\t\tI'\u0001\tsK6|g/\u001a'pO6+GO]5dg\"9!1\u0017\u0001\u0005\u0002\tU\u0016AC1eIN+w-\\3oiR\u0019qPa.\t\u000f\t-%\u0011\u0017a\u0001\u007f\"I!1\u0018\u0001\u0012\u0002\u0013\u0005!QX\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uII*\"Aa0+\t\u0005}$\u0011Y\u0016\u0003\u0005\u0007\u0004BA!2\u0003P6\u0011!q\u0019\u0006\u0005\u0005\u0013\u0014Y-A\u0005v]\u000eDWmY6fI*\u0019!Q\u001a\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003R\n\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!Q\u001b\u0001\u0012\u0002\u0013\u0005!QX\u0001\u001ae\u0016\u0004H.Y2f'\u0016<W.\u001a8ug\u0012\"WMZ1vYR$3\u0007C\u0005\u0003Z\u0002\t\n\u0011\"\u0001\u0003\\\u0006q!/Z1eI\u0011,g-Y;mi\u0012\u001aTC\u0001BoU\u0011\t\tO!1)\u0007\u0001\u0011\t\u000fE\u0002\u0012\u0005GL1A!:\u0013\u0005)!\bN]3bIN\fg-Z\u0004\b\u0005S\u0014\u0001R\u0001Bv\u0003\raun\u001a\t\u0004c\t5hAB\u0001\u0003\u0011\u000b\u0011yo\u0005\u0003\u0003n\"a\u0002b\u0002.\u0003n\u0012\u0005!1\u001f\u000b\u0003\u0005WD!Ba>\u0003n\n\u0007I\u0011AA2\u00035aun\u001a$jY\u0016\u001cVO\u001a4jq\"I!1 BwA\u0003%\u0011QK\u0001\u000f\u0019><g)\u001b7f'V4g-\u001b=!\u0011)\u0011yP!<C\u0002\u0013\u0005\u00111M\u0001\u0010\u0013:$W\r\u001f$jY\u0016\u001cVO\u001a4jq\"I11\u0001BwA\u0003%\u0011QK\u0001\u0011\u0013:$W\r\u001f$jY\u0016\u001cVO\u001a4jq\u0002B!ba\u0002\u0003n\n\u0007I\u0011AA2\u0003E!U\r\\3uK\u00124\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\n\u0007\u0017\u0011i\u000f)A\u0005\u0003+\n!\u0003R3mKR,GMR5mKN+hMZ5yA!Q1q\u0002Bw\u0005\u0004%\t!a\u0019\u0002#\rcW-\u00198fI\u001aKG.Z*vM\u001aL\u0007\u0010C\u0005\u0004\u0014\t5\b\u0015!\u0003\u0002V\u0005\u00112\t\\3b]\u0016$g)\u001b7f'V4g-\u001b=!\u0011)\u00199B!<C\u0002\u0013\u0005\u00111M\u0001\u000f'^\f\u0007OR5mKN+hMZ5y\u0011%\u0019YB!<!\u0002\u0013\t)&A\bTo\u0006\u0004h)\u001b7f'V4g-\u001b=!\u0011)\u0019yB!<C\u0002\u0013\u0005\u00111M\u0001\u0012\u00072,\u0017M\\*ikR$wn\u001e8GS2,\u0007\"CB\u0012\u0005[\u0004\u000b\u0011BA+\u0003I\u0019E.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0011\t\u0011\r\u001d\"Q\u001eC\u0001\u0007S\t\u0001DZ5mK:\fW.\u001a)sK\u001aL\u0007P\u0012:p[>3gm]3u)\u0011\u0019Yca\u000e\u0011\t\r521\u0007\b\u0004;\r=\u0012bAB\u0019=\u00051\u0001K]3eK\u001aLA!!\u0017\u00046)\u00191\u0011\u0007\u0010\t\u000f\u0005=8Q\u0005a\u0001\u000b\"A11\bBw\t\u0003\u0019i$A\u0006m_\u001e4\u0015\u000e\\3oC6,G#B\u0013\u0004@\r\u0005\u0003BB\u0012\u0004:\u0001\u0007Q\u0005C\u0004\u0002p\u000ee\u0002\u0019A#\t\u0011\r\u0015#Q\u001eC\u0001\u0007\u000f\nQ\"\u001b8eKb4\u0015\u000e\\3oC6,G#B\u0013\u0004J\r-\u0003BB\u0012\u0004D\u0001\u0007Q\u0005C\u0004\u0002p\u000e\r\u0003\u0019A#\t\u0011\r=#Q\u001eC\u0001\u0007#\nq\u0003]1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3\u0015\t\u0005=21\u000b\u0005\u0007G\r5\u0003\u0019A\u0013\t\u0011\r]#Q\u001eC\u0001\u00073\na\u0002\u001e5s_^,\u0005pY3qi&|g\u000eF\u00028\u00077BaaIB+\u0001\u0004)\u0003BCB0\u0005[\f\n\u0011\"\u0001\u0004b\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012\u001aTCAB2U\r)%\u0011\u0019\u0005\u000b\u0007O\u0012i/%A\u0005\u0002\r%\u0014AD5oSR$C-\u001a4bk2$H%N\u000b\u0003\u0007WR3A\u0016Ba\u0001")
public class Log
implements KafkaMetricsGroup {
    private final File dir;
    private volatile LogConfig config;
    private volatile long recoveryPoint;
    private final Scheduler scheduler;
    public final Time kafka$log$Log$$time;
    private final Object lock;
    private final AtomicLong lastflushedTime;
    private final ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments;
    private volatile LogOffsetMetadata nextOffsetMetadata;
    private final TopicAndPartition topicAndPartition;
    private final scala.collection.immutable.Map<String, String> tags;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$5() {
        return Log$.MODULE$.init$default$5();
    }

    public static final long init$default$3() {
        return Log$.MODULE$.init$default$3();
    }

    public static final void throwException(File file) {
        Log$.MODULE$.throwException(file);
    }

    public static final TopicAndPartition parseTopicPartitionName(File file) {
        return Log$.MODULE$.parseTopicPartitionName(file);
    }

    public static final File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static final File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static final String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static final String CleanShutdownFile() {
        return Log$.MODULE$.CleanShutdownFile();
    }

    public static final String SwapFileSuffix() {
        return Log$.MODULE$.SwapFileSuffix();
    }

    public static final String CleanedFileSuffix() {
        return Log$.MODULE$.CleanedFileSuffix();
    }

    public static final String DeletedFileSuffix() {
        return Log$.MODULE$.DeletedFileSuffix();
    }

    public static final String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static final String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Log log2 = this;
        synchronized (log2) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File dir() {
        return this.dir;
    }

    public LogConfig config() {
        return this.config;
    }

    public void config_$eq(LogConfig logConfig) {
        this.config = logConfig;
    }

    public long recoveryPoint() {
        return this.recoveryPoint;
    }

    public void recoveryPoint_$eq(long l) {
        this.recoveryPoint = l;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public final ConcurrentNavigableMap<Long, LogSegment> kafka$log$Log$$segments() {
        return this.kafka$log$Log$$segments;
    }

    public LogOffsetMetadata nextOffsetMetadata() {
        return this.nextOffsetMetadata;
    }

    public void nextOffsetMetadata_$eq(LogOffsetMetadata logOffsetMetadata) {
        this.nextOffsetMetadata = logOffsetMetadata;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    public String name() {
        return this.dir().getName();
    }

    private void loadSegments() {
        Object object;
        this.dir().mkdirs();
        ObjectRef swapFiles$1 = new ObjectRef((Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter(new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach(new scala.Serializable(this, swapFiles$1){
            public static final long serialVersionUID;
            private final ObjectRef swapFiles$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(File file) {
                if (file.canRead()) {
                    Serializable serializable;
                    String filename = file.getName();
                    if (filename.endsWith(Log$.MODULE$.DeletedFileSuffix()) || filename.endsWith(Log$.MODULE$.CleanedFileSuffix())) {
                        serializable = BoxesRunTime.boxToBoolean(file.delete());
                    } else if (filename.endsWith(Log$.MODULE$.SwapFileSuffix())) {
                        File baseName = new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                        if (baseName.getPath().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                            serializable = BoxesRunTime.boxToBoolean(file.delete());
                        } else if (baseName.getPath().endsWith(Log$.MODULE$.LogFileSuffix())) {
                            File index = new File(CoreUtils$.MODULE$.replaceSuffix(baseName.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix()));
                            index.delete();
                            this.swapFiles$1.elem = (Set)((Set)this.swapFiles$1.elem).$plus(file);
                            serializable = BoxedUnit.UNIT;
                        } else {
                            serializable = BoxedUnit.UNIT;
                        }
                    } else {
                        serializable = BoxedUnit.UNIT;
                    }
                    return serializable;
                }
                throw new IOException(new StringBuilder().append((Object)"Could not read file ").append(file).toString());
            }
            {
                this.swapFiles$1 = objectRef;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter(new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(File file) {
                return file.isFile();
            }
        }).foreach(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(File file$1) {
                Object object;
                String filename = file$1.getName();
                if (filename.endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    File logFile = new File(file$1.getAbsolutePath().replace(Log$.MODULE$.IndexFileSuffix(), Log$.MODULE$.LogFileSuffix()));
                    if (logFile.exists()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        this.$outer.warn((Function0<String>)((Object)new scala.Serializable(this, file$1){
                            public static final long serialVersionUID;
                            private final File file$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Found an orphaned index file, %s, with no corresponding log file.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.file$1.getAbsolutePath()}));
                            }
                            {
                                this.file$1 = file;
                            }
                        }));
                        object = BoxesRunTime.boxToBoolean(file$1.delete());
                    }
                } else if (filename.endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Serializable serializable;
                    long start = Predef$.MODULE$.augmentString(filename.substring(0, filename.length() - Log$.MODULE$.LogFileSuffix().length())).toLong();
                    boolean hasIndex = Log$.MODULE$.indexFilename(this.$outer.dir(), start).exists();
                    LogSegment segment$1 = new LogSegment(this.$outer.dir(), start, this.$outer.config().indexInterval(), this.$outer.config().maxIndexSize(), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time);
                    if (hasIndex) {
                        serializable = BoxedUnit.UNIT;
                    } else {
                        this.$outer.error((Function0<String>)((Object)new scala.Serializable(this, segment$1){
                            public static final long serialVersionUID;
                            private final LogSegment segment$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Could not find index file corresponding to log file %s, rebuilding index...").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.segment$1.log().file().getAbsolutePath()}));
                            }
                            {
                                this.segment$1 = logSegment;
                            }
                        }));
                        serializable = BoxesRunTime.boxToInteger(segment$1.recover(this.$outer.config().maxMessageSize()));
                    }
                    object = this.$outer.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(start), segment$1);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((Set)swapFiles$1.elem).foreach(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File swapFile$1) {
                File logFile = new File(CoreUtils$.MODULE$.replaceSuffix(swapFile$1.getPath(), Log$.MODULE$.SwapFileSuffix(), ""));
                String fileName = logFile.getName();
                long startOffset = Predef$.MODULE$.augmentString(fileName.substring(0, fileName.length() - Log$.MODULE$.LogFileSuffix().length())).toLong();
                File indexFile = new File(new StringBuilder().append((Object)CoreUtils$.MODULE$.replaceSuffix(logFile.getPath(), Log$.MODULE$.LogFileSuffix(), Log$.MODULE$.IndexFileSuffix())).append((Object)Log$.MODULE$.SwapFileSuffix()).toString());
                OffsetIndex index = new OffsetIndex(indexFile, startOffset, this.$outer.config().maxIndexSize());
                LogSegment swapSegment = new LogSegment(new FileMessageSet(swapFile$1), index, startOffset, this.$outer.config().indexInterval(), this.$outer.config().randomSegmentJitter(), this.$outer.kafka$log$Log$$time);
                this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, swapFile$1){
                    public static final long serialVersionUID;
                    private final File swapFile$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Found log file %s from interrupted swap operation, repairing.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.swapFile$1.getPath()}));
                    }
                    {
                        this.swapFile$1 = file;
                    }
                }));
                swapSegment.recover(this.$outer.config().maxMessageSize());
                Iterable<LogSegment> oldSegments = this.$outer.logSegments(swapSegment.baseOffset(), swapSegment.nextOffset());
                this.$outer.replaceSegments(swapSegment, oldSegments.toSeq(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (this.logSegments().size() == 0) {
            object = this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(0L), new LogSegment(this.dir(), 0L, this.config().indexInterval(), this.config().maxIndexSize(), this.config().randomSegmentJitter(), this.kafka$log$Log$$time));
        } else {
            this.recoverLog();
            this.activeSegment().index().resize(this.config().maxIndexSize());
            object = BoxedUnit.UNIT;
        }
        this.logSegments().foreach(new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment s) {
                s.index().sanityCheck();
            }
        });
    }

    private void updateLogEndOffset(long messageOffset) {
        this.nextOffsetMetadata_$eq(new LogOffsetMetadata(messageOffset, this.activeSegment().baseOffset(), (int)this.activeSegment().size()));
    }

    /*
     * Exception decompiling
     */
    private void recoverLog() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 146->163)] kafka.common.InvalidOffsetException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasCleanShutdownFile() {
        return new File(this.dir().getParentFile(), Log$.MODULE$.CleanShutdownFile()).exists();
    }

    public int numberOfSegments() {
        return this.kafka$log$Log$$segments().size();
    }

    public void close() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Closing log ").append((Object)this.$outer.name()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        Object object = this.lock();
        synchronized (object) {
            this.logSegments().foreach(new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment seg) {
                    seg.close();
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LogAppendInfo append(ByteBufferMessageSet messages$1, boolean assignOffsets) {
        LogAppendInfo appendInfo$1 = this.analyzeAndValidateMessageSet(messages$1);
        if (appendInfo$1.shallowCount() == 0) {
            return appendInfo$1;
        }
        ObjectRef validMessages$1 = new ObjectRef(this.trimInvalidBytes(messages$1, appendInfo$1));
        LogAppendInfo exceptionResult2 = null;
        try {
            Object object = this.lock();
            synchronized (object) {
                appendInfo$1.firstOffset_$eq(this.nextOffsetMetadata().messageOffset());
                if (assignOffsets) {
                    AtomicLong offset$1 = new AtomicLong(this.nextOffsetMetadata().messageOffset());
                    this.liftedTree1$1(appendInfo$1, validMessages$1, offset$1);
                    appendInfo$1.lastOffset_$eq(offset$1.get() - 1L);
                } else {
                    if (!appendInfo$1.offsetsMonotonic()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Out of order offsets found in ").append(messages$1).toString());
                    if (appendInfo$1.firstOffset() < this.nextOffsetMetadata().messageOffset()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Out of order offsets found in ").append(messages$1).toString());
                }
                ((ByteBufferMessageSet)validMessages$1.elem).shallowIterator().foreach(new scala.Serializable(this, messages$1){
                    public static final long serialVersionUID;
                    private final Log $outer;
                    private final ByteBufferMessageSet messages$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MessageAndOffset messageAndOffset) {
                        if (MessageSet$.MODULE$.entrySize(messageAndOffset.message()) > this.$outer.config().maxMessageSize()) {
                            BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark(this.messages$1.sizeInBytes());
                            BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark(this.messages$1.sizeInBytes());
                            throw new MessageSizeTooLargeException(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(MessageSet$.MODULE$.entrySize(messageAndOffset.message())), BoxesRunTime.boxToInteger(this.$outer.config().maxMessageSize())})));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.messages$1 = byteBufferMessageSet;
                    }
                });
                if (((ByteBufferMessageSet)validMessages$1.elem).sizeInBytes() > this.config().segmentSize()) {
                    throw new MessageSetSizeTooLargeException(Predef$.MODULE$.augmentString("Message set size is %d bytes which exceeds the maximum configured segment size of %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(((ByteBufferMessageSet)validMessages$1.elem).sizeInBytes()), BoxesRunTime.boxToInteger(this.config().segmentSize())})));
                }
                LogSegment segment = this.maybeRoll(((ByteBufferMessageSet)validMessages$1.elem).sizeInBytes());
                segment.append(appendInfo$1.firstOffset(), (ByteBufferMessageSet)validMessages$1.elem);
                this.updateLogEndOffset(appendInfo$1.lastOffset() + 1L);
                this.trace((Function0<String>)((Object)new scala.Serializable(this, appendInfo$1, validMessages$1){
                    public static final long serialVersionUID;
                    private final Log $outer;
                    private final LogAppendInfo appendInfo$1;
                    private final ObjectRef validMessages$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Appended message set to log %s with first offset: %d, next offset: %d, and messages: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name(), BoxesRunTime.boxToLong(this.appendInfo$1.firstOffset()), BoxesRunTime.boxToLong(this.$outer.nextOffsetMetadata().messageOffset()), (ByteBufferMessageSet)this.validMessages$1.elem}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.appendInfo$1 = logAppendInfo;
                        this.validMessages$1 = objectRef;
                    }
                }));
                if (this.unflushedMessages() >= this.config().flushInterval()) {
                    this.flush();
                }
                LogAppendInfo logAppendInfo = appendInfo$1;
                return logAppendInfo;
            }
        }
        catch (IOException iOException) {
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name()})), iOException);
        }
    }

    public boolean append$default$2() {
        return true;
    }

    private LogAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet messages$2) {
        IntRef shallowMessageCount$1 = new IntRef(0);
        IntRef validBytesCount$1 = new IntRef(0);
        LongRef firstOffset$2 = new LongRef(-1L);
        LongRef lastOffset$2 = new LongRef(-1L);
        ObjectRef sourceCodec$2 = new ObjectRef(NoCompressionCodec$.MODULE$);
        BooleanRef monotonic$1 = new BooleanRef(true);
        messages$2.shallowIterator().foreach(new scala.Serializable(this, messages$2, shallowMessageCount$1, validBytesCount$1, firstOffset$2, lastOffset$2, sourceCodec$2, monotonic$1){
            public static final long serialVersionUID;
            private final Log $outer;
            private final ByteBufferMessageSet messages$2;
            private final IntRef shallowMessageCount$1;
            private final IntRef validBytesCount$1;
            private final LongRef firstOffset$2;
            private final LongRef lastOffset$2;
            private final ObjectRef sourceCodec$2;
            private final BooleanRef monotonic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MessageAndOffset messageAndOffset) {
                CompressionCodec messageCodec;
                if (this.firstOffset$2.elem < 0L) {
                    this.firstOffset$2.elem = messageAndOffset.offset();
                }
                if (this.lastOffset$2.elem >= messageAndOffset.offset()) {
                    this.monotonic$1.elem = false;
                }
                this.lastOffset$2.elem = messageAndOffset.offset();
                Message m = messageAndOffset.message();
                int messageSize = MessageSet$.MODULE$.entrySize(m);
                if (messageSize > this.$outer.config().maxMessageSize()) {
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.$outer.topicAndPartition().topic()).bytesRejectedRate().mark(this.messages$2.sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesRejectedRate().mark(this.messages$2.sizeInBytes());
                    throw new MessageSizeTooLargeException(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(messageSize), BoxesRunTime.boxToInteger(this.$outer.config().maxMessageSize())})));
                }
                m.ensureValid();
                ++this.shallowMessageCount$1.elem;
                this.validBytesCount$1.elem += messageSize;
                CompressionCodec compressionCodec = messageCodec = m.compressionCodec();
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) {
                    this.sourceCodec$2.elem = messageCodec;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$2 = byteBufferMessageSet;
                this.shallowMessageCount$1 = intRef;
                this.validBytesCount$1 = intRef2;
                this.firstOffset$2 = longRef;
                this.lastOffset$2 = longRef2;
                this.sourceCodec$2 = objectRef;
                this.monotonic$1 = booleanRef;
            }
        });
        CompressionCodec targetCodec = BrokerCompressionCodec$.MODULE$.getTargetCompressionCodec(this.config().compressionType(), (CompressionCodec)sourceCodec$2.elem);
        return new LogAppendInfo(firstOffset$2.elem, lastOffset$2.elem, (CompressionCodec)sourceCodec$2.elem, targetCodec, shallowMessageCount$1.elem, validBytesCount$1.elem, monotonic$1.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet messages, LogAppendInfo info) {
        ByteBufferMessageSet byteBufferMessageSet;
        int messageSetValidBytes = info.validBytes();
        if (messageSetValidBytes < 0) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Illegal length of message set ").append(BoxesRunTime.boxToInteger(messageSetValidBytes)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        if (messageSetValidBytes == messages.sizeInBytes()) {
            byteBufferMessageSet = messages;
        } else {
            ByteBuffer validByteBuffer = messages.buffer().duplicate();
            validByteBuffer.limit(messageSetValidBytes);
            byteBufferMessageSet = new ByteBufferMessageSet(validByteBuffer);
        }
        return byteBufferMessageSet;
    }

    public FetchDataInfo read(long startOffset$2, int maxLength$1, Option<Object> maxOffset) {
        FetchDataInfo fetchInfo;
        this.trace((Function0<String>)((Object)new scala.Serializable(this, startOffset$2, maxLength$1){
            public static final long serialVersionUID;
            private final Log $outer;
            private final long startOffset$2;
            private final int maxLength$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Reading %d bytes from offset %d in log %s of length %d bytes").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxLength$1), BoxesRunTime.boxToLong(this.startOffset$2), this.$outer.name(), BoxesRunTime.boxToLong(this.$outer.size())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startOffset$2 = l;
                this.maxLength$1 = n;
            }
        }));
        long next2 = this.nextOffsetMetadata().messageOffset();
        if (startOffset$2 == next2) {
            return new FetchDataInfo(this.nextOffsetMetadata(), MessageSet$.MODULE$.Empty());
        }
        Map.Entry entry2 = this.kafka$log$Log$$segments().floorEntry(Predef$.MODULE$.long2Long(startOffset$2));
        if (startOffset$2 > next2 || entry2 == null) {
            throw new OffsetOutOfRangeException(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(startOffset$2), this.kafka$log$Log$$segments().firstKey(), BoxesRunTime.boxToLong(next2)})));
        }
        while (true) {
            if (entry2 == null) {
                return new FetchDataInfo(this.nextOffsetMetadata(), MessageSet$.MODULE$.Empty());
            }
            fetchInfo = ((LogSegment)entry2.getValue()).read(startOffset$2, maxOffset, maxLength$1);
            if (fetchInfo != null) break;
            entry2 = this.kafka$log$Log$$segments().higherEntry(entry2.getKey());
        }
        return fetchInfo;
    }

    public Option read$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public LogOffsetMetadata convertToOffsetMetadata(long offset) {
        void var3_2;
        LogOffsetMetadata exceptionResult3 = null;
        try {
            FetchDataInfo fetchDataInfo = this.read(offset, 1, this.read$default$3());
            exceptionResult3 = fetchDataInfo.fetchOffsetMetadata();
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            exceptionResult3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        }
        return var3_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteOldSegments(Function1<LogSegment, Object> predicate$1) {
        BoxedUnit boxedUnit;
        LogSegment lastSegment$1 = this.activeSegment();
        Iterable deletable = (Iterable)this.logSegments().takeWhile((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, predicate$1, lastSegment$1){
            public static final long serialVersionUID;
            private final Function1 predicate$1;
            private final LogSegment lastSegment$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment s) {
                return BoxesRunTime.unboxToBoolean(this.predicate$1.apply(s)) && (s.baseOffset() != this.lastSegment$1.baseOffset() || s.size() > 0L);
            }
            {
                this.predicate$1 = function1;
                this.lastSegment$1 = logSegment;
            }
        }));
        int numToDelete = deletable.size();
        if (numToDelete <= 0) {
            boxedUnit = BoxedUnit.UNIT;
            return numToDelete;
        }
        Object object = this.lock();
        synchronized (object) {
            Object object2 = this.kafka$log$Log$$segments().size() == numToDelete ? this.roll() : BoxedUnit.UNIT;
            deletable.foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment logSegment) {
                    this.$outer.kafka$log$Log$$deleteSegment(logSegment);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit2;
            return numToDelete;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong(((TraversableOnce)this.logSegments().map(new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(LogSegment logSegment) {
                return logSegment.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$));
    }

    public long logStartOffset() {
        return ((LogSegment)this.logSegments().head()).baseOffset();
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.nextOffsetMetadata();
    }

    public long logEndOffset() {
        return this.nextOffsetMetadata().messageOffset();
    }

    private LogSegment maybeRoll(int messagesSize) {
        LogSegment logSegment;
        LogSegment segment$3 = this.activeSegment();
        if (segment$3.size() > (long)(this.config().segmentSize() - messagesSize) || segment$3.size() > 0L && this.kafka$log$Log$$time.milliseconds() - segment$3.created() > this.config().segmentMs() - segment$3.rollJitterMs() || segment$3.index().isFull()) {
            this.debug((Function0<String>)((Object)new scala.Serializable(this, segment$3){
                public static final long serialVersionUID;
                private final Log $outer;
                private final LogSegment segment$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Rolling new log segment in %s (log_size = %d/%d, index_size = %d/%d, age_ms = %d/%d).").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name(), BoxesRunTime.boxToLong(this.segment$3.size()), BoxesRunTime.boxToInteger(this.$outer.config().segmentSize()), BoxesRunTime.boxToInteger(this.segment$3.index().entries()), BoxesRunTime.boxToInteger(this.segment$3.index().maxEntries()), BoxesRunTime.boxToLong(this.$outer.kafka$log$Log$$time.milliseconds() - this.segment$3.created()), BoxesRunTime.boxToLong(this.$outer.config().segmentMs() - this.segment$3.rollJitterMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.segment$3 = logSegment;
                }
            }));
            logSegment = this.roll();
        } else {
            logSegment = segment$3;
        }
        return logSegment;
    }

    public LogSegment roll() {
        long start$1 = this.kafka$log$Log$$time.nanoseconds();
        Object object = this.lock();
        synchronized (object) {
            long newOffset$1;
            block5: {
                LogSegment segment;
                LogSegment prev;
                newOffset$1 = this.logEndOffset();
                File logFile = Log$.MODULE$.logFilename(this.dir(), newOffset$1);
                File indexFile = Log$.MODULE$.indexFilename(this.dir(), newOffset$1);
                List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new File[]{logFile, indexFile})).withFilter(new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(File file) {
                        return file.exists();
                    }
                }).foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final Log $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(File file$2) {
                        this.$outer.warn((Function0<String>)((Object)new scala.Serializable(this, file$2){
                            public static final long serialVersionUID;
                            private final File file$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Newly rolled segment file ").append((Object)this.file$2.getName()).append((Object)" already exists; deleting it first").toString();
                            }
                            {
                                this.file$2 = file;
                            }
                        }));
                        return file$2.delete();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map.Entry entry2 = this.kafka$log$Log$$segments().lastEntry();
                if (entry2 != null) {
                    ((LogSegment)entry2.getValue()).index().trimToValidSize();
                }
                if ((prev = this.addSegment(segment = new LogSegment(this.dir(), newOffset$1, this.config().indexInterval(), this.config().maxIndexSize(), this.config().randomSegmentJitter(), this.kafka$log$Log$$time))) != null) break block5;
                this.scheduler.schedule("flush-log", (Function0<BoxedUnit>)((Object)new scala.Serializable(this, newOffset$1){
                    public static final long serialVersionUID;
                    private final Log $outer;
                    private final long newOffset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.flush(this.newOffset$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newOffset$1 = l;
                    }
                }), 0L, this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
                this.info((Function0<String>)((Object)new scala.Serializable(this, start$1){
                    public static final long serialVersionUID;
                    private final Log $outer;
                    private final long start$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Rolled new log segment for '").append((Object)this.$outer.name()).append((Object)Predef$.MODULE$.augmentString("' in %.0f ms.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble((double)(System.nanoTime() - this.start$1) / 1000000.0)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.start$1 = l;
                    }
                }));
                LogSegment logSegment = segment;
                return logSegment;
            }
            throw new KafkaException(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name(), BoxesRunTime.boxToLong(newOffset$1)})));
        }
    }

    public long unflushedMessages() {
        return this.logEndOffset() - this.recoveryPoint();
    }

    public void flush() {
        this.flush(this.logEndOffset());
    }

    public void flush(long offset$2) {
        if (offset$2 <= this.recoveryPoint()) {
            return;
        }
        this.debug((Function0<String>)((Object)new scala.Serializable(this, offset$2){
            public static final long serialVersionUID;
            private final Log $outer;
            private final long offset$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Flushing log '").append((Object)this.$outer.name()).append((Object)" up to offset ").append(BoxesRunTime.boxToLong(this.offset$2)).append((Object)", last flushed: ").append(BoxesRunTime.boxToLong(this.$outer.lastFlushTime())).append((Object)" current time: ").append(BoxesRunTime.boxToLong(this.$outer.kafka$log$Log$$time.milliseconds())).append((Object)" unflushed = ").append(BoxesRunTime.boxToLong(this.$outer.unflushedMessages())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offset$2 = l;
            }
        }));
        this.logSegments(this.recoveryPoint(), offset$2).foreach(new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment segment) {
                segment.flush();
            }
        });
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (offset$2 > this.recoveryPoint()) {
                this.recoveryPoint_$eq(offset$2);
                this.lastflushedTime().set(this.kafka$log$Log$$time.milliseconds());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void delete() {
        Object object = this.lock();
        synchronized (object) {
            this.removeLogMetrics();
            this.logSegments().foreach(new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment logSegment) {
                    logSegment.delete();
                }
            });
            this.kafka$log$Log$$segments().clear();
            CoreUtils$.MODULE$.rm(this.dir());
            return;
        }
    }

    public void truncateTo(long targetOffset$1) {
        this.info((Function0<String>)((Object)new scala.Serializable(this, targetOffset$1){
            public static final long serialVersionUID;
            private final Log $outer;
            private final long targetOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Truncating log %s to offset %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name(), BoxesRunTime.boxToLong(this.targetOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.targetOffset$1 = l;
            }
        }));
        if (targetOffset$1 < 0L) {
            throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(targetOffset$1)})));
        }
        if (targetOffset$1 > this.logEndOffset()) {
            this.info((Function0<String>)((Object)new scala.Serializable(this, targetOffset$1){
                public static final long serialVersionUID;
                private final Log $outer;
                private final long targetOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Truncating %s to %d has no effect as the largest offset in the log is %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name(), BoxesRunTime.boxToLong(this.targetOffset$1), BoxesRunTime.boxToLong(this.$outer.logEndOffset() - 1L)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.targetOffset$1 = l;
                }
            }));
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (((LogSegment)this.kafka$log$Log$$segments().firstEntry().getValue()).baseOffset() > targetOffset$1) {
                this.truncateFullyAndStartAt(targetOffset$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Iterable deletable = (Iterable)this.logSegments().filter((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, targetOffset$1){
                    public static final long serialVersionUID;
                    private final long targetOffset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(LogSegment segment) {
                        return segment.baseOffset() > this.targetOffset$1;
                    }
                    {
                        this.targetOffset$1 = l;
                    }
                }));
                deletable.foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final Log $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(LogSegment logSegment) {
                        this.$outer.kafka$log$Log$$deleteSegment(logSegment);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.activeSegment().truncateTo(targetOffset$1);
                this.updateLogEndOffset(targetOffset$1);
                this.recoveryPoint_$eq(package$.MODULE$.min(targetOffset$1, this.recoveryPoint()));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void truncateFullyAndStartAt(long newOffset$2) {
        this.debug((Function0<String>)((Object)new scala.Serializable(this, newOffset$2){
            public static final long serialVersionUID;
            private final Log $outer;
            private final long newOffset$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Truncate and start log '").append((Object)this.$outer.name()).append((Object)"' to ").append(BoxesRunTime.boxToLong(this.newOffset$2)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newOffset$2 = l;
            }
        }));
        Object object = this.lock();
        synchronized (object) {
            List segmentsToDelete = this.logSegments().toList();
            segmentsToDelete.foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment logSegment) {
                    this.$outer.kafka$log$Log$$deleteSegment(logSegment);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.addSegment(new LogSegment(this.dir(), newOffset$2, this.config().indexInterval(), this.config().maxIndexSize(), this.config().randomSegmentJitter(), this.kafka$log$Log$$time));
            this.updateLogEndOffset(newOffset$2);
            this.recoveryPoint_$eq(package$.MODULE$.min(newOffset$2, this.recoveryPoint()));
            return;
        }
    }

    public long lastFlushTime() {
        return this.lastflushedTime().get();
    }

    public LogSegment activeSegment() {
        return (LogSegment)this.kafka$log$Log$$segments().lastEntry().getValue();
    }

    public Iterable<LogSegment> logSegments() {
        return JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().values());
    }

    public Iterable<LogSegment> logSegments(long from2, long to2) {
        Object object = this.lock();
        synchronized (object) {
            Long floor = this.kafka$log$Log$$segments().floorKey(Predef$.MODULE$.long2Long(from2));
            Iterable<LogSegment> iterable = floor == null ? JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().headMap((Object)Predef$.MODULE$.long2Long(to2)).values()) : JavaConversions$.MODULE$.collectionAsScalaIterable(this.kafka$log$Log$$segments().subMap((Object)floor, true, (Object)Predef$.MODULE$.long2Long(to2), false).values());
            return iterable;
        }
    }

    public String toString() {
        return new StringBuilder().append((Object)"Log(").append(this.dir()).append((Object)")").toString();
    }

    public final void kafka$log$Log$$deleteSegment(LogSegment segment$2) {
        this.info((Function0<String>)((Object)new scala.Serializable(this, segment$2){
            public static final long serialVersionUID;
            private final Log $outer;
            private final LogSegment segment$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Scheduling log segment %d for log %s for deletion.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.segment$2.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$2 = logSegment;
            }
        }));
        Object object = this.lock();
        synchronized (object) {
            this.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong(segment$2.baseOffset()));
            this.kafka$log$Log$$asyncDeleteSegment(segment$2);
            return;
        }
    }

    public final void kafka$log$Log$$asyncDeleteSegment(LogSegment segment$4) {
        segment$4.changeFileSuffixes("", Log$.MODULE$.DeletedFileSuffix());
        this.scheduler.schedule("delete-file", (Function0<BoxedUnit>)((Object)new scala.Serializable(this, segment$4){
            public static final long serialVersionUID;
            private final Log $outer;
            private final LogSegment segment$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.deleteSeg$1(this.segment$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = logSegment;
            }
        }), this.config().fileDeleteDelayMs(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void replaceSegments(LogSegment newSegment$1, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
        Object object = this.lock();
        synchronized (object) {
            if (!isRecoveredSwapFile) {
                newSegment$1.changeFileSuffixes(Log$.MODULE$.CleanedFileSuffix(), Log$.MODULE$.SwapFileSuffix());
            }
            this.addSegment(newSegment$1);
            oldSegments.foreach(new scala.Serializable(this, newSegment$1){
                public static final long serialVersionUID;
                private final Log $outer;
                private final LogSegment newSegment$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment seg) {
                    BoxedUnit boxedUnit = seg.baseOffset() != this.newSegment$1.baseOffset() ? this.$outer.kafka$log$Log$$segments().remove(BoxesRunTime.boxToLong(seg.baseOffset())) : BoxedUnit.UNIT;
                    this.$outer.kafka$log$Log$$asyncDeleteSegment(seg);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newSegment$1 = logSegment;
                }
            });
            newSegment$1.changeFileSuffixes(Log$.MODULE$.SwapFileSuffix(), "");
            return;
        }
    }

    public boolean replaceSegments$default$3() {
        return false;
    }

    public void removeLogMetrics() {
        this.removeMetric("NumLogSegments", this.tags());
        this.removeMetric("LogStartOffset", this.tags());
        this.removeMetric("LogEndOffset", this.tags());
        this.removeMetric("Size", this.tags());
    }

    public LogSegment addSegment(LogSegment segment) {
        return this.kafka$log$Log$$segments().put(Predef$.MODULE$.long2Long(segment.baseOffset()), segment);
    }

    private final void liftedTree1$1(LogAppendInfo logAppendInfo, ObjectRef objectRef, AtomicLong atomicLong) {
        try {
            objectRef.elem = ((ByteBufferMessageSet)objectRef.elem).validateMessagesAndAssignOffsets(atomicLong, logAppendInfo.sourceCodec(), logAppendInfo.targetCodec(), this.config().compact());
            return;
        }
        catch (IOException iOException) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name()})), iOException);
        }
    }

    public final void deleteSeg$1(LogSegment logSegment) {
        this.info((Function0<String>)((Object)new scala.Serializable(this, logSegment){
            public static final long serialVersionUID;
            private final Log $outer;
            private final LogSegment segment$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Deleting segment %d from log %s.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.segment$4.baseOffset()), this.$outer.name()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.segment$4 = logSegment;
            }
        }));
        logSegment.delete();
    }

    public Log(File dir, LogConfig config, long recoveryPoint, Scheduler scheduler, Time time) {
        this.dir = dir;
        this.config = config;
        this.recoveryPoint = recoveryPoint;
        this.scheduler = scheduler;
        this.kafka$log$Log$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.lock = new Object();
        this.lastflushedTime = new AtomicLong(time.milliseconds());
        this.kafka$log$Log$$segments = new ConcurrentSkipListMap<Long, LogSegment>();
        this.loadSegments();
        this.nextOffsetMetadata = new LogOffsetMetadata(this.activeSegment().nextOffset(), this.activeSegment().baseOffset(), (int)this.activeSegment().size());
        this.topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Completed load of log %s with log end offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name(), BoxesRunTime.boxToLong(this.$outer.logEndOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("topic").$minus$greater(this.topicAndPartition().topic()), Predef$.MODULE$.any2ArrowAssoc("partition").$minus$greater(((Object)BoxesRunTime.boxToInteger(this.topicAndPartition().partition())).toString())}));
        this.newGauge("NumLogSegments", new Gauge<Object>(this){
            private final Log $outer;

            public int value() {
                return this.$outer.numberOfSegments();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("LogStartOffset", new Gauge<Object>(this){
            private final Log $outer;

            public long value() {
                return this.$outer.logStartOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("LogEndOffset", new Gauge<Object>(this){
            private final Log $outer;

            public long value() {
                return this.$outer.logEndOffset();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("Size", new Gauge<Object>(this){
            private final Log $outer;

            public long value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

