/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.message.BrokerCompressionCodec$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.config.ConfigDef;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple17;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.math.Ordering$String$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogConfig$
implements ScalaObject,
Serializable {
    public static final LogConfig$ MODULE$;
    private final String Delete;
    private final String Compact;
    private final String SegmentBytesProp;
    private final String SegmentMsProp;
    private final String SegmentJitterMsProp;
    private final String SegmentIndexBytesProp;
    private final String FlushMessagesProp;
    private final String FlushMsProp;
    private final String RetentionBytesProp;
    private final String RetentionMsProp;
    private final String MaxMessageBytesProp;
    private final String IndexIntervalBytesProp;
    private final String DeleteRetentionMsProp;
    private final String FileDeleteDelayMsProp;
    private final String MinCleanableDirtyRatioProp;
    private final String CleanupPolicyProp;
    private final String UncleanLeaderElectionEnableProp;
    private final String MinInSyncReplicasProp;
    private final String CompressionTypeProp;
    private final String SegmentSizeDoc;
    private final String SegmentMsDoc;
    private final String SegmentJitterMsDoc;
    private final String FlushIntervalDoc;
    private final String FlushMsDoc;
    private final String RetentionSizeDoc;
    private final String RetentionMsDoc;
    private final String MaxIndexSizeDoc;
    private final String MaxMessageSizeDoc;
    private final String IndexIntervalDoc;
    private final String FileDeleteDelayMsDoc;
    private final String DeleteRetentionMsDoc;
    private final String MinCleanableRatioDoc;
    private final String CompactDoc;
    private final String UncleanLeaderElectionEnableDoc;
    private final String MinInSyncReplicasDoc;
    private final String CompressionTypeDoc;
    private final ConfigDef configDef;

    static {
        new LogConfig$();
    }

    public String Delete() {
        return this.Delete;
    }

    public String Compact() {
        return this.Compact;
    }

    public String SegmentBytesProp() {
        return this.SegmentBytesProp;
    }

    public String SegmentMsProp() {
        return this.SegmentMsProp;
    }

    public String SegmentJitterMsProp() {
        return this.SegmentJitterMsProp;
    }

    public String SegmentIndexBytesProp() {
        return this.SegmentIndexBytesProp;
    }

    public String FlushMessagesProp() {
        return this.FlushMessagesProp;
    }

    public String FlushMsProp() {
        return this.FlushMsProp;
    }

    public String RetentionBytesProp() {
        return this.RetentionBytesProp;
    }

    public String RetentionMsProp() {
        return this.RetentionMsProp;
    }

    public String MaxMessageBytesProp() {
        return this.MaxMessageBytesProp;
    }

    public String IndexIntervalBytesProp() {
        return this.IndexIntervalBytesProp;
    }

    public String DeleteRetentionMsProp() {
        return this.DeleteRetentionMsProp;
    }

    public String FileDeleteDelayMsProp() {
        return this.FileDeleteDelayMsProp;
    }

    public String MinCleanableDirtyRatioProp() {
        return this.MinCleanableDirtyRatioProp;
    }

    public String CleanupPolicyProp() {
        return this.CleanupPolicyProp;
    }

    public String UncleanLeaderElectionEnableProp() {
        return this.UncleanLeaderElectionEnableProp;
    }

    public String MinInSyncReplicasProp() {
        return this.MinInSyncReplicasProp;
    }

    public String CompressionTypeProp() {
        return this.CompressionTypeProp;
    }

    public String SegmentSizeDoc() {
        return this.SegmentSizeDoc;
    }

    public String SegmentMsDoc() {
        return this.SegmentMsDoc;
    }

    public String SegmentJitterMsDoc() {
        return this.SegmentJitterMsDoc;
    }

    public String FlushIntervalDoc() {
        return this.FlushIntervalDoc;
    }

    public String FlushMsDoc() {
        return this.FlushMsDoc;
    }

    public String RetentionSizeDoc() {
        return this.RetentionSizeDoc;
    }

    public String RetentionMsDoc() {
        return this.RetentionMsDoc;
    }

    public String MaxIndexSizeDoc() {
        return this.MaxIndexSizeDoc;
    }

    public String MaxMessageSizeDoc() {
        return this.MaxMessageSizeDoc;
    }

    public String IndexIntervalDoc() {
        return this.IndexIntervalDoc;
    }

    public String FileDeleteDelayMsDoc() {
        return this.FileDeleteDelayMsDoc;
    }

    public String DeleteRetentionMsDoc() {
        return this.DeleteRetentionMsDoc;
    }

    public String MinCleanableRatioDoc() {
        return this.MinCleanableRatioDoc;
    }

    public String CompactDoc() {
        return this.CompactDoc;
    }

    public String UncleanLeaderElectionEnableDoc() {
        return this.UncleanLeaderElectionEnableDoc;
    }

    public String MinInSyncReplicasDoc() {
        return this.MinInSyncReplicasDoc;
    }

    public String CompressionTypeDoc() {
        return this.CompressionTypeDoc;
    }

    private ConfigDef configDef() {
        return this.configDef;
    }

    public List<String> configNames() {
        return (List)JavaConversions$.MODULE$.asScalaSet(this.configDef().names()).toList().sorted(Ordering$String$.MODULE$);
    }

    public LogConfig fromProps(Properties props) {
        Map<String, Object> parsed = this.configDef().parse(CoreUtils$.MODULE$.evaluateDefaults(props));
        int x$1 = BoxesRunTime.unboxToInt(parsed.get(this.SegmentBytesProp()));
        long x$2 = BoxesRunTime.unboxToLong(parsed.get(this.SegmentMsProp()));
        long x$3 = BoxesRunTime.unboxToLong(parsed.get(this.SegmentJitterMsProp()));
        int x$4 = BoxesRunTime.unboxToInt(parsed.get(this.SegmentIndexBytesProp()));
        long x$5 = BoxesRunTime.unboxToLong(parsed.get(this.FlushMessagesProp()));
        long x$6 = BoxesRunTime.unboxToLong(parsed.get(this.FlushMsProp()));
        long x$7 = BoxesRunTime.unboxToLong(parsed.get(this.RetentionBytesProp()));
        long x$8 = BoxesRunTime.unboxToLong(parsed.get(this.RetentionMsProp()));
        int x$9 = BoxesRunTime.unboxToInt(parsed.get(this.MaxMessageBytesProp()));
        int x$10 = BoxesRunTime.unboxToInt(parsed.get(this.IndexIntervalBytesProp()));
        long x$11 = BoxesRunTime.unboxToLong(parsed.get(this.FileDeleteDelayMsProp()));
        long x$12 = BoxesRunTime.unboxToLong(parsed.get(this.DeleteRetentionMsProp()));
        double x$13 = BoxesRunTime.unboxToDouble(parsed.get(this.MinCleanableDirtyRatioProp()));
        String string2 = ((String)parsed.get(this.CleanupPolicyProp())).toLowerCase();
        String string3 = this.Delete();
        boolean x$14 = string2 != null ? !string2.equals(string3) : string3 != null;
        boolean x$15 = BoxesRunTime.unboxToBoolean(parsed.get(this.UncleanLeaderElectionEnableProp()));
        int x$16 = BoxesRunTime.unboxToInt(parsed.get(this.MinInSyncReplicasProp()));
        String x$17 = ((String)parsed.get(this.CompressionTypeProp())).toLowerCase();
        return new LogConfig(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$4, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
    }

    public LogConfig fromProps(Properties defaults, Properties overrides) {
        Properties props = new Properties(defaults);
        props.putAll((Map<?, ?>)overrides);
        return this.fromProps(props);
    }

    public void validateNames(Properties props) {
        Set<String> names$1 = this.configDef().names();
        JavaConversions$.MODULE$.enumerationAsScalaIterator(props.keys()).foreach(new Serializable(names$1){
            public static final long serialVersionUID;
            private final Set names$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object name$1) {
                Predef$.MODULE$.require(this.names$1.contains(name$1), (Function0<Object>)((Object)new Serializable(this, name$1){
                    public static final long serialVersionUID;
                    private final Object name$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Unknown configuration \"%s\".").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = object;
                    }
                }));
            }
            {
                this.names$1 = set;
            }
        });
    }

    public void validate(Properties props) {
        this.validateNames(props);
        this.configDef().parse(props);
    }

    public String init$default$17() {
        return Defaults$.MODULE$.CompressionType();
    }

    public int init$default$16() {
        return Defaults$.MODULE$.MinInSyncReplicas();
    }

    public boolean init$default$15() {
        return Defaults$.MODULE$.UncleanLeaderElectionEnable();
    }

    public boolean init$default$14() {
        return Defaults$.MODULE$.Compact();
    }

    public double init$default$13() {
        return Defaults$.MODULE$.MinCleanableDirtyRatio();
    }

    public long init$default$12() {
        return Defaults$.MODULE$.DeleteRetentionMs();
    }

    public long init$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public int init$default$10() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int init$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public int init$default$8() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public long init$default$7() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long init$default$6() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long init$default$5() {
        return Defaults$.MODULE$.FlushMs();
    }

    public long init$default$4() {
        return Defaults$.MODULE$.FlushInterval();
    }

    public long init$default$3() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public long init$default$2() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int init$default$1() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public Option unapply(LogConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple17<Integer, Long, Long, Long, Long, Long, Long, Integer, Integer, Integer, Long, Long, Double, Boolean, Boolean, Integer, String>>(new Tuple17<Integer, Long, Long, Long, Long, Long, Long, Integer, Integer, Integer, Long, Long, Double, Boolean, Boolean, Integer, String>(BoxesRunTime.boxToInteger(x$0.segmentSize()), BoxesRunTime.boxToLong(x$0.segmentMs()), BoxesRunTime.boxToLong(x$0.segmentJitterMs()), BoxesRunTime.boxToLong(x$0.flushInterval()), BoxesRunTime.boxToLong(x$0.flushMs()), BoxesRunTime.boxToLong(x$0.retentionSize()), BoxesRunTime.boxToLong(x$0.retentionMs()), BoxesRunTime.boxToInteger(x$0.maxMessageSize()), BoxesRunTime.boxToInteger(x$0.maxIndexSize()), BoxesRunTime.boxToInteger(x$0.indexInterval()), BoxesRunTime.boxToLong(x$0.fileDeleteDelayMs()), BoxesRunTime.boxToLong(x$0.deleteRetentionMs()), BoxesRunTime.boxToDouble(x$0.minCleanableRatio()), BoxesRunTime.boxToBoolean(x$0.compact()), BoxesRunTime.boxToBoolean(x$0.uncleanLeaderElectionEnable()), BoxesRunTime.boxToInteger(x$0.minInSyncReplicas()), x$0.compressionType()));
    }

    public LogConfig apply(int segmentSize, long segmentMs, long segmentJitterMs, long flushInterval, long flushMs, long retentionSize, long retentionMs, int maxMessageSize, int maxIndexSize, int indexInterval, long fileDeleteDelayMs, long deleteRetentionMs, double minCleanableRatio, boolean compact2, boolean uncleanLeaderElectionEnable, int minInSyncReplicas, String compressionType) {
        return new LogConfig(segmentSize, segmentMs, segmentJitterMs, flushInterval, flushMs, retentionSize, retentionMs, maxMessageSize, maxIndexSize, indexInterval, fileDeleteDelayMs, deleteRetentionMs, minCleanableRatio, compact2, uncleanLeaderElectionEnable, minInSyncReplicas, compressionType);
    }

    public String apply$default$17() {
        return Defaults$.MODULE$.CompressionType();
    }

    public int apply$default$16() {
        return Defaults$.MODULE$.MinInSyncReplicas();
    }

    public boolean apply$default$15() {
        return Defaults$.MODULE$.UncleanLeaderElectionEnable();
    }

    public boolean apply$default$14() {
        return Defaults$.MODULE$.Compact();
    }

    public double apply$default$13() {
        return Defaults$.MODULE$.MinCleanableDirtyRatio();
    }

    public long apply$default$12() {
        return Defaults$.MODULE$.DeleteRetentionMs();
    }

    public long apply$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public int apply$default$10() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int apply$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public int apply$default$8() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public long apply$default$7() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long apply$default$6() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long apply$default$5() {
        return Defaults$.MODULE$.FlushMs();
    }

    public long apply$default$4() {
        return Defaults$.MODULE$.FlushInterval();
    }

    public long apply$default$3() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public long apply$default$2() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int apply$default$1() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public Object readResolve() {
        return MODULE$;
    }

    private LogConfig$() {
        MODULE$ = this;
        this.Delete = "delete";
        this.Compact = "compact";
        this.SegmentBytesProp = "segment.bytes";
        this.SegmentMsProp = "segment.ms";
        this.SegmentJitterMsProp = "segment.jitter.ms";
        this.SegmentIndexBytesProp = "segment.index.bytes";
        this.FlushMessagesProp = "flush.messages";
        this.FlushMsProp = "flush.ms";
        this.RetentionBytesProp = "retention.bytes";
        this.RetentionMsProp = "retention.ms";
        this.MaxMessageBytesProp = "max.message.bytes";
        this.IndexIntervalBytesProp = "index.interval.bytes";
        this.DeleteRetentionMsProp = "delete.retention.ms";
        this.FileDeleteDelayMsProp = "file.delete.delay.ms";
        this.MinCleanableDirtyRatioProp = "min.cleanable.dirty.ratio";
        this.CleanupPolicyProp = "cleanup.policy";
        this.UncleanLeaderElectionEnableProp = "unclean.leader.election.enable";
        this.MinInSyncReplicasProp = "min.insync.replicas";
        this.CompressionTypeProp = "compression.type";
        this.SegmentSizeDoc = "The hard maximum for the size of a segment file in the log";
        this.SegmentMsDoc = "The soft maximum on the amount of time before a new log segment is rolled";
        this.SegmentJitterMsDoc = "The maximum random jitter subtracted from segmentMs to avoid thundering herds of segment rolling";
        this.FlushIntervalDoc = "The number of messages that can be written to the log before a flush is forced";
        this.FlushMsDoc = "The amount of time the log can have dirty data before a flush is forced";
        this.RetentionSizeDoc = "The approximate total number of bytes this log can use";
        this.RetentionMsDoc = "The approximate maximum age of the last segment that is retained";
        this.MaxIndexSizeDoc = "The maximum size of an index file";
        this.MaxMessageSizeDoc = "The maximum size of a message";
        this.IndexIntervalDoc = "The approximate number of bytes between index entries";
        this.FileDeleteDelayMsDoc = "The time to wait before deleting a file from the filesystem";
        this.DeleteRetentionMsDoc = "The time to retain delete markers in the log. Only applicable for logs that are being compacted.";
        this.MinCleanableRatioDoc = "The ratio of bytes that are available for cleaning to the bytes already cleaned";
        this.CompactDoc = "Should old segments in this log be deleted or deduplicated?";
        this.UncleanLeaderElectionEnableDoc = "Indicates whether unclean leader election is enabled";
        this.MinInSyncReplicasDoc = "If number of insync replicas drops below this number, we stop accepting writes with -1 (or all) required acks";
        this.CompressionTypeDoc = "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', lz4). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.";
        this.configDef = new ConfigDef().define(this.SegmentBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(Defaults$.MODULE$.SegmentSize()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentSizeDoc()).define(this.SegmentMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.SegmentMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentMsDoc()).define(this.SegmentJitterMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.SegmentJitterMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.SegmentJitterMsDoc()).define(this.SegmentIndexBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(Defaults$.MODULE$.MaxIndexSize()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxIndexSizeDoc()).define(this.FlushMessagesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.FlushInterval()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushIntervalDoc()).define(this.FlushMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.FlushMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FlushMsDoc()).define(this.RetentionBytesProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.RetentionSize()), ConfigDef.Importance.MEDIUM, this.RetentionSizeDoc()).define(this.RetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.RetentionMs()), ConfigDef.Importance.MEDIUM, this.RetentionMsDoc()).define(this.MaxMessageBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(Defaults$.MODULE$.MaxMessageSize()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.MaxMessageSizeDoc()).define(this.IndexIntervalBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(Defaults$.MODULE$.IndexInterval()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.IndexIntervalDoc()).define(this.DeleteRetentionMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.DeleteRetentionMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.DeleteRetentionMsDoc()).define(this.FileDeleteDelayMsProp(), ConfigDef.Type.LONG, BoxesRunTime.boxToLong(Defaults$.MODULE$.FileDeleteDelayMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, this.FileDeleteDelayMsDoc()).define(this.MinCleanableDirtyRatioProp(), ConfigDef.Type.DOUBLE, BoxesRunTime.boxToDouble(Defaults$.MODULE$.MinCleanableDirtyRatio()), ConfigDef.Range.between(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinCleanableRatioDoc()).define(this.CleanupPolicyProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.Compact() ? this.Compact() : this.Delete(), ConfigDef.ValidString.in(this.Compact(), this.Delete()), ConfigDef.Importance.MEDIUM, this.CompactDoc()).define(this.UncleanLeaderElectionEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(Defaults$.MODULE$.UncleanLeaderElectionEnable()), ConfigDef.Importance.MEDIUM, this.UncleanLeaderElectionEnableDoc()).define(this.MinInSyncReplicasProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(Defaults$.MODULE$.MinInSyncReplicas()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.MEDIUM, this.MinInSyncReplicasDoc()).define(this.CompressionTypeProp(), ConfigDef.Type.STRING, Defaults$.MODULE$.CompressionType(), ConfigDef.ValidString.in((String[])BrokerCompressionCodec$.MODULE$.brokerCompressionOptions().toArray(ClassManifest$.MODULE$.classType(String.class))), ConfigDef.Importance.MEDIUM, this.CompressionTypeDoc());
    }
}

