/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0004\u0001\t\u0015\r\u0011\"\u0001\u001e+\u0005q\u0002CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u000591\u0015\u000e\\3NKN\u001c\u0018mZ3TKRD\u0001b\t\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0005Y><\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0015Ig\u000eZ3y+\u00059\u0003CA\u0010)\u0013\tI#AA\u0006PM\u001a\u001cX\r^%oI\u0016D\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\r%tG-\u001a=!\u0011!i\u0003A!b\u0001\n\u0003q\u0013A\u00032bg\u0016|eMZ:fiV\tq\u0006\u0005\u0002\u0018a%\u0011\u0011\u0007\u0007\u0002\u0005\u0019>tw\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\tq\u0007\u0005\u0002\u0018q%\u0011\u0011\b\u0007\u0002\u0004\u0013:$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0011u\u0002!Q1A\u0005\u00029\nAB]8mY*KG\u000f^3s\u001bND\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000bA\u0001^5nKB\u0011\u0011cQ\u0005\u0003\tJ\u0011A\u0001V5nK\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"r\u0001S%K\u00172ke\n\u0005\u0002 \u0001!)1!\u0012a\u0001=!)Q%\u0012a\u0001O!)Q&\u0012a\u0001_!)Q'\u0012a\u0001o!)Q(\u0012a\u0001_!)\u0011)\u0012a\u0001\u0005\"9\u0001\u000b\u0001a\u0001\n\u0003q\u0013aB2sK\u0006$X\r\u001a\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u0003-\u0019'/Z1uK\u0012|F%Z9\u0015\u0005Q;\u0006CA\fV\u0013\t1\u0006D\u0001\u0003V]&$\bb\u0002-R\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004B\u0002.\u0001A\u0003&q&\u0001\u0005de\u0016\fG/\u001a3!\u0011\u001da\u0006\u00011A\u0005\nY\n\u0001DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z\u0011\u001dq\u0006\u00011A\u0005\n}\u000bADY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z?\u0012*\u0017\u000f\u0006\u0002UA\"9\u0001,XA\u0001\u0002\u00049\u0004B\u00022\u0001A\u0003&q'A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0003\"\u0002$\u0001\t\u0003!Gc\u0002%f[>\u0004(o\u001d\u0005\u0006M\u000e\u0004\raZ\u0001\u0004I&\u0014\bC\u00015l\u001b\u0005I'B\u00016\r\u0003\tIw.\u0003\u0002mS\n!a)\u001b7f\u0011\u0015q7\r1\u00010\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000bU\u001a\u0007\u0019A\u001c\t\u000bE\u001c\u0007\u0019A\u001c\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u000bu\u001a\u0007\u0019A\u0018\t\u000b\u0005\u001b\u0007\u0019\u0001\"\t\u000bU\u0004A\u0011\u0001\u0018\u0002\tML'0\u001a\u0005\u0006o\u0002!\t\u0001_\u0001\u0007CB\u0004XM\u001c3\u0015\u0007QK8\u0010C\u0003{m\u0002\u0007q&\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006yZ\u0004\r!`\u0001\t[\u0016\u001c8/Y4fgB\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u0005\u0003\u001diWm]:bO\u0016L1!!\u0002\u0000\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\"\u001aa/!\u0003\u0011\u0007E\tY!C\u0002\u0002\u000eI\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007\u0002CA\t\u0001\u0011\u0005!!a\u0005\u0002\u001fQ\u0014\u0018M\\:mCR,wJ\u001a4tKR$b!!\u0006\u0002\u001c\u0005u\u0001cA\u0010\u0002\u0018%\u0019\u0011\u0011\u0004\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"1!0a\u0004A\u0002=B\u0011\"a\b\u0002\u0010A\u0005\t\u0019A\u001c\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\ty!a\t\u0011\u0007E\t)#C\u0002\u0002(I\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\tAA]3bIRA\u0011qFA\u001e\u0003{\t9\u0005\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005e\u00121\u0007\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\r9\fI\u00031\u00010\u0011!\ty$!\u000bA\u0002\u0005\u0005\u0013!C7bq>3gm]3u!\u00119\u00121I\u0018\n\u0007\u0005\u0015\u0003D\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0013\nI\u00031\u00018\u0003\u001di\u0017\r_*ju\u0016DC!!\u000b\u0002$!9\u0011q\n\u0001\u0005\u0002\u0005E\u0013a\u0002:fG>4XM\u001d\u000b\u0004o\u0005M\u0003bBA+\u0003\u001b\u0002\raN\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>fQ\u0011\ti%!\u0003\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005AAo\\*ue&tw\r\u0006\u0002\u0002`A\u0019\u0011\"!\u0019\n\u0007\u0005\r$B\u0001\u0004TiJLgn\u001a\u0005\b\u0003O\u0002A\u0011AA5\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004o\u0005-\u0004B\u0002>\u0002f\u0001\u0007q\u0006\u000b\u0003\u0002f\u0005%\u0001bBA9\u0001\u0011\u0005\u00111O\u0001\u000b]\u0016DHo\u00144gg\u0016$H#A\u0018)\t\u0005=\u00141\u0005\u0005\b\u0003s\u0002A\u0011AA>\u0003\u00151G.^:i)\u0005!\u0006\u0006BA<\u0003GAq!!!\u0001\t\u0003\t\u0019)\u0001\ndQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001cH#\u0002+\u0002\u0006\u0006U\u0005\u0002CAD\u0003\u007f\u0002\r!!#\u0002\u0013=dGmU;gM&D\b\u0003BAF\u0003#s1aFAG\u0013\r\ty\tG\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u00141\u0013\u0006\u0004\u0003\u001fC\u0002\u0002CAL\u0003\u007f\u0002\r!!#\u0002\u00139,woU;gM&D\bbBAN\u0001\u0011\u0005\u00111P\u0001\u0006G2|7/\u001a\u0005\b\u0003?\u0003A\u0011AA>\u0003\u0019!W\r\\3uK\"1\u00111\u0015\u0001\u0005\u00029\nA\u0002\\1ti6{G-\u001b4jK\u0012Dq!a*\u0001\t\u0003\tI+\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!\u00111VAY!\r9\u0012QV\u0005\u0004\u0003_C\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g\u000b)\u000b1\u00010\u0003\ti7\u000fC\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002:\u0006IBO]1og2\fG/Z(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYLK\u00028\u0003{[#!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013D\u0012AC1o]>$\u0018\r^5p]&!\u0011QZAb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\u0005%\u0001")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long l) {
        this.created = l;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset$1, ByteBufferMessageSet messages$1) {
        if (messages$1.sizeInBytes() > 0) {
            this.trace((Function0<String>)((Object)new Serializable(this, offset$1, messages$1){
                public static final long serialVersionUID;
                private final LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer.log().sizeInBytes())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.offset$1 = l;
                    this.messages$1 = byteBufferMessageSet;
                }
            }));
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset$1, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages$1);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages$1.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize) {
        Option<Object> option;
        block9: {
            int n;
            LogOffsetMetadata offsetMetadata;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(maxSize)})));
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition.position());
                    if (maxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, MessageSet$.MODULE$.Empty());
                    }
                    option = maxOffset;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    n = maxSize;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long l = BoxesRunTime.unboxToLong(some.x());
                long offset = l;
                if (offset < startOffset) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(offset), BoxesRunTime.boxToLong(startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = package$.MODULE$.min(endPosition - startPosition.position(), maxSize);
            }
            int length = n;
            return new FetchDataInfo(offsetMetadata, this.log().read(startPosition.position(), length));
        }
        throw new MatchError(option);
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long startOffset = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? entry2.offset() : ByteBufferMessageSet$.MODULE$.deepIterator(entry2.message()).next().offset();
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger(validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append(BoxesRunTime.boxToLong(this.baseOffset())).append((Object)", size=").append(BoxesRunTime.boxToLong(this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option option;
        block5: {
            long l;
            block3: {
                block4: {
                    FetchDataInfo ms;
                    block2: {
                        ms = this.read(this.index().lastOffset(), None$.MODULE$, this.log().sizeInBytes());
                        if (ms != null) break block2;
                        l = this.baseOffset();
                        break block3;
                    }
                    option = ms.messageSet().lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                    l = this.baseOffset();
                    break block3;
                }
                if (!(option instanceof Some)) break block5;
                l = ((MessageAndOffset)((Some)option).x()).nextOffset();
            }
            return l;
        }
        throw new MatchError(option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong(this.baseOffset())})));
        }
        throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong(this.baseOffset())})));
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log2, OffsetIndex index, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log2;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset)), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

