/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kafka.log.OffsetMap;
import kafka.log.OffsetMap$class;
import kafka.log.SkimpyOffsetMap$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001\u001d\u0011qbU6j[BLxJ\u001a4tKRl\u0015\r\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0001B\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\u0005PM\u001a\u001cX\r^'baB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011!Y\u0002A!b\u0001\n\u0003a\u0012AB7f[>\u0014\u00180F\u0001\u001e!\t)b$\u0003\u0002 -\t\u0019\u0011J\u001c;\t\u0011\u0005\u0002!\u0011!Q\u0001\nu\tq!\\3n_JL\b\u0005\u0003\u0005$\u0001\t\u0015\r\u0011\"\u0001%\u00035A\u0017m\u001d5BY\u001e|'/\u001b;i[V\tQ\u0005\u0005\u0002'S9\u0011QcJ\u0005\u0003QY\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0016,\u0005\u0019\u0019FO]5oO*\u0011\u0001F\u0006\u0005\t[\u0001\u0011\t\u0011)A\u0005K\u0005q\u0001.Y:i\u00032<wN]5uQ6\u0004\u0003\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00022eM\u0002\"!\u0005\u0001\t\u000bmq\u0003\u0019A\u000f\t\u000f\rr\u0003\u0013!a\u0001K!9Q\u0007\u0001b\u0001\n\u00131\u0014!\u00022zi\u0016\u001cX#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005ib\u0011a\u00018j_&\u0011A(\u000f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bB\u0002 \u0001A\u0003%q'\u0001\u0004csR,7\u000f\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0003\u0019!\u0017nZ3tiV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002F\u0019\u0005A1/Z2ve&$\u00180\u0003\u0002H\t\niQ*Z:tC\u001e,G)[4fgRDa!\u0013\u0001!\u0002\u0013\u0011\u0015a\u00023jO\u0016\u001cH\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003\u001d\u0003!A\u0017m\u001d5TSj,\u0007BB'\u0001A\u0003%Q$A\u0005iCND7+\u001b>fA!9q\n\u0001b\u0001\n\u0013\u0001\u0016!\u00025bg\"\fT#A)\u0011\u0007U\u0011F+\u0003\u0002T-\t)\u0011I\u001d:bsB\u0011Q#V\u0005\u0003-Z\u0011AAQ=uK\"1\u0001\f\u0001Q\u0001\nE\u000ba\u0001[1tQF\u0002\u0003b\u0002.\u0001\u0005\u0004%I\u0001U\u0001\u0006Q\u0006\u001c\bN\r\u0005\u00079\u0002\u0001\u000b\u0011B)\u0002\r!\f7\u000f\u001b\u001a!\u0011\u001dq\u0006\u00011A\u0005\nq\tq!\u001a8ue&,7\u000fC\u0004a\u0001\u0001\u0007I\u0011B1\u0002\u0017\u0015tGO]5fg~#S-\u001d\u000b\u0003E\u0016\u0004\"!F2\n\u0005\u00114\"\u0001B+oSRDqAZ0\u0002\u0002\u0003\u0007Q$A\u0002yIEBa\u0001\u001b\u0001!B\u0013i\u0012\u0001C3oiJLWm\u001d\u0011\t\u000f)\u0004\u0001\u0019!C\u0005W\u00069An\\8lkB\u001cX#\u00017\u0011\u0005Ui\u0017B\u00018\u0017\u0005\u0011auN\\4\t\u000fA\u0004\u0001\u0019!C\u0005c\u0006YAn\\8lkB\u001cx\fJ3r)\t\u0011'\u000fC\u0004g_\u0006\u0005\t\u0019\u00017\t\rQ\u0004\u0001\u0015)\u0003m\u0003!awn\\6vaN\u0004\u0003b\u0002<\u0001\u0001\u0004%Ia[\u0001\u0007aJ|'-Z:\t\u000fa\u0004\u0001\u0019!C\u0005s\u0006Q\u0001O]8cKN|F%Z9\u0015\u0005\tT\bb\u00024x\u0003\u0003\u0005\r\u0001\u001c\u0005\u0007y\u0002\u0001\u000b\u0015\u00027\u0002\u000fA\u0014xNY3tA!9a\u0010\u0001b\u0001\n\u0003a\u0012!\u00042zi\u0016\u001c\b+\u001a:F]R\u0014\u0018\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B\u000f\u0002\u001d\tLH/Z:QKJ,e\u000e\u001e:zA!A\u0011Q\u0001\u0001C\u0002\u0013\u0005A$A\u0003tY>$8\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011B\u000f\u0002\rMdw\u000e^:!\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\t1\u0001];u)\u0015\u0011\u0017\u0011CA\u000b\u0011\u001d\t\u0019\"a\u0003A\u0002]\n1a[3z\u0011\u001d\t9\"a\u0003A\u00021\faa\u001c4gg\u0016$\bbBA\u000e\u0001\u0011%\u0011QD\u0001\bSN,U\u000e\u001d;z)\u0011\ty\"!\n\u0011\u0007U\t\t#C\u0002\u0002$Y\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002(\u0005e\u0001\u0019A\u000f\u0002\u0011A|7/\u001b;j_:Dq!a\u000b\u0001\t\u0003\ni#A\u0002hKR$2\u0001\\A\u0018\u0011\u001d\t\u0019\"!\u000bA\u0002]Bq!a\r\u0001\t\u0003\n)$A\u0003dY\u0016\f'\u000fF\u0001c\u0011\u0019\tI\u0004\u0001C!9\u0005!1/\u001b>f\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\tQbY8mY&\u001c\u0018n\u001c8SCR,WCAA!!\r)\u00121I\u0005\u0004\u0003\u000b2\"A\u0002#pk\ndW\rC\u0004\u0002J\u0001!I!a\u0013\u0002\u0015A|7/\u001b;j_:|e\rF\u0003\u001e\u0003\u001b\n\t\u0006C\u0004\u0002P\u0005\u001d\u0003\u0019A)\u0002\t!\f7\u000f\u001b\u0005\b\u0003'\n9\u00051\u0001\u001e\u0003\u001d\tG\u000f^3naRDq!a\u0016\u0001\t\u0013\tI&\u0001\u0005iCND\u0017J\u001c;p)\u0015\u0011\u00171LA/\u0011\u001d\t\u0019\"!\u0016A\u0002]Bq!a\u0018\u0002V\u0001\u0007\u0011+\u0001\u0004ck\u001a4WM\u001d\u0015\u0004\u0001\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%D!A\u0003vi&d7/\u0003\u0003\u0002n\u0005\u001d$!\u00048p]RD'/Z1eg\u00064WmB\u0005\u0002r\t\t\t\u0011#\u0002\u0002t\u0005y1k[5naf|eMZ:fi6\u000b\u0007\u000fE\u0002\u0012\u0003k2\u0001\"\u0001\u0002\u0002\u0002#\u0015\u0011qO\n\u0005\u0003kBA\u0003C\u00040\u0003k\"\t!a\u001f\u0015\u0005\u0005M\u0004BCA@\u0003k\n\n\u0011\"\u0001\u0002\u0002\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012\u0012TCAABU\r)\u0013QQ\u0016\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0013\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0006-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SkimpyOffsetMap
implements OffsetMap {
    private final int memory;
    private final String hashAlgorithm;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries;
    private long lookups;
    private long probes;
    private final int bytesPerEntry;
    private final int slots;

    public static final String init$default$2() {
        return SkimpyOffsetMap$.MODULE$.init$default$2();
    }

    public double utilization() {
        return OffsetMap$class.utilization(this);
    }

    public int memory() {
        return this.memory;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hash1() {
        return this.hash1;
    }

    private byte[] hash2() {
        return this.hash2;
    }

    private int entries() {
        return this.entries;
    }

    private void entries_$eq(int n) {
        this.entries = n;
    }

    private long lookups() {
        return this.lookups;
    }

    private void lookups_$eq(long l) {
        this.lookups = l;
    }

    private long probes() {
        return this.probes;
    }

    private void probes_$eq(long l) {
        this.probes = l;
    }

    public int bytesPerEntry() {
        return this.bytesPerEntry;
    }

    public int slots() {
        return this.slots;
    }

    public void put(ByteBuffer key, long offset) {
        Predef$.MODULE$.require(this.entries() < this.slots(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Attempt to add a new entry to a full offset map.";
            }
        }));
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = this.positionOf(this.hash1(), attempt);
        while (true) {
            if (this.isEmpty(pos)) {
                this.bytes().position(pos);
                this.bytes().put(this.hash1());
                this.bytes().putLong(offset);
                this.entries_$eq(this.entries() + 1);
                return;
            }
            this.bytes().position(pos);
            this.bytes().get(this.hash2());
            if (Arrays.equals(this.hash1(), this.hash2())) {
                this.bytes().putLong(offset);
                return;
            }
            pos = this.positionOf(this.hash1(), ++attempt);
        }
    }

    private boolean isEmpty(int position) {
        return this.bytes().getLong(position) == 0L && this.bytes().getLong(position + 8) == 0L && this.bytes().getLong(position + 16) == 0L;
    }

    public long get(ByteBuffer key) {
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = 0;
        do {
            pos = this.positionOf(this.hash1(), attempt);
            this.bytes().position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes().get(this.hash2());
            ++attempt;
        } while (!Arrays.equals(this.hash1(), this.hash2()));
        return this.bytes().getLong();
    }

    public void clear() {
        this.entries_$eq(0);
        this.lookups_$eq(0L);
        this.probes_$eq(0L);
        Arrays.fill(this.bytes().array(), this.bytes().arrayOffset(), this.bytes().arrayOffset() + this.bytes().limit(), (byte)0);
    }

    public int size() {
        return this.entries();
    }

    public double collisionRate() {
        return (double)(this.probes() - this.lookups()) / (double)this.lookups();
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = CoreUtils$.MODULE$.readInt(hash, package$.MODULE$.min(attempt, this.hashSize() - 4)) + package$.MODULE$.max(0, attempt - this.hashSize() + 4);
        int slot = Utils.abs(probe) % this.slots();
        this.probes_$eq(this.probes() + 1L);
        return slot * this.bytesPerEntry();
    }

    private void hashInto(ByteBuffer key, byte[] buffer) {
        key.mark();
        this.digest().update(key);
        key.reset();
        this.digest().digest(buffer, 0, this.hashSize());
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) {
        this.memory = memory;
        this.hashAlgorithm = hashAlgorithm;
        OffsetMap$class.$init$(this);
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest().getDigestLength();
        this.hash1 = new byte[this.hashSize()];
        this.hash2 = new byte[this.hashSize()];
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.bytesPerEntry = this.hashSize() + 8;
        this.slots = memory / this.bytesPerEntry();
    }
}

