/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001\u001d\u0011QCQ;gM\u0016\u0014\u0018N\\4PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\t\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011AA5p\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005Y1/Z4nK:$8+\u001b>f!\t\t\u0012$\u0003\u0002\u001b%\t\u0019\u0011J\u001c;\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\tq\u0002\u0005\u0005\u0002 \u00015\t!\u0001C\u0003\u00187\u0001\u0007\u0001D\u0002\u0003#\u0001)\u0019#aB*fO6,g\u000e^\n\u0004C\u0011\u0002\u0002CA\u0013)\u001b\u00051#BA\u0014\r\u0003\u0011a\u0017M\\4\n\u0005%2#AB(cU\u0016\u001cG\u000f\u0003\u0005,C\t\u0005\t\u0015!\u0003\u0019\u0003\u0011\u0019\u0018N_3\t\u000bq\tC\u0011A\u0017\u0015\u00059\u0002\u0004CA\u0018\"\u001b\u0005\u0001\u0001\"B\u0016-\u0001\u0004A\u0002b\u0002\u001a\"\u0005\u0004%\taM\u0001\u0006Ef$Xm]\u000b\u0002iA\u0019\u0011#N\u001c\n\u0005Y\u0012\"!B!se\u0006L\bCA\t9\u0013\tI$C\u0001\u0003CsR,\u0007BB\u001e\"A\u0003%A'\u0001\u0004csR,7\u000f\t\u0005\b{\u0005\u0002\r\u0011\"\u0001?\u0003\u001d9(/\u001b;uK:,\u0012\u0001\u0007\u0005\b\u0001\u0006\u0002\r\u0011\"\u0001B\u0003-9(/\u001b;uK:|F%Z9\u0015\u0005\t+\u0005CA\tD\u0013\t!%C\u0001\u0003V]&$\bb\u0002$@\u0003\u0003\u0005\r\u0001G\u0001\u0004q\u0012\n\u0004B\u0002%\"A\u0003&\u0001$\u0001\u0005xe&$H/\u001a8!\u0011\u001dQ\u0015\u00051A\u0005\u0002-\u000bAA\\3yiV\ta\u0006C\u0004NC\u0001\u0007I\u0011\u0001(\u0002\u00119,\u0007\u0010^0%KF$\"AQ(\t\u000f\u0019c\u0015\u0011!a\u0001]!1\u0011+\tQ!\n9\nQA\\3yi\u0002BQaU\u0011\u0005\u0002y\n\u0011B\u001a:fKN\u0003\u0018mY3\u0007\tU\u0003\u0001B\u0016\u0002\u000f%\u0016\u001cXM\u001d<fI>+H\u000f];u'\r!\u0006\u0002\u0005\u0005\t1R\u0013\t\u0011)A\u0005]\u0005\u00191/Z4\t\u0011i#&\u0011!Q\u0001\na\taa\u001c4gg\u0016$\b\u0002\u0003/U\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\r1,gn\u001a;i\u0011\u0015aB\u000b\"\u0001_)\u0011y\u0006-\u00192\u0011\u0005=\"\u0006\"\u0002-^\u0001\u0004q\u0003\"\u0002.^\u0001\u0004A\u0002\"\u0002/^\u0001\u0004A\u0002B\u00023UA\u0003&a&A\u0002dkJDaA\u001a+!B\u0013A\u0012aA8gM\"1\u0001\u000e\u0016Q!\na\t1\u0001\\3o\u0011\u0015QG\u000b\"\u0011l\u0003\u00159(/\u001b;f)\t\u0011E\u000eC\u0003nS\u0002\u0007\u0001$A\u0003wC2,X\rC\u0004p\u0001\u0001\u0007I\u0011C&\u0002\u001d\r,(O]3oiN+w-\\3oi\"9\u0011\u000f\u0001a\u0001\n#\u0011\u0018AE2veJ,g\u000e^*fO6,g\u000e^0%KF$\"AQ:\t\u000f\u0019\u0003\u0018\u0011!a\u0001]!1Q\u000f\u0001Q!\n9\nqbY;se\u0016tGoU3h[\u0016tG\u000f\t\u0005\u0007o\u0002\u0001\u000b\u0011\u0002\u0018\u0002\u0017!,\u0017\rZ*fO6,g\u000e\u001e\u0005\u0007s\u0002\u0001\u000b\u0015\u0002\r\u0002\r\u0019LG\u000e\\3e\u0011\u0015Y\u0003\u0001\"\u0001|)\u0005A\u0002\"\u00026\u0001\t\u0003jHC\u0001\"\u007f\u0011\u0015yH\u00101\u0001\u0019\u0003\u0005\u0011\u0007B\u00026\u0001\t\u0003\n\u0019\u0001F\u0004C\u0003\u000b\t9!!\u0003\t\r}\f\t\u00011\u00015\u0011\u00191\u0017\u0011\u0001a\u00011!1\u0001.!\u0001A\u0002aAaA\u001b\u0001\u0005\u0002\u00055Ac\u0001\"\u0002\u0010!A\u0011\u0011CA\u0006\u0001\u0004\t\u0019\"\u0001\u0002j]B\u0019\u0011\"!\u0006\n\u0007\u0005]!BA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBA\u000e\u0001\u0011%\u0011QD\u0001\u000bC\u0012$7+Z4nK:$H#\u0001\"\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005!1o[5q)\r\u0011\u0015Q\u0005\u0005\u0007Q\u0006}\u0001\u0019\u0001\r\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u00059!/Z:feZ,GcA0\u0002.!1\u0001.a\nA\u0002aAq!!\r\u0001\t\u0003\t\u0019$A\u0004xe&$X\rV8\u0015\u0007\t\u000b)\u0004\u0003\u0005\u00028\u0005=\u0002\u0019AA\u001d\u0003\u0019\u0011WO\u001a4feB!\u00111HA!\u001b\t\tiDC\u0002\u0002@1\t1A\\5p\u0013\u0011\t\u0019%!\u0010\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f")
public class BufferingOutputStream
extends OutputStream
implements ScalaObject {
    private final int segmentSize;
    private Segment currentSegment;
    private final Segment headSegment;
    private int filled;

    public Segment currentSegment() {
        return this.currentSegment;
    }

    public void currentSegment_$eq(Segment segment) {
        this.currentSegment = segment;
    }

    public int size() {
        return this.filled + this.currentSegment().written();
    }

    public void write(int b) {
        if (this.currentSegment().freeSpace() <= 0) {
            this.addSegment();
        }
        this.currentSegment().bytes()[this.currentSegment().written()] = (byte)b;
        Segment segment = this.currentSegment();
        segment.written_$eq(segment.written() + 1);
    }

    public void write(byte[] b, int off, int len) {
        if (off >= 0 && off <= b.length && len >= 0 && off + len <= b.length) {
            int amount;
            int offset = off;
            for (int remaining = len; remaining > 0; remaining -= amount) {
                if (this.currentSegment().freeSpace() <= 0) {
                    this.addSegment();
                }
                amount = package$.MODULE$.min(this.currentSegment().freeSpace(), remaining);
                System.arraycopy(b, offset, this.currentSegment().bytes(), this.currentSegment().written(), amount);
                Segment segment = this.currentSegment();
                segment.written_$eq(segment.written() + amount);
                offset += amount;
            }
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    public void write(InputStream in) {
        int amount = 0;
        while (amount >= 0) {
            Segment segment = this.currentSegment();
            segment.written_$eq(segment.written() + amount);
            if (this.currentSegment().freeSpace() <= 0) {
                this.addSegment();
            }
            amount = in.read(this.currentSegment().bytes(), this.currentSegment().written(), this.currentSegment().freeSpace());
        }
    }

    private void addSegment() {
        this.filled += this.currentSegment().written();
        Segment newSeg = new Segment(this, this.segmentSize);
        this.currentSegment().next_$eq(newSeg);
        this.currentSegment_$eq(newSeg);
    }

    private void skip(int len) {
        if (len >= 0) {
            int amount;
            for (int remaining = len; remaining > 0; remaining -= amount) {
                if (this.currentSegment().freeSpace() <= 0) {
                    this.addSegment();
                }
                amount = package$.MODULE$.min(this.currentSegment().freeSpace(), remaining);
                Segment segment = this.currentSegment();
                segment.written_$eq(segment.written() + amount);
            }
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - void declaration
     */
    public ReservedOutput reserve(int len) {
        void var2_2;
        ReservedOutput out = new ReservedOutput(this, this.currentSegment(), this.currentSegment().written(), len);
        this.skip(len);
        return var2_2;
    }

    public void writeTo(ByteBuffer buffer) {
        Segment seg = this.headSegment;
        while (seg != null) {
            buffer.put(seg.bytes(), 0, seg.written());
            seg = seg.next();
        }
        return;
    }

    public BufferingOutputStream(int segmentSize) {
        this.segmentSize = segmentSize;
        this.currentSegment = new Segment(this, segmentSize);
        this.headSegment = this.currentSegment();
        this.filled = 0;
    }

    public final class Segment
    implements ScalaObject {
        private final byte[] bytes;
        private int written;
        private Segment next;

        public byte[] bytes() {
            return this.bytes;
        }

        public int written() {
            return this.written;
        }

        public void written_$eq(int n) {
            this.written = n;
        }

        public Segment next() {
            return this.next;
        }

        public void next_$eq(Segment segment) {
            this.next = segment;
        }

        public int freeSpace() {
            return this.bytes().length - this.written();
        }

        public Segment(BufferingOutputStream $outer, int size2) {
            this.bytes = new byte[size2];
            this.written = 0;
            this.next = null;
        }
    }

    public class ReservedOutput
    extends OutputStream
    implements ScalaObject {
        private Segment cur;
        private int off;
        private int len;
        public final BufferingOutputStream $outer;

        public void write(int value2) {
            if (this.len <= 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.cur.bytes().length <= this.off) {
                this.cur = this.cur.next();
                this.off = 0;
            }
            this.cur.bytes()[this.off] = (byte)value2;
            ++this.off;
            --this.len;
        }

        public BufferingOutputStream kafka$message$BufferingOutputStream$ReservedOutput$$$outer() {
            return this.$outer;
        }

        public ReservedOutput(BufferingOutputStream $outer, Segment seg, int offset, int length) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.cur = seg;
            this.off = offset;
            this.len = length;
        }
    }
}

