/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mv!B\u0001\u0003\u0011\u000b9\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000byIA\u0011B\u0010\u0002\r\r\u0014X-\u0019;f)\u0011\u0001cEM\u001c\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0002\u0012a\u00018j_&\u0011QE\t\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u0014\u001e\u0001\u0004A\u0013!D8gMN,GoQ8v]R,'\u000f\u0005\u0002*a5\t!F\u0003\u0002,Y\u00051\u0011\r^8nS\u000eT!!\f\u0018\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00020!\u0005!Q\u000f^5m\u0013\t\t$F\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDQaM\u000fA\u0002Q\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005!)\u0014B\u0001\u001c\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u00039;\u0001\u0007\u0011(\u0001\u0005nKN\u001c\u0018mZ3t!\r)\"\bP\u0005\u0003wY\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tAQ(\u0003\u0002?\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002!\n\t\u0003\t\u0015\u0001\u00043fKBLE/\u001a:bi>\u0014HC\u0001\"R!\r\u00195J\u0014\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001&\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0011%#XM]1u_JT!A\u0013\f\u0011\u0005!y\u0015B\u0001)\u0003\u0005AiUm]:bO\u0016\fe\u000eZ(gMN,G\u000fC\u0003S\u007f\u0001\u0007A(\u0001\bxe\u0006\u0004\b/\u001a:NKN\u001c\u0018mZ3\t\rQKA\u0011\u0001\u0003V\u000319(/\u001b;f\u001b\u0016\u001c8/Y4f)\u00111\u0016l\u0017/\u0011\u0005U9\u0016B\u0001-\u0017\u0005\u0011)f.\u001b;\t\u000bi\u001b\u0006\u0019\u0001\u0011\u0002\r\t,hMZ3s\u0011\u0015\u00191\u000b1\u0001=\u0011\u0015i6\u000b1\u0001_\u0003\u0019ygMZ:fiB\u0011QcX\u0005\u0003AZ\u0011A\u0001T8oO\"1A+\u0003C\u0001\t\t$BAV2eS\")!,\u0019a\u0001A!)Q-\u0019a\u0001M\u0006iQ.Z:tC\u001e,wK]5uKJ\u0004\"\u0001C4\n\u0005!\u0014!!D'fgN\fw-Z,sSR,'\u000fC\u0003^C\u0002\u0007aL\u0002\u0003\u000b\u0005\u0001Y7\u0003\u00026m_R\u0001\"\u0001C7\n\u00059\u0014!AC'fgN\fw-Z*fiB\u0011\u0001o]\u0007\u0002c*\u0011!\u000fB\u0001\u0006kRLGn]\u0005\u0003iF\u0014q\u0001T8hO&tw\r\u0003\u0005[U\n\u0015\r\u0011\"\u0001w+\u0005\u0001\u0003\u0002\u0003=k\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u000f\t,hMZ3sA!)1D\u001bC\u0001uR\u00111\u0010 \t\u0003\u0011)DQAW=A\u0002\u0001BqA 6A\u0002\u0013%q0A\u000btQ\u0006dGn\\<WC2LGMQ=uK\u000e{WO\u001c;\u0016\u0005\u0005\u0005\u0001cA\u000b\u0002\u0004%\u0019\u0011Q\u0001\f\u0003\u0007%sG\u000fC\u0005\u0002\n)\u0004\r\u0011\"\u0003\u0002\f\u0005I2\u000f[1mY><h+\u00197jI\nKH/Z\"pk:$x\fJ3r)\r1\u0016Q\u0002\u0005\u000b\u0003\u001f\t9!!AA\u0002\u0005\u0005\u0011a\u0001=%c!A\u00111\u00036!B\u0013\t\t!\u0001\ftQ\u0006dGn\\<WC2LGMQ=uK\u000e{WO\u001c;!\u0011\u0019Y\"\u000e\"\u0001\u0002\u0018Q)10!\u0007\u0002\u001c!11'!\u0006A\u0002QBa\u0001OA\u000b\u0001\u0004I\u0004BB\u000ek\t\u0003\ty\u0002F\u0004|\u0003C\t\u0019#!\n\t\rM\ni\u00021\u00015\u0011\u00199\u0013Q\u0004a\u0001Q!1\u0001(!\bA\u0002eBaa\u00076\u0005\u0002\u0005%BcA>\u0002,!1\u0001(a\nA\u0002eBa!a\fk\t\u00031\u0018!C4fi\n+hMZ3s\u0011\u0019\t\u0019D\u001bC\u0005\u007f\u0006\t2\u000f[1mY><h+\u00197jI\nKH/Z:\t\u000f\u0005]\"\u000e\"\u0001\u0002:\u00059qO]5uKR{G\u0003CA\u0001\u0003w\tY%!\u0014\t\u0011\u0005u\u0012Q\u0007a\u0001\u0003\u007f\tqa\u00195b]:,G\u000e\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)EI\u0001\tG\"\fgN\\3mg&!\u0011\u0011JA\"\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\"1Q,!\u000eA\u0002yC\u0001\"a\u0014\u00026\u0001\u0007\u0011\u0011A\u0001\u0005g&TX\rC\u0004\u0002T)$\t%!\u0016\u0002\u0011%$XM]1u_J,\u0012A\u0011\u0005\b\u00033RG\u0011AA+\u0003=\u0019\b.\u00197m_^LE/\u001a:bi>\u0014\bbBA/U\u0012%\u0011qL\u0001\u0011S:$XM\u001d8bY&#XM]1u_J$2AQA1\u0011)\t\u0019'a\u0017\u0011\u0002\u0003\u0007\u0011QM\u0001\nSN\u001c\u0006.\u00197m_^\u00042!FA4\u0013\r\tIG\u0006\u0002\b\u0005>|G.Z1o\u0011!\tiG\u001bC\u0001\t\u0005=\u0014\u0001\t<bY&$\u0017\r^3NKN\u001c\u0018mZ3t\u0003:$\u0017i]:jO:|eMZ:fiN$\u0012b_A9\u0003g\n9(a\u001f\t\r\u001d\nY\u00071\u0001)\u0011\u001d\t)(a\u001bA\u0002Q\n1b]8ve\u000e,7i\u001c3fG\"9\u0011\u0011PA6\u0001\u0004!\u0014a\u0003;be\u001e,GoQ8eK\u000eD!\"! \u0002lA\u0005\t\u0019AA3\u00039\u0019w.\u001c9bGR,G\rV8qS\u000eDa!!!k\t\u0003y\u0018aC:ju\u0016LeNQ=uKNDa!!\"k\t\u0003y\u0018A\u0003<bY&$')\u001f;fg\"9\u0011\u0011\u00126\u0005B\u0005-\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u00055\u0005\u0002CAH\u0003\u000f\u0003\r!!%\u0002\u000b=$\b.\u001a:\u0011\u0007U\t\u0019*C\u0002\u0002\u0016Z\u00111!\u00118z\u0011\u001d\tIJ\u001bC!\u00037\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003A\u0011\"a(k#\u0003%\t!!)\u0002UY\fG.\u001b3bi\u0016lUm]:bO\u0016\u001c\u0018I\u001c3BgNLwM\\(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0015\u0016\u0005\u0003K\n)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\tLF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tIL[I\u0001\n\u0013\t\t+\u0001\u000ej]R,'O\\1m\u0013R,'/\u0019;pe\u0012\"WMZ1vYR$\u0013\u0007")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Iterator<MessageAndOffset> deepIterator(Message message) {
        return ByteBufferMessageSet$.MODULE$.deepIterator(message);
    }

    public static final ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong atomicLong, CompressionCodec compressionCodec, Seq<Message> seq) {
        return ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(atomicLong, compressionCodec, seq);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int n) {
        this.shallowValidByteCount = n;
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            int bytes = 0;
            Iterator<MessageAndOffset> iter = this.internalIterator(true);
            while (iter.hasNext()) {
                MessageAndOffset messageAndOffset = iter.next();
                bytes += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            this.shallowValidByteCount_$eq(bytes);
        }
        return this.shallowValidByteCount();
    }

    @Override
    public int writeTo(GatheringByteChannel channel, long offset, int size2) {
        int written;
        this.buffer().mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer())) {
        }
        this.buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.internalIterator(this.internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.internalIterator(true);
    }

    private Iterator<MessageAndOffset> internalIterator(boolean isShallow$1) {
        return new IteratorTemplate<MessageAndOffset>(this, isShallow$1){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer byteBuffer) {
                this.topIter = byteBuffer;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> iterator2) {
                this.innerIter = iterator2;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long offset = this.topIter().getLong();
                int size2 = this.topIter().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append(BoxesRunTime.boxToInteger(size2)).append((Object)") in shallow iterator").toString());
                }
                if (this.topIter().remaining() < size2) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.topIter().slice();
                message.limit(size2);
                this.topIter().position(this.topIter().position() + size2);
                Message newMessage = new Message(message);
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                } else {
                    CompressionCodec compressionCodec = newMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset = new MessageAndOffset(newMessage, offset);
                    } else {
                        this.innerIter_$eq(ByteBufferMessageSet$.MODULE$.deepIterator(newMessage));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset = this.makeNext();
                    }
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : this.innerIter().next());
            }
            {
                this.isShallow$1 = bl;
                this.topIter = $outer.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    private boolean internalIterator$default$1() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBufferMessageSet validateMessagesAndAssignOffsets(AtomicLong offsetCounter, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic$1) {
        ByteBufferMessageSet byteBufferMessageSet;
        block10: {
            block9: {
                CompressionCodec compressionCodec = sourceCodec;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) break block9;
                CompressionCodec compressionCodec2 = targetCodec;
                NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
                if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) break block10;
            }
            if (compactedTopic$1) {
                CompressionCodec compressionCodec = targetCodec;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) {
                    throw new InvalidMessageException("Compacted topic cannot accept compressed messages. Either the producer sent a compressed message or the topic has been configured with a broker-side compression codec.");
                }
            }
            Iterator messages = this.internalIterator(false).map(new Serializable(this, compactedTopic$1){
                public static final long serialVersionUID;
                private final boolean compactedTopic$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Message apply(MessageAndOffset messageAndOffset) {
                    if (this.compactedTopic$1 && !messageAndOffset.message().hasKey()) {
                        throw new InvalidMessageException("Compacted topic cannot accept message without key.");
                    }
                    return messageAndOffset.message();
                }
                {
                    this.compactedTopic$1 = bl;
                }
            });
            byteBufferMessageSet = new ByteBufferMessageSet(targetCodec, offsetCounter, messages.toBuffer());
            return byteBufferMessageSet;
        }
        int messagePosition = 0;
        this.buffer().mark();
        while (true) {
            if (messagePosition >= this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead()) {
                this.buffer().reset();
                byteBufferMessageSet = this;
                return byteBufferMessageSet;
            }
            this.buffer().position(messagePosition);
            this.buffer().putLong(offsetCounter.getAndIncrement());
            int messageSize = this.buffer().getInt();
            int positionAfterKeySize = this.buffer().position() + Message$.MODULE$.KeySizeOffset() + Message$.MODULE$.KeySizeLength();
            if (compactedTopic$1 && positionAfterKeySize < this.sizeInBytes()) {
                this.buffer().position(this.buffer().position() + Message$.MODULE$.KeySizeOffset());
                int keySize = this.buffer().getInt();
                if (keySize <= 0) {
                    this.buffer().reset();
                    throw new InvalidMessageException("Compacted topic cannot accept message without key.");
                }
            }
            messagePosition += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
    }

    public boolean validateMessagesAndAssignOffsets$default$4() {
        return false;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    @Override
    public boolean equals(Object other) {
        Object object = other;
        return object instanceof ByteBufferMessageSet ? this.buffer().equals(((ByteBufferMessageSet)object).buffer()) : false;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer) {
        this.buffer = buffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new AtomicLong(0L), compressionCodec, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, AtomicLong offsetCounter, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(offsetCounter, compressionCodec, messages));
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, new AtomicLong(0L), messages);
    }
}

