/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class KafkaMetricsGroup$
implements KafkaMetricsGroup {
    public static final KafkaMetricsGroup$ MODULE$;
    private final List<MetricName> consumerMetricNameList;
    private final List<MetricName> producerMetricNameList;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new KafkaMetricsGroup$();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaMetricsGroup$ kafkaMetricsGroup$ = this;
        synchronized (kafkaMetricsGroup$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private List<MetricName> consumerMetricNameList() {
        return this.consumerMetricNameList;
    }

    private List<MetricName> producerMetricNameList() {
        return this.producerMetricNameList;
    }

    public final Option<String> kafka$metrics$KafkaMetricsGroup$$toMBeanName(Map<String, String> tags) {
        Option option;
        Map filteredTags = (Map)tags.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string2 = tuple22._2();
                    String string3 = "";
                    return string2 != null ? !string2.equals(string3) : string3 != null;
                }
                throw new MatchError(tuple22);
            }
        }));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)filteredTags.map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return Predef$.MODULE$.augmentString("%s=%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{tuple22._1(), tuple22._2()}));
                    }
                    throw new MatchError(tuple22);
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
            option = new Some<String>(tagsString);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public final Option<String> kafka$metrics$KafkaMetricsGroup$$toScope(Map<String, String> tags) {
        Option option;
        Map filteredTags = (Map)tags.filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string2 = tuple22._2();
                    String string3 = "";
                    return string2 != null ? !string2.equals(string3) : string3 != null;
                }
                throw new MatchError(tuple22);
            }
        }));
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)((TraversableLike)filteredTags.toList().sortWith(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, String> t1, Tuple2<String, String> t2) {
                    return Predef$.MODULE$.augmentString(t1._1()).$less(t2._1());
                }
            })).map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return Predef$.MODULE$.augmentString("%s.%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{tuple22._1(), tuple22._2().replaceAll("\\.", "_")}));
                    }
                    throw new MatchError(tuple22);
                }
            }, List$.MODULE$.canBuildFrom())).mkString(".");
            option = new Some<String>(tagsString);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void removeAllConsumerMetrics(String clientId) {
        FetchRequestAndResponseStatsRegistry$.MODULE$.removeConsumerFetchRequestAndResponseStats(clientId);
        ConsumerTopicStatsRegistry$.MODULE$.removeConsumerTopicStat(clientId);
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        this.removeAllMetricsInList(this.consumerMetricNameList(), clientId);
    }

    public void removeAllProducerMetrics(String clientId) {
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        ProducerTopicStatsRegistry$.MODULE$.removeProducerTopicStats(clientId);
        ProducerStatsRegistry$.MODULE$.removeProducerStats(clientId);
        this.removeAllMetricsInList(this.producerMetricNameList(), clientId);
    }

    private void removeAllMetricsInList(List<MetricName> metricNameList, String clientId$1) {
        metricNameList.foreach(new Serializable(clientId$1){
            public static final long serialVersionUID;
            private final String clientId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MetricName metric$1) {
                Regex pattern$1 = Predef$.MODULE$.augmentString(new StringBuilder().append((Object)".*clientId=").append((Object)this.clientId$1).append((Object)".*").toString()).r();
                Set<MetricName> registeredMetrics = JavaConversions$.MODULE$.asScalaSet(Metrics.defaultRegistry().allMetrics().keySet());
                registeredMetrics.foreach(new Serializable(this, metric$1, pattern$1){
                    public static final long serialVersionUID;
                    private final MetricName metric$1;
                    private final Regex pattern$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MetricName registeredMetric$1) {
                        String string2 = registeredMetric$1.getGroup();
                        String string3 = this.metric$1.getGroup();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            String string4 = registeredMetric$1.getName();
                            String string5 = this.metric$1.getName();
                            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                Option<String> option;
                                String string6 = registeredMetric$1.getType();
                                String string7 = this.metric$1.getType();
                                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && (option = this.pattern$1.findFirstIn(registeredMetric$1.getMBeanName())) instanceof Some) {
                                    int beforeRemovalSize$1 = Metrics.defaultRegistry().allMetrics().keySet().size();
                                    Metrics.defaultRegistry().removeMetric(registeredMetric$1);
                                    int afterRemovalSize$1 = Metrics.defaultRegistry().allMetrics().keySet().size();
                                    KafkaMetricsGroup$.MODULE$.trace((Function0<String>)((Object)new Serializable(this, registeredMetric$1, beforeRemovalSize$1, afterRemovalSize$1){
                                        public static final long serialVersionUID;
                                        private final MetricName registeredMetric$1;
                                        private final int beforeRemovalSize$1;
                                        private final int afterRemovalSize$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Removing metric %s. Metrics registry size reduced from %d to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.registeredMetric$1, BoxesRunTime.boxToInteger(this.beforeRemovalSize$1), BoxesRunTime.boxToInteger(this.afterRemovalSize$1)}));
                                        }
                                        {
                                            this.registeredMetric$1 = metricName;
                                            this.beforeRemovalSize$1 = n;
                                            this.afterRemovalSize$1 = n2;
                                        }
                                    }));
                                }
                            }
                        }
                    }
                    {
                        this.metric$1 = metricName;
                        this.pattern$1 = regex;
                    }
                });
            }
            {
                this.clientId$1 = string2;
            }
        });
    }

    private KafkaMetricsGroup$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.consumerMetricNameList = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "FetchQueueSize"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "KafkaCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "ZooKeeperCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "RebalanceRateAndTime"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "OwnedPartitionsCount"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MaxLag"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "MinFetchRate"), new MetricName("kafka.server", "FetcherLagMetrics", "ConsumerLag"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "RequestsPerSec"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchResponseSize"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "FetchRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize")}));
        this.producerMetricNameList = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.producer", "ProducerStats", "SerializationErrorsPerSec"), new MetricName("kafka.producer", "ProducerStats", "ResendsPerSec"), new MetricName("kafka.producer", "ProducerStats", "FailedSendsPerSec"), new MetricName("kafka.producer.async", "ProducerSendThread", "ProducerQueueSize"), new MetricName("kafka.producer", "ProducerTopicMetrics", "MessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "DroppedMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "BytesPerSec"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "ProducerRequestSize")}));
    }
}

