/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import kafka.api.RequestOrResponse;
import kafka.common.security.LoginManager$;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.Channel;
import org.apache.kafka.common.network.DefaultAuthenticator;
import org.apache.kafka.common.network.PlainTextTransportLayer;
import org.apache.kafka.common.network.SaslClientAuthenticator;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mv!B\u0001\u0003\u0011\u000b9\u0011a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u000bY!a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0014\u0007%aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000bmIA\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\u0010\n\u0005\u0004%\taH\u0001\u0015+N,G)\u001a4bk2$()\u001e4gKJ\u001c\u0016N_3\u0016\u0003\u0001\u0002\"!F\u0011\n\u0005\t2\"aA%oi\"1A%\u0003Q\u0001\n\u0001\nQ#V:f\t\u00164\u0017-\u001e7u\u0005V4g-\u001a:TSj,\u0007\u0005C\u0004'\u0013E\u0005I\u0011A\u0014\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\t\u0001F\u000b\u0002*mA\u0011!\u0006N\u0007\u0002W)\u0011A&L\u0001\taJ|Go\\2pY*\u0011afL\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001$BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001eL!!N\u0016\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d7&A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014!C;oG\",7m[3e\u0015\tad#\u0001\u0006b]:|G/\u0019;j_:L!AP\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWM\u0002\u0003\u000b\u0005\u0001\u00015\u0003B \r\u0003R\u0001\"AQ#\u000e\u0003\rS!\u0001\u0012\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001b%a\u0002'pO\u001eLgn\u001a\u0005\t\u0011~\u0012)\u0019!C\u0001\u0013\u0006!\u0001n\\:u+\u0005Q\u0005CA&O\u001d\t)B*\u0003\u0002N-\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tie\u0003\u0003\u0005S\u007f\t\u0005\t\u0015!\u0003K\u0003\u0015Awn\u001d;!\u0011!!vH!b\u0001\n\u0003y\u0012\u0001\u00029peRD\u0001BV \u0003\u0002\u0003\u0006I\u0001I\u0001\u0006a>\u0014H\u000f\t\u0005\t1~\u0012)\u0019!C\u0001?\u0005q!/Z1e\u0005V4g-\u001a:TSj,\u0007\u0002\u0003.@\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u001fI,\u0017\r\u001a\"vM\u001a,'oU5{K\u0002B\u0001\u0002X \u0003\u0006\u0004%\taH\u0001\u0010oJLG/\u001a\"vM\u001a,'oU5{K\"Aal\u0010B\u0001B\u0003%\u0001%\u0001\txe&$XMQ;gM\u0016\u00148+\u001b>fA!A\u0001m\u0010BC\u0002\u0013\u0005q$A\u0007sK\u0006$G+[7f_V$Xj\u001d\u0005\tE~\u0012\t\u0011)A\u0005A\u0005q!/Z1e)&lWm\\;u\u001bN\u0004\u0003\u0002\u0003\u0017@\u0005\u000b\u0007I\u0011\u00013\u0016\u0003%B\u0001BZ \u0003\u0002\u0003\u0006I!K\u0001\naJ|Go\\2pY\u0002BQaG \u0005\u0002!$r!\u001b6lY6tw\u000e\u0005\u0002\t\u007f!)\u0001j\u001aa\u0001\u0015\")Ak\u001aa\u0001A!)\u0001l\u001aa\u0001A!)Al\u001aa\u0001A!)\u0001m\u001aa\u0001A!9Af\u001aI\u0001\u0002\u0004I\u0003bB9@\u0001\u0004%IA]\u0001\nG>tg.Z2uK\u0012,\u0012a\u001d\t\u0003+QL!!\u001e\f\u0003\u000f\t{w\u000e\\3b]\"9qo\u0010a\u0001\n\u0013A\u0018!D2p]:,7\r^3e?\u0012*\u0017\u000f\u0006\u0002zyB\u0011QC_\u0005\u0003wZ\u0011A!\u00168ji\"9QP^A\u0001\u0002\u0004\u0019\u0018a\u0001=%c!1qp\u0010Q!\nM\f!bY8o]\u0016\u001cG/\u001a3!\u0011%\t\u0019a\u0010a\u0001\n\u0013\t)!A\u0004dQ\u0006tg.\u001a7\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u0005\ri\u0013\u0002BA\b\u0003\u0017\u0011qa\u00115b]:,G\u000eC\u0005\u0002\u0014}\u0002\r\u0011\"\u0003\u0002\u0016\u0005Y1\r[1o]\u0016dw\fJ3r)\rI\u0018q\u0003\u0005\n{\u0006E\u0011\u0011!a\u0001\u0003\u000fA\u0001\"a\u0007@A\u0003&\u0011qA\u0001\tG\"\fgN\\3mA!I\u0011qD A\u0002\u0013%\u0011\u0011E\u0001\fe\u0016\fGm\u00115b]:,G.\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001C2iC:tW\r\\:\u000b\u0007\u00055\u0002#A\u0002oS>LA!!\r\u0002(\t\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"I\u0011QG A\u0002\u0013%\u0011qG\u0001\u0010e\u0016\fGm\u00115b]:,Gn\u0018\u0013fcR\u0019\u00110!\u000f\t\u0013u\f\u0019$!AA\u0002\u0005\r\u0002\u0002CA\u001f\u007f\u0001\u0006K!a\t\u0002\u0019I,\u0017\rZ\"iC:tW\r\u001c\u0011\t\u0013\u0005\u0005s\b1A\u0005\n\u0005\r\u0013\u0001D<sSR,7\t[1o]\u0016dWCAA#!\u0011\t)#a\u0012\n\t\u0005%\u0013q\u0005\u0002\u0015\u000f\u0006$\b.\u001a:j]\u001e\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u0013\u00055s\b1A\u0005\n\u0005=\u0013\u0001E<sSR,7\t[1o]\u0016dw\fJ3r)\rI\u0018\u0011\u000b\u0005\n{\u0006-\u0013\u0011!a\u0001\u0003\u000bB\u0001\"!\u0016@A\u0003&\u0011QI\u0001\u000eoJLG/Z\"iC:tW\r\u001c\u0011\t\u0013\u0005esH1A\u0005\n\u0005m\u0013\u0001\u00027pG.,\u0012\u0001\u0004\u0005\b\u0003?z\u0004\u0015!\u0003\r\u0003\u0015awnY6!\u0011!\t\u0019g\u0010b\u0001\n\u0013y\u0012\u0001E2p]:,7\r\u001e+j[\u0016|W\u000f^'t\u0011\u001d\t9g\u0010Q\u0001\n\u0001\n\u0011cY8o]\u0016\u001cG\u000fV5nK>,H/T:!\u0011!\tYg\u0010b\u0001\n\u0013y\u0012A\u00055b]\u0012\u001c\b.Y6f)&lWm\\;u\u001bNDq!a\u001c@A\u0003%\u0001%A\niC:$7\u000f[1lKRKW.Z8vi6\u001b\b\u0005C\u0004\u0002t}\"\t!!\u001e\u0002\u000f\r|gN\\3diR\t\u0011\u0010C\u0004\u0002z}\"\t!!\u001e\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000f\u0003\u0004\u0002~}\"\tA]\u0001\fSN\u001cuN\u001c8fGR,G\rC\u0004\u0002\u0002~\"\t!a!\u0002\tM,g\u000e\u001a\u000b\u0004A\u0005\u0015\u0005\u0002CAD\u0003\u007f\u0002\r!!#\u0002\u000fI,\u0017/^3tiB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010\u0012\t1!\u00199j\u0013\u0011\t\u0019*!$\u0003#I+\u0017/^3ti>\u0013(+Z:q_:\u001cX\rC\u0004\u0002\u0018~\"\t!!'\u0002\u000fI,7-Z5wKR\u0011\u00111\u0014\t\u0004\u0011\u0005u\u0015bAAP\u0005\t9!+Z2fSZ,\u0007bBAR\u007f\u0011%\u0011QU\u0001\u000eGJ,\u0017\r^3DQ\u0006tg.\u001a7\u0015\r\u0005\u001d\u0011qUAU\u0011\u0019a\u0013\u0011\u0015a\u0001S!A\u00111VAQ\u0001\u0004\ti+A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\t\u0005\u0003K\ty+\u0003\u0003\u00022\u0006\u001d\"!D*pG.,Go\u00115b]:,G\u000eK\u0002@\u0003k\u00032AQA\\\u0013\r\tIl\u0011\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class BlockingChannel
implements Logging {
    private final String host;
    private final int port;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int readTimeoutMs;
    private final SecurityProtocol protocol;
    private boolean connected;
    private Channel kafka$network$BlockingChannel$$channel;
    private ReadableByteChannel kafka$network$BlockingChannel$$readChannel;
    private GatheringByteChannel writeChannel;
    private final Object lock;
    private final int kafka$network$BlockingChannel$$connectTimeoutMs;
    private final int handshakeTimeoutMs;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final SecurityProtocol init$default$6() {
        return BlockingChannel$.MODULE$.init$default$6();
    }

    public static final int UseDefaultBufferSize() {
        return BlockingChannel$.MODULE$.UseDefaultBufferSize();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        BlockingChannel blockingChannel = this;
        synchronized (blockingChannel) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    public SecurityProtocol protocol() {
        return this.protocol;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean bl) {
        this.connected = bl;
    }

    public final Channel kafka$network$BlockingChannel$$channel() {
        return this.kafka$network$BlockingChannel$$channel;
    }

    private void kafka$network$BlockingChannel$$channel_$eq(Channel channel) {
        this.kafka$network$BlockingChannel$$channel = channel;
    }

    public final ReadableByteChannel kafka$network$BlockingChannel$$readChannel() {
        return this.kafka$network$BlockingChannel$$readChannel;
    }

    private void kafka$network$BlockingChannel$$readChannel_$eq(ReadableByteChannel readableByteChannel) {
        this.kafka$network$BlockingChannel$$readChannel = readableByteChannel;
    }

    private GatheringByteChannel writeChannel() {
        return this.writeChannel;
    }

    private void writeChannel_$eq(GatheringByteChannel gatheringByteChannel) {
        this.writeChannel = gatheringByteChannel;
    }

    private Object lock() {
        return this.lock;
    }

    public final int kafka$network$BlockingChannel$$connectTimeoutMs() {
        return this.kafka$network$BlockingChannel$$connectTimeoutMs;
    }

    private int handshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    public void connect() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (this.connected()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void disconnect() {
        Object object = this.lock();
        synchronized (object) {
            if (this.kafka$network$BlockingChannel$$channel() != null) {
                this.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final BlockingChannel $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$BlockingChannel$$channel().close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.kafka$network$BlockingChannel$$channel_$eq(null);
                this.writeChannel_$eq(null);
            }
            if (this.kafka$network$BlockingChannel$$readChannel() != null) {
                this.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final BlockingChannel $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$BlockingChannel$$readChannel().close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.kafka$network$BlockingChannel$$readChannel_$eq(null);
            }
            this.connected_$eq(false);
            return;
        }
    }

    public boolean isConnected() {
        return this.connected();
    }

    public int send(RequestOrResponse request) {
        if (this.connected()) {
            BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
            return send2.writeCompletely(this.writeChannel());
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - void declaration
     */
    public Receive receive() {
        if (this.connected()) {
            void var1_1;
            BoundedByteBufferReceive response = new BoundedByteBufferReceive();
            response.readCompletely(this.kafka$network$BlockingChannel$$readChannel());
            return var1_1;
        }
        throw new ClosedChannelException();
    }

    private Channel createChannel(SecurityProtocol protocol, SocketChannel socketChannel) {
        PlainTextTransportLayer transportLayer = null;
        Authenticator authenticator = null;
        DefaultPrincipalBuilder principalBuilder = new DefaultPrincipalBuilder();
        transportLayer = new PlainTextTransportLayer(socketChannel);
        SecurityProtocol securityProtocol = protocol;
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXTSASL;
        authenticator = !(securityProtocol != null ? !((Object)((Object)securityProtocol)).equals((Object)securityProtocol2) : securityProtocol2 != null) ? new SaslClientAuthenticator(LoginManager$.MODULE$.subject(), transportLayer, LoginManager$.MODULE$.serviceName(), this.host()) : new DefaultAuthenticator(transportLayer, principalBuilder);
        return new Channel(transportLayer, authenticator);
    }

    private final void liftedTree1$1() {
        try {
            block5: {
                SocketChannel socketChannel = SocketChannel.open();
                if (this.readBufferSize() > 0) {
                    socketChannel.socket().setReceiveBufferSize(this.readBufferSize());
                }
                if (this.writeBufferSize() > 0) {
                    socketChannel.socket().setSendBufferSize(this.writeBufferSize());
                }
                socketChannel.configureBlocking(true);
                socketChannel.socket().setSoTimeout(this.readTimeoutMs());
                socketChannel.socket().setKeepAlive(true);
                socketChannel.socket().setTcpNoDelay(true);
                socketChannel.socket().connect(new InetSocketAddress(this.host(), this.port()), this.kafka$network$BlockingChannel$$connectTimeoutMs());
                this.kafka$network$BlockingChannel$$channel_$eq(this.createChannel(this.protocol(), socketChannel));
                long handshakeInterval = SystemTime$.MODULE$.milliseconds();
                do {
                    if (this.kafka$network$BlockingChannel$$channel().isReady()) break block5;
                    this.kafka$network$BlockingChannel$$channel().connect(true, true);
                } while (this.kafka$network$BlockingChannel$$channel().isReady() || SystemTime$.MODULE$.milliseconds() - handshakeInterval <= (long)this.handshakeTimeoutMs());
                throw new SocketTimeoutException("Socket timeout during handshake");
            }
            this.writeChannel_$eq(this.kafka$network$BlockingChannel$$channel());
            this.kafka$network$BlockingChannel$$readChannel_$eq(Channels.newChannel(this.kafka$network$BlockingChannel$$channel().socketChannel().socket().getInputStream()));
            this.connected_$eq(true);
            String msg$1 = "Created socket with SO_TIMEOUT = %d (requested %d), SO_RCVBUF = %d (requested %d), SO_SNDBUF = %d (requested %d), connectTimeoutMs = %d.";
            this.debug((Function0<String>)((Object)new Serializable(this, msg$1){
                public static final long serialVersionUID;
                private final BlockingChannel $outer;
                private final String msg$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString(this.msg$1).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$network$BlockingChannel$$channel().socketChannel().socket().getSoTimeout()), BoxesRunTime.boxToInteger(this.$outer.readTimeoutMs()), BoxesRunTime.boxToInteger(this.$outer.kafka$network$BlockingChannel$$channel().socketChannel().socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger(this.$outer.readBufferSize()), BoxesRunTime.boxToInteger(this.$outer.kafka$network$BlockingChannel$$channel().socketChannel().socket().getSendBufferSize()), BoxesRunTime.boxToInteger(this.$outer.writeBufferSize()), BoxesRunTime.boxToInteger(this.$outer.kafka$network$BlockingChannel$$connectTimeoutMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.msg$1 = string2;
                }
            }));
        }
        catch (Throwable throwable) {
            this.disconnect();
        }
    }

    public BlockingChannel(String host, int port, int readBufferSize, int writeBufferSize, int readTimeoutMs, SecurityProtocol protocol) {
        this.host = host;
        this.port = port;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
        this.readTimeoutMs = readTimeoutMs;
        this.protocol = protocol;
        Logging$class.$init$(this);
        this.connected = false;
        this.kafka$network$BlockingChannel$$channel = null;
        this.kafka$network$BlockingChannel$$readChannel = null;
        this.writeChannel = null;
        this.lock = new Object();
        this.kafka$network$BlockingChannel$$connectTimeoutMs = readTimeoutMs;
        this.handshakeTimeoutMs = readTimeoutMs;
    }
}

