/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.AppInfo$;
import kafka.common.QueueFullException;
import kafka.common.security.LoginManager$;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u00052wM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u000511m\u001c8gS\u001e,\u0012\u0001\t\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\n\u0001\u0003\u0006\u0004%I\u0001K\u0001\rKZ,g\u000e\u001e%b]\u0012dWM]\u000b\u0002SA!!&L\u0018;\u001b\u0005Y#B\u0001\u0017\u0003\u0003\u0015\t7/\u001f8d\u0013\tq3F\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u00021c1\u0001A!\u0002\u001a\u0001\u0005\u0004\u0019$!A&\u0012\u0005Q:\u0004C\u0001\r6\u0013\t1\u0014DA\u0004O_RD\u0017N\\4\u0011\u0005aA\u0014BA\u001d\u001a\u0005\r\te.\u001f\t\u0003am\"Q\u0001\u0010\u0001C\u0002M\u0012\u0011A\u0016\u0005\t}\u0001\u0011\t\u0011)A\u0005S\u0005iQM^3oi\"\u000bg\u000e\u001a7fe\u0002BQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDc\u0001\"D\tB!\u0011\u0005A\u0018;\u0011\u0015qr\b1\u0001!\u0011\u00159s\b1\u0001*\u0011\u001d1\u0005A1A\u0005\n\u001d\u000b1\u0002[1t'\",H\u000fZ8x]V\t\u0001\n\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u00061\u0011\r^8nS\u000eT!!\u0014(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002P\u001b\u0005!Q\u000f^5m\u0013\t\t&JA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007'\u0002\u0001\u000b\u0011\u0002%\u0002\u0019!\f7o\u00155vi\u0012|wO\u001c\u0011\t\u000fU\u0003!\u0019!C\u0005-\u0006)\u0011/^3vKV\tq\u000bE\u0002Y3nk\u0011\u0001T\u0005\u000352\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u0004B!\t/0u%\u0011QL\u0001\u0002\r\u0017\u0016LX\rZ'fgN\fw-\u001a\u0005\u0007?\u0002\u0001\u000b\u0011B,\u0002\rE,X-^3!\u0011\u001d\t\u0007\u00011A\u0005\n\t\fAa]=oGV\t1\r\u0005\u0002\u0019I&\u0011Q-\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d9\u0007\u00011A\u0005\n!\f\u0001b]=oG~#S-\u001d\u000b\u0003S2\u0004\"\u0001\u00076\n\u0005-L\"\u0001B+oSRDq!\u001c4\u0002\u0002\u0003\u00071-A\u0002yIEBaa\u001c\u0001!B\u0013\u0019\u0017!B:z]\u000e\u0004\u0003bB9\u0001\u0001\u0004%IA]\u0001\u0013aJ|G-^2feN+g\u000e\u001a+ie\u0016\fG-F\u0001t!\u0011QCo\f\u001e\n\u0005U\\#A\u0005)s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012Dqa\u001e\u0001A\u0002\u0013%\u00010\u0001\fqe>$WoY3s'\u0016tG\r\u00165sK\u0006$w\fJ3r)\tI\u0017\u0010C\u0004nm\u0006\u0005\t\u0019A:\t\rm\u0004\u0001\u0015)\u0003t\u0003M\u0001(o\u001c3vG\u0016\u00148+\u001a8e)\"\u0014X-\u00193!\u0011\u001di\bA1A\u0005\ny\fA\u0001\\8dWV\t\u0011\u0002C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B\u0005\u0002\u000b1|7m\u001b\u0011\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0011\u0001\u00039s_R|7m\u001c7\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003;i!!!\u0004\u000b\t\u0005\u0015\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005U!\u0002BA\f\u00033\ta!\u00199bG\",'BAA\u000e\u0003\ry'oZ\u0005\u0005\u0003?\tiA\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"A\u00111\u0005\u0001!\u0002\u0013\tI!A\u0005qe>$xnY8mA!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011F\u0001\u0013aJ|G-^2feR{\u0007/[2Ti\u0006$8/\u0006\u0002\u0002,A\u0019\u0011%!\f\n\u0007\u0005=\"A\u0001\nQe>$WoY3s)>\u0004\u0018nY*uCR\u001c\b\u0002CA\u001a\u0001\u0001\u0006I!a\u000b\u0002'A\u0014x\u000eZ;dKJ$v\u000e]5d'R\fGo\u001d\u0011\t\r\u0001\u0003A\u0011AA\u001c)\r\u0011\u0015\u0011\b\u0005\u0007=\u0005U\u0002\u0019\u0001\u0011\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005!1/\u001a8e)\rI\u0017\u0011\t\u0005\t\u0003\u0007\nY\u00041\u0001\u0002F\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0019\u0003\u000fZ\u0016bAA%3\tQAH]3qK\u0006$X\r\u001a \t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005Y!/Z2pe\u0012\u001cF/\u0019;t)\rI\u0017\u0011\u000b\u0005\t\u0003\u0007\nY\u00051\u0001\u0002TA)\u0011QKA37:!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\r\u00051AH]8pizJ\u0011AG\u0005\u0004\u0003GJ\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003O\nIGA\u0002TKFT1!a\u0019\u001a\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n\u0011\"Y:z]\u000e\u001cVM\u001c3\u0015\u0007%\f\t\b\u0003\u0005\u0002D\u0005-\u0004\u0019AA*\u0011\u001d\t)\b\u0001C\u0001\u0003o\nQa\u00197pg\u0016$\u0012!\u001b")
public class Producer<K, V>
implements Logging,
ScalaObject {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final Object lock;
    private final SecurityProtocol protocol;
    private final ProducerTopicStats kafka$producer$Producer$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Producer producer = this;
        synchronized (producer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue() {
        return this.kafka$producer$Producer$$queue;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> producerSendThread) {
        this.producerSendThread = producerSendThread;
    }

    private Object lock() {
        return this.lock;
    }

    private SecurityProtocol protocol() {
        return this.protocol;
    }

    public final ProducerTopicStats kafka$producer$Producer$$producerTopicStats() {
        return this.kafka$producer$Producer$$producerTopicStats;
    }

    public void send(Seq<KeyedMessage<K, V>> messages) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block9: {
                block8: {
                    BoxedUnit boxedUnit;
                    block7: {
                        if (this.hasShutdown().get()) {
                            throw new ProducerClosedException();
                        }
                        this.recordStats(messages);
                        bl = this.sync();
                        if (!bl) break block7;
                        this.eventHandler().handle(messages);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (bl) break block9;
                    this.asyncSend(messages);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(BoxesRunTime.boxToBoolean(bl));
        }
    }

    private void recordStats(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KeyedMessage<K, V> message) {
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(message.topic()).messageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().messageRate().mark();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final void apply(KeyedMessage<K, V> message$1) {
                boolean added;
                boolean bl;
                int n = this.$outer.config().queueEnqueueTimeoutMs();
                if (n == 0) {
                    bl = this.$outer.kafka$producer$Producer$$queue().offer(message$1);
                } else {
                    void var3_3;
                    boolean exceptionResult1 = false;
                    try {
                        boolean bl2;
                        boolean bl3;
                        boolean bl4 = bl3 = this.$outer.config().queueEnqueueTimeoutMs() < 0;
                        if (bl3) {
                            this.$outer.kafka$producer$Producer$$queue().put(message$1);
                            bl2 = true;
                        } else {
                            bl2 = this.$outer.kafka$producer$Producer$$queue().offer(message$1, this.$outer.config().queueEnqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                        }
                        exceptionResult1 = bl2;
                    }
                    catch (InterruptedException interruptedException) {
                        exceptionResult1 = false;
                    }
                    bl = added = var3_3;
                }
                if (added) {
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this, message$1){
                        public static final long serialVersionUID;
                        private final KeyedMessage message$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Added to send queue an event: ").append((Object)this.message$1.toString()).toString();
                        }
                        {
                            this.message$1 = var2_2;
                        }
                    }));
                    this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$asyncSend$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Remaining queue size: ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$producer$Producer$$anonfun$$$outer().kafka$producer$Producer$$queue().remainingCapacity())).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    return;
                }
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(message$1.topic()).droppedMessageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().droppedMessageRate().mark();
                throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)message$1.toString()).toString());
            }

            public Producer kafka$producer$Producer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
            if (canShutdown) {
                this.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Shutting down producer";
                    }
                }));
                long startTime$1 = System.nanoTime();
                KafkaMetricsGroup$.MODULE$.removeAllProducerMetrics(this.config().clientId());
                if (this.producerSendThread() != null) {
                    this.producerSendThread().shutdown();
                }
                this.eventHandler().close();
                LoginManager$.MODULE$.shutdown();
                this.info((Function0<String>)((Object)new Serializable(this, startTime$1){
                    public static final long serialVersionUID;
                    private final long startTime$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Producer shutdown completed in ").append(BoxesRunTime.boxToLong((System.nanoTime() - this.startTime$1) / 1000000L)).append((Object)" ms").toString();
                    }
                    {
                        this.startTime$1 = l;
                    }
                }));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Producer(ProducerConfig config, EventHandler<K, V> eventHandler) {
        String string2;
        block7: {
            block6: {
                block5: {
                    block4: {
                        this.config = config;
                        this.eventHandler = eventHandler;
                        Logging$class.$init$(this);
                        this.hasShutdown = new AtomicBoolean(false);
                        this.kafka$producer$Producer$$queue = new LinkedBlockingQueue(config.queueBufferingMaxMessages());
                        this.sync = true;
                        this.producerSendThread = null;
                        this.lock = new Object();
                        this.protocol = SecurityProtocol.valueOf(config.securityProtocol());
                        SecurityProtocol securityProtocol = this.protocol();
                        SecurityProtocol securityProtocol2 = SecurityProtocol.SSLSASL;
                        if (!(securityProtocol == null ? securityProtocol2 != null : !((Object)((Object)securityProtocol)).equals((Object)securityProtocol2))) break block4;
                        SecurityProtocol securityProtocol3 = this.protocol();
                        SecurityProtocol securityProtocol4 = SecurityProtocol.PLAINTEXTSASL;
                        if (securityProtocol3 != null ? !((Object)((Object)securityProtocol3)).equals((Object)securityProtocol4) : securityProtocol4 != null) break block5;
                    }
                    LoginManager$.MODULE$.init("KafkaClient");
                }
                String string3 = string2 = config.producerType();
                String string4 = "sync";
                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block6;
                String string5 = string2;
                String string6 = "async";
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block7;
                this.sync_$eq(false);
                this.producerSendThread_$eq(new ProducerSendThread<K, V>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)config.clientId()).toString(), this.kafka$producer$Producer$$queue(), eventHandler, config.queueBufferingMaxMs(), config.batchNumMessages(), config.clientId()));
                this.producerSendThread().start();
            }
            this.kafka$producer$Producer$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
            KafkaMetricsReporter$.MODULE$.startReporters(config.props());
            AppInfo$.MODULE$.registerInfo();
            return;
        }
        throw new MatchError((Object)string2);
    }

    public Producer(ProducerConfig config) {
        this(config, new DefaultEventHandler(config, (Partitioner)CoreUtils$.MODULE$.createObject(config.partitionerClass(), Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)CoreUtils$.MODULE$.createObject(config.serializerClass(), Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)CoreUtils$.MODULE$.createObject(config.keySerializerClass(), Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), new ProducerPool(config), DefaultEventHandler$.MODULE$.init$default$6()));
    }
}

