/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.common.ErrorMapping$;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.PartitionTopicInfo$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThread$$anonfun$processFetchRequest$2$;
import kafka.server.AbstractFetcherThread$$anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.PartitionFetchState;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0005d!B\u0001\u0003\u0003\u00039!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011!B;uS2\u001c\u0018BA\u0007\u000b\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\n+\u0001\u0011\t\u0011)A\u0005-u\tAA\\1nKB\u0011qC\u0007\b\u0003\u001faI!!\u0007\t\u0002\rA\u0013X\rZ3g\u0013\tYBD\u0001\u0004TiJLgn\u001a\u0006\u00033AI!!\u0006\u0007\t\u0011}\u0001!\u0011!Q\u0001\nY\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1o\\;sG\u0016\u0014%o\\6feB\u00111EJ\u0007\u0002I)\u0011Q\u0005B\u0001\bG2,8\u000f^3s\u0013\t9CE\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\u0011%\u0002!\u0011!Q\u0001\n)\nQb]8dW\u0016$H+[7f_V$\bCA\b,\u0013\ta\u0003CA\u0002J]RD\u0001B\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0011g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\nM\u0016$8\r[*ju\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0010M\u0016$8\r[3s\u0005J|7.\u001a:JI\"AA\u0007\u0001B\u0001B\u0003%!&A\u0004nCb<\u0016-\u001b;\t\u0011Y\u0002!\u0011!Q\u0001\n)\n\u0001\"\\5o\u0005f$Xm\u001d\u0005\tq\u0001\u0011\t\u0011)A\u0005U\u0005qa-\u001a;dQ\n\u000b7m[(gM6\u001b\b\"\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e?\u0003=I7/\u00138uKJ\u0014X\u000f\u001d;jE2,\u0007CA\b=\u0013\ti\u0004CA\u0004C_>dW-\u00198\n\u0005ib\u0001\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u0011A\u0014x\u000e^8d_2\u0004\"AQ&\u000e\u0003\rS!\u0001\u0011#\u000b\u0005\u00153\u0015AB2p[6|gN\u0003\u0002\u0006\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\ta5I\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"R\u0002\u0015*T)V3v\u000bW-[7rk\u0006CA)\u0001\u001b\u0005\u0011\u0001\"B\u000bN\u0001\u00041\u0002\"B\u0010N\u0001\u00041\u0002\"B\u0011N\u0001\u0004\u0011\u0003\"B\u0015N\u0001\u0004Q\u0003\"\u0002\u0018N\u0001\u0004Q\u0003\"\u0002\u0019N\u0001\u0004Q\u0003b\u0002\u001aN!\u0003\u0005\rA\u000b\u0005\bi5\u0003\n\u00111\u0001+\u0011\u001d1T\n%AA\u0002)Bq\u0001O'\u0011\u0002\u0003\u0007!\u0006C\u0004;\u001bB\u0005\t\u0019A\u001e\t\u000f\u0001k\u0005\u0013!a\u0001\u0003\"9q\f\u0001b\u0001\n\u0013\u0001\u0017\u0001\u00049beRLG/[8o\u001b\u0006\u0004X#A1\u0011\t\t<\u0017N\\\u0007\u0002G*\u0011A-Z\u0001\b[V$\u0018M\u00197f\u0015\t1\u0007#\u0001\u0006d_2dWm\u0019;j_:L!\u0001[2\u0003\u000f!\u000b7\u000f['baB\u0011!\u000e\\\u0007\u0002W*\u0011Q\tB\u0005\u0003[.\u0014\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\t\tv.\u0003\u0002q\u0005\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"1!\u000f\u0001Q\u0001\n\u0005\fQ\u0002]1si&$\u0018n\u001c8NCB\u0004\u0003b\u0002;\u0001\u0005\u0004%I!^\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r\u001d'pG.,\u0012A\u001e\t\u0004o\u0006\u0005Q\"\u0001=\u000b\u0005eT\u0018!\u00027pG.\u001c(BA>}\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{z\fA!\u001e;jY*\tq0\u0001\u0003kCZ\f\u0017bAA\u0002q\ni!+Z3oiJ\fg\u000e\u001e'pG.Dq!a\u0002\u0001A\u0003%a/A\tqCJ$\u0018\u000e^5p]6\u000b\u0007\u000fT8dW\u0002B\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\u0002!A\f'\u000f^5uS>tW*\u00199D_:$WCAA\b!\r9\u0018\u0011C\u0005\u0004\u0003'A(!C\"p]\u0012LG/[8o\u0011!\t9\u0002\u0001Q\u0001\n\u0005=\u0011!\u00059beRLG/[8o\u001b\u0006\u00048i\u001c8eA!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011QD\u0001\u000fg&l\u0007\u000f\\3D_:\u001cX/\\3s+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003B\u0001\tG>t7/^7fe&!\u0011\u0011FA\u0012\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJD\u0001\"!\f\u0001A\u0003%\u0011qD\u0001\u0010g&l\u0007\u000f\\3D_:\u001cX/\\3sA!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111G\u0001\t[\u0016$(/[2JIV\u0011\u0011Q\u0007\t\u0004U\u0006]\u0012bAA\u001dW\n\t2\t\\5f]RLE-\u00118e\u0005J|7.\u001a:\t\u0011\u0005u\u0002\u0001)A\u0005\u0003k\t\u0011\"\\3ue&\u001c\u0017\n\u001a\u0011\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0013\u0001\u00044fi\u000eDWM]*uCR\u001cXCAA#!\r\t\u0016qI\u0005\u0004\u0003\u0013\u0012!\u0001\u0004$fi\u000eDWM]*uCR\u001c\b\u0002CA'\u0001\u0001\u0006I!!\u0012\u0002\u001b\u0019,Go\u00195feN#\u0018\r^:!\u0011%\t\t\u0006\u0001b\u0001\n\u0003\t\u0019&A\bgKR\u001c\u0007.\u001a:MC\u001e\u001cF/\u0019;t+\t\t)\u0006E\u0002R\u0003/J1!!\u0017\u0003\u0005=1U\r^2iKJd\u0015mZ*uCR\u001c\b\u0002CA/\u0001\u0001\u0006I!!\u0016\u0002!\u0019,Go\u00195fe2\u000bwm\u0015;biN\u0004\u0003\"CA1\u0001\t\u0007I\u0011AA2\u0003M1W\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3s+\t\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tY\u0007B\u0001\u0004CBL\u0017\u0002BA8\u0003S\u00121CR3uG\"\u0014V-];fgR\u0014U/\u001b7eKJD\u0001\"a\u001d\u0001A\u0003%\u0011QM\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM\u001d\u0011\t\u000f\u0005]\u0004A\"\u0001\u0002z\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"a\u001f\u0002\u0002\u0006\u0015\u0015q\u0012\t\u0004\u001f\u0005u\u0014bAA@!\t!QK\\5u\u0011\u001d\t\u0019)!\u001eA\u0002%\f\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\t9)!\u001eA\u0002\u0005%\u0015a\u00034fi\u000eDwJ\u001a4tKR\u00042aDAF\u0013\r\ti\t\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u0012\u0006U\u0004\u0019AAJ\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011qMAK\u0013\u0011\t9*!\u001b\u00035\u0019+Go\u00195SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\u0005m\u0005A\"\u0001\u0002\u001e\u00061\u0002.\u00198eY\u0016|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0003\u0002\n\u0006}\u0005bBAB\u00033\u0003\r!\u001b\u0005\b\u0003G\u0003a\u0011AAS\u0003iA\u0017M\u001c3mKB\u000b'\u000f^5uS>t7oV5uQ\u0016\u0013(o\u001c:t)\u0011\tY(a*\t\u0011\u0005%\u0016\u0011\u0015a\u0001\u0003W\u000b!\u0002]1si&$\u0018n\u001c8t!\u0015\ti+!0j\u001d\u0011\ty+!/\u000f\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.\u0007\u0003\u0019a$o\\8u}%\t\u0011#C\u0002\u0002<B\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0006\u0005'\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005m\u0006\u0003C\u0004\u0002F\u0002!\t%a2\u0002\u0011MDW\u000f\u001e3po:$\"!a\u001f\t\u000f\u0005-\u0007\u0001\"\u0011\u0002H\u00061Am\\,pe.Dq!a4\u0001\t\u0013\t\t.A\nqe>\u001cWm]:GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0003\u0002|\u0005M\u0007\u0002CAk\u0003\u001b\u0004\r!a6\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005\u001d\u0014\u0011\\\u0005\u0005\u00037\fIG\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0004\u0002`\u0002!\t!!9\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\tY(a9\t\u0011\u0005\u0015\u0018Q\u001ca\u0001\u0003O\f1\u0003]1si&$\u0018n\u001c8B]\u0012|eMZ:fiN\u0004r!!;\u0002l&\fI)D\u0001f\u0013\r\ti/\u001a\u0002\u0004\u001b\u0006\u0004\bbBAy\u0001\u0011\u0005\u00111_\u0001\u0010I\u0016d\u0017-\u001f)beRLG/[8ogR1\u00111PA{\u0003oD\u0001\"!+\u0002p\u0002\u0007\u00111\u0016\u0005\t\u0003s\fy\u000f1\u0001\u0002\n\u0006)A-\u001a7bs\"9\u0011Q \u0001\u0005\u0002\u0005}\u0018\u0001\u0005:f[>4X\rU1si&$\u0018n\u001c8t)\u0011\tYH!\u0001\t\u0011\t\r\u00111 a\u0001\u0005\u000b\t!\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8ogB)\u0011\u0011\u001eB\u0004S&\u0019!\u0011B3\u0003\u0007M+G\u000fC\u0004\u0003\u000e\u0001!\tAa\u0004\u0002\u001dA\f'\u000f^5uS>t7i\\;oiR\t!fB\u0005\u0003\u0014\t\t\t\u0011#\u0002\u0003\u0016\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007cA)\u0003\u0018\u0019A\u0011AAA\u0001\u0012\u000b\u0011IbE\u0003\u0003\u0018\tma\u0002\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\r\u0011\tC`\u0001\u0005Y\u0006tw-\u0003\u0003\u0003&\t}!AB(cU\u0016\u001cG\u000fC\u0004O\u0005/!\tA!\u000b\u0015\u0005\tU\u0001B\u0003B\u0017\u0005/\t\n\u0011\"\u0001\u00030\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012:TC\u0001B\u0019U\rQ#1G\u0016\u0003\u0005k\u0001BAa\u000e\u0003B5\u0011!\u0011\b\u0006\u0005\u0005w\u0011i$A\u0005v]\u000eDWmY6fI*\u0019!q\b\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003D\te\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!q\tB\f#\u0003%\tAa\f\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%q!Q!1\nB\f#\u0003%\tAa\f\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%s!Q!q\nB\f#\u0003%\tAa\f\u0002\u001f%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cAB!Ba\u0015\u0003\u0018E\u0005I\u0011\u0001B+\u0003=Ig.\u001b;%I\u00164\u0017-\u001e7uIE\nTC\u0001B,U\rY$1\u0007\u0005\u000b\u00057\u00129\"%A\u0005\u0002\tu\u0013aD5oSR$C-\u001a4bk2$H%\r\u001a\u0016\u0005\t}#fA!\u00034\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread
implements ScalaObject {
    public final BrokerEndPoint kafka$server$AbstractFetcherThread$$sourceBroker;
    public final int kafka$server$AbstractFetcherThread$$fetchSize;
    public final int kafka$server$AbstractFetcherThread$$fetchBackOffMs;
    private final HashMap<TopicAndPartition, PartitionFetchState> kafka$server$AbstractFetcherThread$$partitionMap;
    private final ReentrantLock partitionMapLock;
    private final Condition kafka$server$AbstractFetcherThread$$partitionMapCond;
    private final SimpleConsumer simpleConsumer;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;
    private final FetchRequestBuilder fetchRequestBuilder;

    public static final SecurityProtocol init$default$12() {
        return AbstractFetcherThread$.MODULE$.init$default$12();
    }

    public static final boolean init$default$11() {
        return AbstractFetcherThread$.MODULE$.init$default$11();
    }

    public static final int init$default$10() {
        return AbstractFetcherThread$.MODULE$.init$default$10();
    }

    public static final int init$default$9() {
        return AbstractFetcherThread$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return AbstractFetcherThread$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return AbstractFetcherThread$.MODULE$.init$default$7();
    }

    public final HashMap<TopicAndPartition, PartitionFetchState> kafka$server$AbstractFetcherThread$$partitionMap() {
        return this.kafka$server$AbstractFetcherThread$$partitionMap;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    public final Condition kafka$server$AbstractFetcherThread$$partitionMapCond() {
        return this.kafka$server$AbstractFetcherThread$$partitionMapCond;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    public abstract void processPartitionData(TopicAndPartition var1, long var2, FetchResponsePartitionData var4);

    public abstract long handleOffsetOutOfRange(TopicAndPartition var1);

    public abstract void handlePartitionsWithErrors(Iterable<TopicAndPartition> var1);

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), new scala.Serializable(this){
            public static final long serialVersionUID;
            private final AbstractFetcherThread $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AbstractFetcherThread$$partitionMapCond().signalAll();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.awaitShutdown();
        this.simpleConsumer().close();
    }

    @Override
    public void doWork() {
        ObjectRef fetchRequest$1 = new ObjectRef(null);
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), new scala.Serializable(this, fetchRequest$1){
            public static final long serialVersionUID;
            private final AbstractFetcherThread $outer;
            private final ObjectRef fetchRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply() {
                Serializable serializable;
                this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$doWork$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Tuple2<TopicAndPartition, PartitionFetchState> tuple2) {
                        Tuple2<TopicAndPartition, PartitionFetchState> tuple22 = tuple2;
                        if (tuple22 != null) {
                            TopicAndPartition topicAndPartition = tuple22._1();
                            PartitionFetchState partitionFetchState = tuple22._2();
                            TopicAndPartition topicAndPartition2 = topicAndPartition;
                            PartitionFetchState partitionFetchState2 = partitionFetchState;
                            return partitionFetchState2.isActive() ? this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().fetchRequestBuilder().addFetch(topicAndPartition2.topic(), topicAndPartition2.partition(), partitionFetchState2.offset(), this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$fetchSize) : BoxedUnit.UNIT;
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.fetchRequest$1.elem = this.$outer.fetchRequestBuilder().build();
                if (((FetchRequest)this.fetchRequest$1.elem).requestInfo().isEmpty()) {
                    this.$outer.trace((Function0<String>)((Object)new scala.Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$doWork$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("There are no active partitions. Back off for %d ms before sending a fetch request").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$fetchBackOffMs)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    serializable = BoxesRunTime.boxToBoolean(this.$outer.kafka$server$AbstractFetcherThread$$partitionMapCond().await(this.$outer.kafka$server$AbstractFetcherThread$$fetchBackOffMs, TimeUnit.MILLISECONDS));
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                return serializable;
            }

            public AbstractFetcherThread kafka$server$AbstractFetcherThread$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetchRequest$1 = objectRef;
            }
        });
        if (!((FetchRequest)fetchRequest$1.elem).requestInfo().isEmpty()) {
            this.processFetchRequest((FetchRequest)fetchRequest$1.elem);
        }
    }

    private void processFetchRequest(FetchRequest fetchRequest$2) {
        HashSet<TopicAndPartition> partitionsWithError$1 = new HashSet<TopicAndPartition>();
        ObjectRef response$1 = new ObjectRef(null);
        BoxedUnit exceptionResult1 = null;
        try {
            this.trace((Function0<String>)((Object)new scala.Serializable(this, fetchRequest$2){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;
                private final FetchRequest fetchRequest$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Issuing to broker %d of fetch request %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$AbstractFetcherThread$$sourceBroker.id()), this.fetchRequest$2}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.fetchRequest$2 = fetchRequest;
                }
            }));
            response$1.elem = this.simpleConsumer().fetch(fetchRequest$2);
            exceptionResult1 = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            Object object;
            if (this.isRunning().get()) {
                this.warn((Function0<String>)((Object)new scala.Serializable(this, fetchRequest$2, throwable){
                    public static final long serialVersionUID;
                    private final FetchRequest fetchRequest$2;
                    private final Throwable t$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Error in fetch %s. Possible cause: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.fetchRequest$2, this.t$1.toString()}));
                    }
                    {
                        this.fetchRequest$2 = fetchRequest;
                        this.t$1 = throwable;
                    }
                }));
                object = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), new scala.Serializable(this, partitionsWithError$1){
                    public static final long serialVersionUID;
                    private final AbstractFetcherThread $outer;
                    private final HashSet partitionsWithError$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.partitionsWithError$1.$plus$plus$eq(this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().keys());
                        return this.$outer.kafka$server$AbstractFetcherThread$$partitionMapCond().await(this.$outer.kafka$server$AbstractFetcherThread$$fetchBackOffMs, TimeUnit.MILLISECONDS);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.partitionsWithError$1 = hashSet;
                    }
                });
            } else {
                object = BoxedUnit.UNIT;
            }
            exceptionResult1 = object;
        }
        this.fetcherStats().requestRate().mark();
        BoxedUnit boxedUnit = (FetchResponse)response$1.elem == null ? BoxedUnit.UNIT : CoreUtils$.MODULE$.inLock(this.partitionMapLock(), new scala.Serializable(this, fetchRequest$2, partitionsWithError$1, response$1){
            public static final long serialVersionUID;
            private final AbstractFetcherThread $outer;
            public final FetchRequest fetchRequest$2;
            public final HashSet partitionsWithError$1;
            private final ObjectRef response$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((FetchResponse)this.response$1.elem).data().foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$processFetchRequest$2 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2) {
                        Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple22 = tuple2;
                        if (tuple22 != null) {
                            TopicAndPartition topicAndPartition = tuple22._1();
                            FetchResponsePartitionData fetchResponsePartitionData = tuple22._2();
                            TopicAndPartition topicAndPartition$1 = topicAndPartition;
                            FetchResponsePartitionData partitionData$1 = fetchResponsePartitionData;
                            Tuple2<String, Object> tuple23 = topicAndPartition$1.asTuple();
                            if (tuple23 != null) {
                                Tuple2<String, Object> tuple24 = new Tuple2<String, Object>(tuple23._1(), tuple23._2());
                                String topic$2 = tuple24._1();
                                int partitionId$2 = tuple24._2$mcI$sp();
                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$partitionMap().get(topicAndPartition$1).foreach(new scala.Serializable(this, topicAndPartition$1, partitionData$1, topic$2, partitionId$2){
                                    public static final long serialVersionUID;
                                    private final $anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1 $outer;
                                    private final TopicAndPartition topicAndPartition$1;
                                    public final FetchResponsePartitionData partitionData$1;
                                    public final String topic$2;
                                    public final int partitionId$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    /*
                                     * Loose catch block
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object apply(PartitionFetchState currentPartitionFetchState$1) {
                                        void var3_3;
                                        Object object;
                                        Object exceptionResult4;
                                        BoxedUnit exceptionResult3;
                                        if (((PartitionFetchInfo)this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().fetchRequest$2.requestInfo().apply(this.topicAndPartition$1)).offset() == currentPartitionFetchState$1.offset()) {
                                            short s = this.partitionData$1.error();
                                            if (BoxesRunTime.equals(BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.NoError()), BoxesRunTime.boxToShort(s))) {
                                                long l;
                                                exceptionResult3 = null;
                                                ByteBufferMessageSet messages = (ByteBufferMessageSet)this.partitionData$1.messages();
                                                int validBytes = messages.validBytes();
                                                Option<A> option = messages.shallowIterator().toSeq().lastOption();
                                                if (option instanceof Some) {
                                                    Some some = (Some)option;
                                                    MessageAndOffset messageAndOffset = (MessageAndOffset)some.x();
                                                    if (messageAndOffset == null) throw new MatchError(option);
                                                    l = messageAndOffset.nextOffset();
                                                } else {
                                                    None$ none$ = None$.MODULE$;
                                                    Option<A> option2 = option;
                                                    if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                                                    l = currentPartitionFetchState$1.offset();
                                                }
                                                long newOffset = l;
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$partitionMap().put(this.topicAndPartition$1, new PartitionFetchState(newOffset));
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().fetcherLagStats().getFetcherLagStats(this.topic$2, this.partitionId$2).lag_$eq(this.partitionData$1.hw() - newOffset);
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().fetcherStats().byteRate().mark(validBytes);
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().processPartitionData(this.topicAndPartition$1, currentPartitionFetchState$1.offset(), this.partitionData$1);
                                                exceptionResult3 = BoxedUnit.UNIT;
                                            }
                                            if (BoxesRunTime.equals(BoxesRunTime.boxToShort(ErrorMapping$.MODULE$.OffsetOutOfRangeCode()), BoxesRunTime.boxToShort(s))) {
                                                exceptionResult4 = null;
                                                long newOffset$1 = this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().handleOffsetOutOfRange(this.topicAndPartition$1);
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$partitionMap().put(this.topicAndPartition$1, new PartitionFetchState(newOffset$1));
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().error((Function0<String>)((Object)new scala.Serializable(this, currentPartitionFetchState$1, newOffset$1){
                                                    public static final long serialVersionUID;
                                                    private final $anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1$$anonfun$apply$3 $outer;
                                                    private final PartitionFetchState currentPartitionFetchState$1;
                                                    private final long newOffset$1;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final String apply() {
                                                        return Predef$.MODULE$.augmentString("Current offset %d for partition [%s,%d] out of range; reset offset to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.currentPartitionFetchState$1.offset()), this.$outer.topic$2, BoxesRunTime.boxToInteger(this.$outer.partitionId$2), BoxesRunTime.boxToLong(this.newOffset$1)}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.currentPartitionFetchState$1 = partitionFetchState;
                                                        this.newOffset$1 = l;
                                                    }
                                                }));
                                                exceptionResult4 = BoxedUnit.UNIT;
                                            }
                                            if (this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().isRunning().get()) {
                                                this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().error((Function0<String>)((Object)new scala.Serializable(this){
                                                    public static final long serialVersionUID;
                                                    private final $anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1$$anonfun$apply$3 $outer;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final String apply() {
                                                        return Predef$.MODULE$.augmentString("Error for partition [%s,%d] to broker %d:%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger(this.$outer.partitionId$2), BoxesRunTime.boxToInteger(this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$sourceBroker.id()), ErrorMapping$.MODULE$.exceptionFor(this.$outer.partitionData$1.error()).getClass()}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                }));
                                                object = this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().partitionsWithError$1.$plus$eq(this.topicAndPartition$1);
                                                return object;
                                            } else {
                                                object = BoxedUnit.UNIT;
                                            }
                                            return object;
                                        }
                                        object = BoxedUnit.UNIT;
                                        return object;
                                        catch (Throwable throwable) {
                                            throw new KafkaException(Predef$.MODULE$.augmentString("error processing data for partition [%s,%d] offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$2, BoxesRunTime.boxToInteger(this.partitionId$2), BoxesRunTime.boxToLong(currentPartitionFetchState$1.offset())})), throwable);
                                        }
                                        catch (InvalidMessageException invalidMessageException) {
                                            this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().logger().error(new StringBuilder().append((Object)"Found invalid messages during fetch for partition [").append((Object)this.topic$2).append((Object)",").append(BoxesRunTime.boxToInteger(this.partitionId$2)).append((Object)"] offset ").append(BoxesRunTime.boxToLong(currentPartitionFetchState$1.offset())).append((Object)" error ").append((Object)invalidMessageException.getMessage()).toString());
                                            exceptionResult3 = BoxedUnit.UNIT;
                                        }
                                        object = var3_3;
                                        return object;
                                        catch (Throwable throwable) {
                                            this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().error((Function0<String>)((Object)new scala.Serializable(this){
                                                public static final long serialVersionUID;
                                                private final $anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1$$anonfun$apply$3 $outer;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("Error getting offset for partition [%s,%d] to broker %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger(this.$outer.partitionId$2), BoxesRunTime.boxToInteger(this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$sourceBroker.id())}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                                                public static final long serialVersionUID;
                                                private final Throwable e$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final Throwable apply() {
                                                    return this.e$1;
                                                }
                                                {
                                                    this.e$1 = throwable;
                                                }
                                            }));
                                            exceptionResult4 = this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer().partitionsWithError$1.$plus$eq(this.topicAndPartition$1);
                                        }
                                        object = exceptionResult4;
                                        return object;
                                    }

                                    public $anonfun$processFetchRequest$2$$anonfun$apply$mcV$sp$1 kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition;
                                        this.partitionData$1 = fetchResponsePartitionData;
                                        this.topic$2 = string2;
                                        this.partitionId$2 = n;
                                    }
                                });
                                return;
                            }
                            throw new MatchError(tuple23);
                        }
                        throw new MatchError(tuple22);
                    }

                    public $anonfun$processFetchRequest$2 kafka$server$AbstractFetcherThread$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public AbstractFetcherThread kafka$server$AbstractFetcherThread$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetchRequest$2 = fetchRequest;
                this.partitionsWithError$1 = hashSet;
                this.response$1 = objectRef;
            }
        });
        if (partitionsWithError$1.size() > 0) {
            this.debug((Function0<String>)((Object)new scala.Serializable(this, partitionsWithError$1){
                public static final long serialVersionUID;
                private final HashSet partitionsWithError$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("handling partitions with error for %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionsWithError$1}));
                }
                {
                    this.partitionsWithError$1 = hashSet;
                }
            }));
            this.handlePartitionsWithErrors(partitionsWithError$1);
        }
    }

    public void addPartitions(Map<TopicAndPartition, Object> partitionAndOffsets) {
        this.partitionMapLock().lockInterruptibly();
        try {
            ((IterableLike)partitionAndOffsets.filter((Function1<TopicAndPartition, Object>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<TopicAndPartition, Object> tuple2) {
                    Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                    return tuple22 != null;
                }
            }))).foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(Tuple2<TopicAndPartition, Object> tuple2) {
                    Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                    if (tuple22 != null) {
                        TopicAndPartition topicAndPartition = tuple22._1();
                        long l = BoxesRunTime.unboxToLong(tuple22._2());
                        TopicAndPartition topicAndPartition2 = topicAndPartition;
                        long offset = l;
                        return this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().contains(topicAndPartition2) ? BoxedUnit.UNIT : this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().put(topicAndPartition2, PartitionTopicInfo$.MODULE$.isOffsetInvalid(offset) ? new PartitionFetchState(this.$outer.handleOffsetOutOfRange(topicAndPartition2)) : new PartitionFetchState(offset));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$server$AbstractFetcherThread$$partitionMapCond().signalAll();
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void delayPartitions(Iterable<TopicAndPartition> partitions, long delay$2) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach(new scala.Serializable(this, delay$2){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;
                public final long delay$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(TopicAndPartition partition$1) {
                    this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().get(partition$1).foreach(new scala.Serializable(this, partition$1){
                        public static final long serialVersionUID;
                        private final $anonfun$delayPartitions$1 $outer;
                        private final TopicAndPartition partition$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Object apply(PartitionFetchState currentPartitionFetchState) {
                            return currentPartitionFetchState.isActive() ? this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$partitionMap().put(this.partition$1, new PartitionFetchState(currentPartitionFetchState.offset(), new DelayedItem(this.$outer.delay$2))) : BoxedUnit.UNIT;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.partition$1 = topicAndPartition;
                        }
                    });
                }

                public AbstractFetcherThread kafka$server$AbstractFetcherThread$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.delay$2 = l;
                }
            });
            this.kafka$server$AbstractFetcherThread$$partitionMapCond().signalAll();
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicAndPartition> topicAndPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicAndPartitions.foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Option<PartitionFetchState> apply(TopicAndPartition tp) {
                    return this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().remove(tp);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        this.partitionMapLock().lockInterruptibly();
        int exceptionResult2 = 0;
        try {
            exceptionResult2 = this.kafka$server$AbstractFetcherThread$$partitionMap().size();
            return exceptionResult2;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, int socketTimeout, int socketBufferSize, int fetchSize, int fetcherBrokerId, int maxWait, int minBytes, int fetchBackOffMs, boolean isInterruptible, SecurityProtocol protocol) {
        this.kafka$server$AbstractFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$AbstractFetcherThread$$fetchSize = fetchSize;
        this.kafka$server$AbstractFetcherThread$$fetchBackOffMs = fetchBackOffMs;
        super(name, isInterruptible);
        this.kafka$server$AbstractFetcherThread$$partitionMap = new HashMap();
        this.partitionMapLock = new ReentrantLock();
        this.kafka$server$AbstractFetcherThread$$partitionMapCond = this.partitionMapLock().newCondition();
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, clientId, protocol);
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(clientId).replicaId(fetcherBrokerId).maxWait(maxWait).minBytes(minBytes);
    }
}

