/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.FetchResponsePartitionData;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Replica;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u000f\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!aC*dC2\fwJ\u00196fGRD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\bI\u0016d\u0017-_'t!\tiQ#\u0003\u0002\u0017\u001d\t!Aj\u001c8h\u0011!A\u0002A!A!\u0002\u0013I\u0012!\u00044fi\u000eDW*\u001a;bI\u0006$\u0018\r\u0005\u0002\n5%\u00111D\u0001\u0002\u000e\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u0011u\u0001!\u0011!Q\u0001\ny\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\n?%\u0011\u0001E\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011iAE\n\u001d\n\u0005\u0015r!!\u0003$v]\u000e$\u0018n\u001c82!\u00119#\u0006\f\u001a\u000e\u0003!R!!\u000b\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002,Q\t\u0019Q*\u00199\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011AB2p[6|g.\u0003\u00022]\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011aA1qS&\u0011q\u0007\u000e\u0002\u001b\r\u0016$8\r\u001b*fgB|gn]3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0003\u001beJ!A\u000f\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000byz\u0004)\u0011\"\u0011\u0005%\u0001\u0001\"B\n<\u0001\u0004!\u0002\"\u0002\r<\u0001\u0004I\u0002\"B\u000f<\u0001\u0004q\u0002\"\u0002\u0012<\u0001\u0004\u0019\u0003\"\u0002#\u0001\t\u0003*\u0015a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012A\u0012\t\u0003\u001b\u001dK!\u0001\u0013\b\u0003\u000f\t{w\u000e\\3b]\")!\n\u0001C!\u0017\u0006aqN\\#ya&\u0014\u0018\r^5p]R\t\u0001\bC\u0003N\u0001\u0011\u00053*\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004")
public class DelayedFetch
extends DelayedOperation
implements ScalaObject {
    public final FetchMetadata kafka$server$DelayedFetch$$fetchMetadata;
    public final ReplicaManager kafka$server$DelayedFetch$$replicaManager;
    private final Function1<Map<TopicAndPartition, FetchResponsePartitionData>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            boolean exceptionResult1 = false;
            try {
                IntRef accumulatedSize$1 = new IntRef(0);
                this.kafka$server$DelayedFetch$$fetchMetadata.fetchPartitionStatus().foreach(new Serializable(this, accumulatedSize$1, object){
                    public static final long serialVersionUID;
                    private final DelayedFetch $outer;
                    private final IntRef accumulatedSize$1;
                    private final Object nonLocalReturnKey1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<TopicAndPartition, FetchPartitionStatus> tuple2) {
                        Tuple2<TopicAndPartition, FetchPartitionStatus> tuple22 = tuple2;
                        if (tuple22 == null) throw new MatchError(tuple22);
                        TopicAndPartition topicAndPartition = tuple22._1();
                        FetchPartitionStatus fetchPartitionStatus = tuple22._2();
                        TopicAndPartition topicAndPartition$1 = topicAndPartition;
                        FetchPartitionStatus fetchStatus = fetchPartitionStatus;
                        LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
                        try {
                            LogOffsetMetadata endOffset;
                            LogOffsetMetadata logOffsetMetadata = fetchOffset;
                            LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                            if (!(logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2))) return;
                            Replica replica = this.$outer.kafka$server$DelayedFetch$$replicaManager.getLeaderReplicaIfLocal(topicAndPartition$1.topic(), topicAndPartition$1.partition());
                            LogOffsetMetadata logOffsetMetadata3 = endOffset = this.$outer.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyCommitted() ? replica.highWatermark() : replica.logEndOffset();
                            if (endOffset.offsetOnOlderSegment(fetchOffset)) {
                                this.$outer.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition$1){
                                    public static final long serialVersionUID;
                                    private final $anonfun$tryComplete$1 $outer;
                                    private final TopicAndPartition topicAndPartition$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Satisfying fetch %s since it is fetching later segments of partition %s.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata, this.topicAndPartition$1}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition;
                                    }
                                }));
                                throw new NonLocalReturnControl<Boolean>(this.nonLocalReturnKey1$1, BoxesRunTime.boxToBoolean(this.$outer.forceComplete()));
                            }
                            if (fetchOffset.offsetOnOlderSegment(endOffset)) {
                                this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final $anonfun$tryComplete$1 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Satisfying fetch %s immediately since it is fetching older segments.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }));
                                throw new NonLocalReturnControl<Boolean>(this.nonLocalReturnKey1$1, BoxesRunTime.boxToBoolean(this.$outer.forceComplete()));
                            }
                            if (!fetchOffset.precedes(endOffset)) return;
                            this.accumulatedSize$1.elem += package$.MODULE$.min(endOffset.positionDiff(fetchOffset), fetchStatus.fetchInfo().fetchSize());
                            return;
                        }
                        catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                            this.$outer.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition$1){
                                public static final long serialVersionUID;
                                private final $anonfun$tryComplete$1 $outer;
                                private final TopicAndPartition topicAndPartition$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker is no longer the leader of %s, satisfy %s immediately").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topicAndPartition$1 = topicAndPartition;
                                }
                            }));
                            throw new NonLocalReturnControl<Boolean>(this.nonLocalReturnKey1$1, BoxesRunTime.boxToBoolean(this.$outer.forceComplete()));
                        }
                        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                            this.$outer.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition$1){
                                public static final long serialVersionUID;
                                private final $anonfun$tryComplete$1 $outer;
                                private final TopicAndPartition topicAndPartition$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker no longer know of %s, satisfy %s immediately").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().kafka$server$DelayedFetch$$fetchMetadata}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topicAndPartition$1 = topicAndPartition;
                                }
                            }));
                            throw new NonLocalReturnControl<Boolean>(this.nonLocalReturnKey1$1, BoxesRunTime.boxToBoolean(this.$outer.forceComplete()));
                        }
                    }

                    public DelayedFetch kafka$server$DelayedFetch$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.accumulatedSize$1 = intRef;
                        this.nonLocalReturnKey1$1 = object;
                    }
                });
                exceptionResult1 = accumulatedSize$1.elem >= this.kafka$server$DelayedFetch$$fetchMetadata.fetchMinBytes() ? this.forceComplete() : false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                exceptionResult1 = BoxesRunTime.unboxToBoolean(nonLocalReturnControl2.value());
            }
            return exceptionResult1;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void onExpiration() {
        if (this.kafka$server$DelayedFetch$$fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
        } else {
            DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
        }
    }

    @Override
    public void onComplete() {
        Map<TopicAndPartition, LogReadResult> logReadResults = this.kafka$server$DelayedFetch$$replicaManager.readFromLocalLog(this.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyLeader(), this.kafka$server$DelayedFetch$$fetchMetadata.fetchOnlyCommitted(), this.kafka$server$DelayedFetch$$fetchMetadata.fetchPartitionStatus().mapValues(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final PartitionFetchInfo apply(FetchPartitionStatus status) {
                return status.fetchInfo();
            }
        }));
        Map fetchPartitionData = logReadResults.mapValues(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FetchResponsePartitionData apply(LogReadResult result2) {
                return new FetchResponsePartitionData(result2.errorCode(), result2.hw(), result2.info().messageSet());
            }
        });
        this.responseCallback.apply(fetchPartitionData);
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, Function1<Map<TopicAndPartition, FetchResponsePartitionData>, BoxedUnit> responseCallback) {
        this.kafka$server$DelayedFetch$$fetchMetadata = fetchMetadata;
        this.kafka$server$DelayedFetch$$replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs);
    }
}

