/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.TopicAndPartition;
import kafka.server.GroupTopicPartition;
import kafka.server.MessageValueStructAndVersion;
import kafka.server.OffsetManager;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetManager$
implements ScalaObject {
    public static final OffsetManager$ MODULE$;
    private final String OffsetsTopicName;
    private final short CURRENT_OFFSET_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA_V0;
    private final Field KEY_GROUP_FIELD;
    private final Field KEY_TOPIC_FIELD;
    private final Field KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private final Field VALUE_OFFSET_FIELD_V0;
    private final Field VALUE_METADATA_FIELD_V0;
    private final Field VALUE_TIMESTAMP_FIELD_V0;
    private final Field VALUE_OFFSET_FIELD_V1;
    private final Field VALUE_METADATA_FIELD_V1;
    private final Field VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private final Field VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private final Map<Object, OffsetManager.KeyAndValueSchemas> OFFSET_SCHEMAS;
    private final OffsetManager.KeyAndValueSchemas CURRENT_SCHEMA;

    static {
        new OffsetManager$();
    }

    public String OffsetsTopicName() {
        return this.OffsetsTopicName;
    }

    private short CURRENT_OFFSET_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA_V0() {
        return this.OFFSET_COMMIT_KEY_SCHEMA_V0;
    }

    private Field KEY_GROUP_FIELD() {
        return this.KEY_GROUP_FIELD;
    }

    private Field KEY_TOPIC_FIELD() {
        return this.KEY_TOPIC_FIELD;
    }

    private Field KEY_PARTITION_FIELD() {
        return this.KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private Field VALUE_OFFSET_FIELD_V0() {
        return this.VALUE_OFFSET_FIELD_V0;
    }

    private Field VALUE_METADATA_FIELD_V0() {
        return this.VALUE_METADATA_FIELD_V0;
    }

    private Field VALUE_TIMESTAMP_FIELD_V0() {
        return this.VALUE_TIMESTAMP_FIELD_V0;
    }

    private Field VALUE_OFFSET_FIELD_V1() {
        return this.VALUE_OFFSET_FIELD_V1;
    }

    private Field VALUE_METADATA_FIELD_V1() {
        return this.VALUE_METADATA_FIELD_V1;
    }

    private Field VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return this.VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private Field VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return this.VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Map<Object, OffsetManager.KeyAndValueSchemas> OFFSET_SCHEMAS() {
        return this.OFFSET_SCHEMAS;
    }

    private OffsetManager.KeyAndValueSchemas CURRENT_SCHEMA() {
        return this.CURRENT_SCHEMA;
    }

    private OffsetManager.KeyAndValueSchemas schemaFor(int version) {
        Option schemaOpt = this.OFFSET_SCHEMAS().get(BoxesRunTime.boxToInteger(version));
        Option option = schemaOpt;
        if (option instanceof Some) {
            return (OffsetManager.KeyAndValueSchemas)((Some)option).x();
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unknown offset schema version ").append(BoxesRunTime.boxToInteger(version)).toString());
    }

    public final byte[] kafka$server$OffsetManager$$offsetCommitKey(String group, String topic, int partition2, short versionId) {
        Struct key = new Struct(this.CURRENT_SCHEMA().keySchema());
        key.set(this.KEY_GROUP_FIELD(), (Object)group);
        key.set(this.KEY_TOPIC_FIELD(), (Object)topic);
        key.set(this.KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger(partition2));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public final short kafka$server$OffsetManager$$offsetCommitKey$default$4() {
        return 0;
    }

    public final byte[] kafka$server$OffsetManager$$offsetCommitValue(OffsetAndMetadata offsetAndMetadata) {
        Struct value2 = new Struct(this.CURRENT_SCHEMA().valueSchema());
        value2.set(this.VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong(offsetAndMetadata.offset()));
        value2.set(this.VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
        value2.set(this.VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong(offsetAndMetadata.commitTimestamp()));
        value2.set(this.VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong(offsetAndMetadata.expireTimestamp()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_SCHEMA_VERSION());
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public final GroupTopicPartition kafka$server$OffsetManager$$readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = this.schemaFor(version).keySchema();
        Struct key = (Struct)keySchema.read(buffer);
        String group = (String)key.get(this.KEY_GROUP_FIELD());
        String topic = (String)key.get(this.KEY_TOPIC_FIELD());
        int partition2 = BoxesRunTime.unboxToInt(key.get(this.KEY_PARTITION_FIELD()));
        return new GroupTopicPartition(group, new TopicAndPartition(topic, partition2));
    }

    public final OffsetAndMetadata kafka$server$OffsetManager$$readMessageValue(ByteBuffer buffer) {
        block5: {
            OffsetAndMetadata offsetAndMetadata;
            block3: {
                MessageValueStructAndVersion structAndVersion;
                block4: {
                    block2: {
                        structAndVersion = this.kafka$server$OffsetManager$$readMessageValueStruct(buffer);
                        if (structAndVersion.value() != null) break block2;
                        offsetAndMetadata = null;
                        break block3;
                    }
                    if (structAndVersion.version() != 0) break block4;
                    long offset = BoxesRunTime.unboxToLong(structAndVersion.value().get(this.VALUE_OFFSET_FIELD_V0()));
                    String metadata = (String)structAndVersion.value().get(this.VALUE_METADATA_FIELD_V0());
                    long timestamp = BoxesRunTime.unboxToLong(structAndVersion.value().get(this.VALUE_TIMESTAMP_FIELD_V0()));
                    offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
                    break block3;
                }
                if (structAndVersion.version() != 1) break block5;
                long offset = BoxesRunTime.unboxToLong(structAndVersion.value().get(this.VALUE_OFFSET_FIELD_V1()));
                String metadata = (String)structAndVersion.value().get(this.VALUE_METADATA_FIELD_V1());
                long commitTimestamp = BoxesRunTime.unboxToLong(structAndVersion.value().get(this.VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
                long expireTimestamp = BoxesRunTime.unboxToLong(structAndVersion.value().get(this.VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
            }
            return offsetAndMetadata;
        }
        throw new IllegalStateException("Unknown offset message version");
    }

    public final MessageValueStructAndVersion kafka$server$OffsetManager$$readMessageValueStruct(ByteBuffer buffer) {
        MessageValueStructAndVersion messageValueStructAndVersion;
        if (buffer == null) {
            messageValueStructAndVersion = new MessageValueStructAndVersion(null, -1);
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaFor(version).valueSchema();
            Struct value2 = (Struct)valueSchema.read(buffer);
            messageValueStructAndVersion = new MessageValueStructAndVersion(value2, version);
        }
        return messageValueStructAndVersion;
    }

    private OffsetManager$() {
        MODULE$ = this;
        this.OffsetsTopicName = "__consumer_offsets";
        this.CURRENT_OFFSET_SCHEMA_VERSION = (short)1;
        this.OFFSET_COMMIT_KEY_SCHEMA_V0 = new Schema(new Field("group", Type.STRING), new Field("topic", Type.STRING), new Field("partition", Type.INT32));
        this.KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("group");
        this.KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("topic");
        this.KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("timestamp", Type.INT64));
        this.OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", ""), new Field("commit_timestamp", Type.INT64), new Field("expire_timestamp", Type.INT64));
        this.VALUE_OFFSET_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.VALUE_METADATA_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.VALUE_TIMESTAMP_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.VALUE_OFFSET_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        this.VALUE_METADATA_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        this.VALUE_COMMIT_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        this.VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        this.OFFSET_SCHEMAS = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(0)).$minus$greater(new OffsetManager.KeyAndValueSchemas(this.OFFSET_COMMIT_KEY_SCHEMA_V0(), this.OFFSET_COMMIT_VALUE_SCHEMA_V0())), Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(1)).$minus$greater(new OffsetManager.KeyAndValueSchemas(this.OFFSET_COMMIT_KEY_SCHEMA_V0(), this.OFFSET_COMMIT_VALUE_SCHEMA_V1()))}));
        this.CURRENT_SCHEMA = this.schemaFor(this.CURRENT_OFFSET_SCHEMA_VERSION());
    }
}

