/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig$;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.protocol.SecurityProtocol;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u000f\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u00111bU2bY\u0006|%M[3di\"I1\u0003\u0001B\u0001B\u0003%AcG\u0001\u0005]\u0006lW\r\u0005\u0002\u001619\u0011QBF\u0005\u0003/9\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011qCD\u0005\u0003'qI!!\b\u0010\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u0003?\u0011\tQ!\u001e;jYND\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K\u0011\tqa\u00197vgR,'/\u0003\u0002(I\tq!I]8lKJ,e\u000e\u001a)pS:$\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005%Y\u0013B\u0001\u0017\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u00119\u0002!\u0011!Q\u0001\n=\n!B]3qY&\u001c\u0017-T4s!\tI\u0001'\u0003\u00022\u0005\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u0011A\u0014x\u000e^8d_2\u0004\"!\u000e \u000e\u0003YR!aM\u001c\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u0006u)\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tydG\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\")\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"ba\u0011#F\r\u001eC\u0005CA\u0005\u0001\u0011\u0015\u0019\u0002\t1\u0001\u0015\u0011\u0015\t\u0003\t1\u0001#\u0011\u0015I\u0003\t1\u0001+\u0011\u0015q\u0003\t1\u00010\u0011\u0015\u0019\u0004\t1\u00015\u0011\u0015Q\u0005\u0001\"\u0001L\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCR!Aj\u0014,\\!\tiQ*\u0003\u0002O\u001d\t!QK\\5u\u0011\u0015\u0001\u0016\n1\u0001R\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003%Rk\u0011a\u0015\u0006\u0003q\u0011I!!V*\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0003X\u0013\u0002\u0007\u0001,A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bCA\u0007Z\u0013\tQfB\u0001\u0003M_:<\u0007\"\u0002/J\u0001\u0004i\u0016!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0002_C6\tqL\u0003\u0002a\t\u0005\u0019\u0011\r]5\n\u0005\t|&A\u0007$fi\u000eD'+Z:q_:\u001cX\rU1si&$\u0018n\u001c8ECR\f\u0007\"\u00023\u0001\t\u0003)\u0017A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\u0005a3\u0007\"\u0002)d\u0001\u0004\t\u0006\"\u00025\u0001\t\u0003I\u0017A\u00075b]\u0012dW\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J\u001cHC\u0001'k\u0011\u0015Yw\r1\u0001m\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004[V\ffB\u00018t\u001d\ty'/D\u0001q\u0015\t\th!\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011AOD\u0001\ba\u0006\u001c7.Y4f\u0013\t1xO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t!h\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread
implements ScalaObject {
    public final BrokerEndPoint kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition$1, long fetchOffset, FetchResponsePartitionData partitionData$1) {
        try {
            String topic$1 = topicAndPartition$1.topic();
            int partitionId$1 = topicAndPartition$1.partition();
            Replica replica$1 = this.replicaMgr.getReplica(topic$1, partitionId$1, this.replicaMgr.getReplica$default$3()).get();
            ByteBufferMessageSet messageSet$1 = (ByteBufferMessageSet)partitionData$1.messages();
            if (fetchOffset != replica$1.logEndOffset().messageOffset()) {
                throw new RuntimeException(Predef$.MODULE$.augmentString("Offset mismatch: fetched offset = %d, log end offset = %d.").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(replica$1.logEndOffset().messageOffset())})));
            }
            this.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition$1, partitionData$1, replica$1, messageSet$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$1;
                private final FetchResponsePartitionData partitionData$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), this.topicAndPartition$1, BoxesRunTime.boxToInteger(this.messageSet$1.sizeInBytes()), BoxesRunTime.boxToLong(this.partitionData$1.hw())}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition;
                    this.partitionData$1 = fetchResponsePartitionData;
                    this.replica$1 = replica;
                    this.messageSet$1 = byteBufferMessageSet;
                }
            }));
            replica$1.log().get().append(messageSet$1, false);
            this.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition$1, replica$1, messageSet$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$1;
                private final Replica replica$1;
                private final ByteBufferMessageSet messageSet$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.messageSet$1.sizeInBytes()), this.topicAndPartition$1}));
                }
                {
                    this.topicAndPartition$1 = topicAndPartition;
                    this.replica$1 = replica;
                    this.messageSet$1 = byteBufferMessageSet;
                }
            }));
            long followerHighWatermark$1 = BoxesRunTime.unboxToLong(Predef$.MODULE$.longWrapper(replica$1.logEndOffset().messageOffset()).min(BoxesRunTime.boxToLong(partitionData$1.hw())));
            replica$1.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark$1, LogOffsetMetadata$.MODULE$.init$default$2(), LogOffsetMetadata$.MODULE$.init$default$3()));
            this.trace((Function0<String>)((Object)new Serializable(this, topic$1, partitionId$1, replica$1, followerHighWatermark$1){
                public static final long serialVersionUID;
                private final String topic$1;
                private final int partitionId$1;
                private final Replica replica$1;
                private final long followerHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Follower %d set replica high watermark for partition [%s,%d] to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1), BoxesRunTime.boxToLong(this.followerHighWatermark$1)}));
                }
                {
                    this.topic$1 = string2;
                    this.partitionId$1 = n;
                    this.replica$1 = replica;
                    this.followerHighWatermark$1 = l;
                }
            }));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Disk error while replicating data.";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID;
                private final KafkaStorageException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = kafkaStorageException;
                }
            }));
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition$2) {
        long l;
        Replica replica$2 = this.replicaMgr.getReplica(topicAndPartition$2.topic(), topicAndPartition$2.partition(), this.replicaMgr.getReplica$default$3()).get();
        long leaderEndOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.LatestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset$1 < replica$2.logEndOffset().messageOffset()) {
            if (!LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.toProps(), AdminUtils$.MODULE$.fetchTopicConfig(this.replicaMgr.zkClient(), topicAndPartition$2.topic())).uncleanLeaderElectionEnable()) {
                this.fatal((Function0<String>)((Object)new Serializable(this, topicAndPartition$2, replica$2, leaderEndOffset$1){
                    public static final long serialVersionUID;
                    private final ReplicaFetcherThread $outer;
                    private final TopicAndPartition topicAndPartition$2;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Halting because log truncation is not allowed for topic %s,").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$2.topic()}))).append((Object)Predef$.MODULE$.augmentString(" Current leader %d's latest offset %d is less than replica %d's latest offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderEndOffset$1), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topicAndPartition$2 = topicAndPartition;
                        this.replica$2 = replica;
                        this.leaderEndOffset$1 = l;
                    }
                }));
                Runtime.getRuntime().halt(1);
            }
            this.replicaMgr.logManager().truncateTo((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition$2).$minus$greater(BoxesRunTime.boxToLong(leaderEndOffset$1))})));
            this.warn((Function0<String>)((Object)new Serializable(this, topicAndPartition$2, replica$2, leaderEndOffset$1){
                public static final long serialVersionUID;
                private final ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's latest offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderEndOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition;
                    this.replica$2 = replica;
                    this.leaderEndOffset$1 = l;
                }
            }));
            l = leaderEndOffset$1;
        } else {
            long leaderStartOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.EarliestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.replicaMgr.logManager().truncateFullyAndStartAt(topicAndPartition$2, leaderStartOffset$1);
            this.warn((Function0<String>)((Object)new Serializable(this, topicAndPartition$2, replica$2, leaderStartOffset$1){
                public static final long serialVersionUID;
                private final ReplicaFetcherThread $outer;
                private final TopicAndPartition topicAndPartition$2;
                private final Replica replica$2;
                private final long leaderStartOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's start offset %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicAndPartition$2, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderStartOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$2 = topicAndPartition;
                    this.replica$2 = replica;
                    this.leaderStartOffset$1 = l;
                }
            }));
            l = leaderStartOffset$1;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
        this.delayPartitions(partitions, this.kafka$server$ReplicaFetcherThread$$brokerConfig.replicaFetchBackoffMs());
    }

    public ReplicaFetcherThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, SecurityProtocol protocol) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        super(name, name, sourceBroker, brokerConfig.replicaSocketTimeoutMs(), brokerConfig.replicaSocketReceiveBufferBytes(), brokerConfig.replicaFetchMaxBytes(), brokerConfig.brokerId(), brokerConfig.replicaFetchWaitMaxMs(), brokerConfig.replicaFetchMinBytes(), brokerConfig.replicaFetchBackoffMs(), false, protocol);
    }
}

