/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Crc32;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CoreUtils$
implements Logging {
    public static final CoreUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new CoreUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        CoreUtils$ coreUtils$ = this;
        synchronized (coreUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Runnable runnable(Function0<BoxedUnit> fun$1) {
        return new Runnable(fun$1){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = function0;
            }
        };
    }

    public Thread daemonThread(String name, Function0<BoxedUnit> fun$2) {
        return Utils.daemonThread(name, this.runnable((Function0<BoxedUnit>)((Object)new Serializable(fun$2){
            public static final long serialVersionUID;
            private final Function0 fun$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
            {
                this.fun$2 = function0;
            }
        })));
    }

    public FileChannel openChannel(File file, boolean mutable) {
        return mutable ? new RandomAccessFile(file, "rw").getChannel() : new FileInputStream(file).getChannel();
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log2, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log2.apply(throwable.getMessage(), throwable);
        }
    }

    public void rm(String file) {
        this.rm(new File(file));
    }

    public void rm(Seq<String> files) {
        files.foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String f) {
                CoreUtils$.MODULE$.rm(new File(f));
            }
        });
    }

    public void rm(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Predef$.MODULE$.refArrayOps((Object[])files).foreach(new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(File f) {
                        CoreUtils$.MODULE$.rm(f);
                    }
                });
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name$1) {
        void var3_3;
        boolean exceptionResult1 = false;
        try {
            Boolean bl;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name$1);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl = BoxesRunTime.boxToBoolean(true);
            }
            exceptionResult1 = BoxesRunTime.unboxToBoolean(bl);
            return (boolean)var3_3;
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new Serializable(name$1){
                public static final long serialVersionUID;
                private final String name$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = string2;
                }
            }), (Function0<Throwable>)((Object)new Serializable(exception){
                public static final long serialVersionUID;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = exception;
                }
            }));
            return (boolean)var3_3;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        if (n == -1) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        if (BoxesRunTime.boxToInteger(n) instanceof Integer) {
            return n;
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public Map<String, String> parseCsvMap(String str) {
        scala.collection.mutable.HashMap<String, String> map2 = new scala.collection.mutable.HashMap<String, String>();
        if ("".equals(str)) {
            return map2;
        }
        Tuple2[] keyVals = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, String> apply(String s) {
                int lio = s.lastIndexOf(":");
                return Predef$Pair$.MODULE$.apply(s.substring(0, lio).trim(), s.substring(lio + 1).trim());
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, ClassManifest$.MODULE$.classType(String.class), Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(String.class)}))));
        return Predef$.MODULE$.refArrayOps((Object[])keyVals).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (WrappedArray<Object>)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className);
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Class<?> apply(Object object) {
                return object.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(Class.class, NoManifest$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))));
        return (T)constructor.newInstance((Object[])args.toArray(Manifest$.MODULE$.Object()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll$1) {
        Stream stream = package$.MODULE$.Stream().continually(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap(new Serializable(coll$1){
            public static final long serialVersionUID;
            private final Iterable coll$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterable<T> apply(int forever) {
                return this.coll$1.map(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = iterable;
            }
        }, Stream$.MODULE$.canBuildFrom());
        return stream.iterator();
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (s.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s.substring(0, s.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'").format(Predef$.MODULE$.genericWrapArray(new Object[]{oldSuffix, s})));
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, String> evaluateDefaults(Properties props$1) {
        void var2_2;
        HashMap evaluated$1 = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(props$1.stringPropertyNames()).foreach(new Serializable(props$1, evaluated$1){
            public static final long serialVersionUID;
            private final Properties props$1;
            private final HashMap evaluated$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String name) {
                return this.evaluated$1.put(name, this.props$1.getProperty(name));
            }
            {
                this.props$1 = properties;
                this.evaluated$1 = hashMap;
            }
        });
        return var2_2;
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        T exceptionResult2 = null;
        try {
            exceptionResult2 = fun.apply();
            return exceptionResult2;
        }
        finally {
            lock2.unlock();
        }
    }

    public <T> T inReadLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.writeLock(), fun);
    }

    public String JSONEscapeString(String s) {
        return ((TraversableOnce)Predef$.MODULE$.augmentString(s).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(char c) {
                char c2;
                char c3 = c;
                return c3 == '\"' ? "\\\"" : (c3 == '\\' ? "\\\\" : (c3 == '/' ? "\\/" : (c3 == '\b' ? "\\b" : (c3 == '\f' ? "\\f" : (c3 == '\n' ? "\\n" : (c3 == '\r' ? "\\r" : (c3 == '\t' ? "\\t" : (this.gd1$1(c2 = c3) ? Predef$.MODULE$.augmentString("\\u%04x").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(c2)})) : BoxesRunTime.boxToCharacter(c3)))))))));
            }

            private final boolean gd1$1(char c) {
                return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f';
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final T apply(T t) {
                return Predef$.MODULE$.identity(t);
            }
        }).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<T, Object> apply(Tuple2<T, Traversable<T>> tuple2) {
                Tuple2<T, Traversable<T>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return new Tuple2<T, Integer>(tuple22._1(), BoxesRunTime.boxToInteger(((TraversableOnce)tuple22._2()).size()));
                }
                throw new MatchError(tuple22);
            }
        }, Map$.MODULE$.canBuildFrom())).filter(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<T, Object> tuple2) {
                Tuple2<T, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return BoxesRunTime.unboxToInt(tuple22._2()) > 1;
                }
                throw new MatchError(tuple22);
            }
        })).keys();
    }

    public scala.collection.immutable.Map<SecurityProtocol, EndPoint> listenerListToEndPoints(String listeners) {
        Seq<String> listenerList = this.parseCsvList(listeners);
        return ((TraversableOnce)((TraversableLike)listenerList.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final EndPoint apply(String listener) {
                return EndPoint$.MODULE$.createEndPoint(listener);
            }
        }, Seq$.MODULE$.canBuildFrom())).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<SecurityProtocol, EndPoint> apply(EndPoint ep) {
                return Predef$.MODULE$.any2ArrowAssoc(ep.protocolType()).$minus$greater(ep);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    private CoreUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

