/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.CoreUtils$;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Scheduler;
import kafka.utils.Scheduler$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001\u001d\u0011abS1gW\u0006\u001c6\r[3ek2,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001A\u0001\u0003F\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bCA\t\u0016\u0013\t1\"AA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u00059A\u000f\u001b:fC\u0012\u001cX#\u0001\u0011\u0011\u0005a\t\u0013B\u0001\u0012\u001a\u0005\rIe\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005A\u0005AA\u000f\u001b:fC\u0012\u001c\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001)!\tICF\u0004\u0002\u0019U%\u00111&G\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,3!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0002B\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0007I\u0006,Wn\u001c8\u0011\u0005a!\u0014BA\u001b\u001a\u0005\u001d\u0011un\u001c7fC:DQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d;wq\u0002\"!\u0005\u0001\t\u000by1\u0004\u0019\u0001\u0011\t\u000f\u00192\u0004\u0013!a\u0001Q!9!G\u000eI\u0001\u0002\u0004\u0019\u0004b\u0002 \u0001\u0001\u0004%IaP\u0001\tKb,7-\u001e;peV\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0015c\u0011\u0001B;uS2L!a\u0012\"\u00037M\u001b\u0007.\u001a3vY\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011\u001dI\u0005\u00011A\u0005\n)\u000bA\"\u001a=fGV$xN]0%KF$\"a\u0013(\u0011\u0005aa\u0015BA'\u001a\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003A\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0002+\u0002#M\u001c\u0007.\u001a3vY\u0016\u0014H\u000b\u001b:fC\u0012LE-F\u0001V!\t1\u0016,D\u0001X\u0015\tA&)\u0001\u0004bi>l\u0017nY\u0005\u00035^\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bB\u0002/\u0001A\u0003%Q+\u0001\ntG\",G-\u001e7feRC'/Z1e\u0013\u0012\u0004\u0003\"\u00020\u0001\t\u0003z\u0016aB:uCJ$X\u000f\u001d\u000b\u0002\u0017\")\u0011\r\u0001C!?\u0006A1\u000f[;uI><h\u000eC\u0003d\u0001\u0011\u0005A-\u0001\u0005tG\",G-\u001e7f)\u0019YUm\u001a7rg\")aM\u0019a\u0001Q\u0005!a.Y7f\u0011\u0015A'\r1\u0001j\u0003\r1WO\u001c\t\u00041)\\\u0015BA6\u001a\u0005%1UO\\2uS>t\u0007\u0007C\u0004nEB\u0005\t\u0019\u00018\u0002\u000b\u0011,G.Y=\u0011\u0005ay\u0017B\u00019\u001a\u0005\u0011auN\\4\t\u000fI\u0014\u0007\u0013!a\u0001]\u00061\u0001/\u001a:j_\u0012Dq\u0001\u001e2\u0011\u0002\u0003\u0007Q/\u0001\u0003v]&$\bCA!w\u0013\t9(I\u0001\u0005US6,WK\\5u\u0011\u0015I\b\u0001\"\u0001{\u0003%I7o\u0015;beR,G-F\u00014\u0011\u0015a\b\u0001\"\u0003~\u00035)gn];sKN#\u0018M\u001d;fIV\t1\n\u000b\u0002\u0001\u007fB\u0019\u0011#!\u0001\n\u0007\u0005\r!A\u0001\u0006uQJ,\u0017\rZ:bM\u0016<\u0011\"a\u0002\u0003\u0003\u0003E)!!\u0003\u0002\u001d-\u000bgm[1TG\",G-\u001e7feB\u0019\u0011#a\u0003\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0003\u001b\u0019B!a\u0003\t/!9q'a\u0003\u0005\u0002\u0005EACAA\u0005\u0011)\t)\"a\u0003\u0012\u0002\u0013\u0005\u0011qC\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIBK\u0002)\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003OI\u0012AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003_\tY!%A\u0005\u0002\u0005E\u0012AD5oSR$C-\u001a4bk2$HeM\u000b\u0003\u0003gQ3aMA\u000e\u0001")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    public final boolean kafka$utils$KafkaScheduler$$daemon;
    private ScheduledThreadPoolExecutor executor;
    private final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final boolean init$default$3() {
        return KafkaScheduler$.MODULE$.init$default$3();
    }

    public static final String init$default$2() {
        return KafkaScheduler$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler$class.schedule$default$3(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler$class.schedule$default$4(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler$class.schedule$default$5(this);
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.executor = scheduledThreadPoolExecutor;
    }

    public final AtomicInteger kafka$utils$KafkaScheduler$$schedulerThreadId() {
        return this.kafka$utils$KafkaScheduler$$schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Initializing task scheduler.";
            }
        }));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setThreadFactory(new ThreadFactory(this){
                private final KafkaScheduler $outer;

                public Thread newThread(Runnable runnable) {
                    return Utils.newThread(new StringBuilder().append((Object)this.$outer.threadNamePrefix()).append(BoxesRunTime.boxToInteger(this.$outer.kafka$utils$KafkaScheduler$$schedulerThreadId().getAndIncrement())).toString(), runnable, Predef$.MODULE$.boolean2Boolean(this.$outer.kafka$utils$KafkaScheduler$$daemon));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    @Override
    public void shutdown() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down task scheduler.";
            }
        }));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            BoxedUnit boxedUnit;
            if (this.isStarted()) {
                this.executor().shutdown();
                this.executor().awaitTermination(1L, TimeUnit.DAYS);
                this.executor_$eq(null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public void schedule(String name$1, Function0<BoxedUnit> fun$1, long delay$1, long period$1, TimeUnit unit$1) {
        this.debug((Function0<String>)((Object)new Serializable(this, name$1, delay$1, period$1, unit$1){
            public static final long serialVersionUID;
            private final String name$1;
            private final long delay$1;
            private final long period$1;
            private final TimeUnit unit$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Scheduling task %s with initial delay %d ms and period %d ms.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.name$1, BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(this.delay$1, this.unit$1)), BoxesRunTime.boxToLong(TimeUnit.MILLISECONDS.convert(this.period$1, this.unit$1))}));
            }
            {
                this.name$1 = string2;
                this.delay$1 = l;
                this.period$1 = l2;
                this.unit$1 = timeUnit;
            }
        }));
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            this.ensureStarted();
            Runnable runnable = CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)((Object)new Serializable(this, name$1, fun$1){
                public static final long serialVersionUID;
                private final KafkaScheduler $outer;
                public final String name$1;
                private final Function0 fun$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void apply$mcV$sp() {
                    try {
                        this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Begining execution of scheduled task '%s'.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                        this.fun$1.apply$mcV$sp();
                        this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Completed execution of scheduled task '%s'.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.name$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                        return;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.$outer.error((Function0<String>)((Object)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Uncaught exception in scheduled task '").append((Object)this.$outer.name$1).append((Object)"'").toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable t$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.t$1;
                                }
                                {
                                    this.t$1 = throwable;
                                }
                            }));
                            this.$outer.trace((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                            return;
                        }
                        catch (Throwable throwable2) {
                            this.$outer.trace((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                            throw throwable2;
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.name$1 = string2;
                    this.fun$1 = function0;
                }
            }));
            ScheduledFuture<?> scheduledFuture = period$1 >= 0L ? this.executor().scheduleAtFixedRate(runnable, delay$1, period$1, unit$1) : this.executor().schedule(runnable, delay$1, unit$1);
            return;
        }
    }

    @Override
    public boolean isStarted() {
        KafkaScheduler kafkaScheduler = this;
        synchronized (kafkaScheduler) {
            Boolean bl = BoxesRunTime.boxToBoolean(this.executor() != null);
            return BoxesRunTime.unboxToBoolean(bl);
        }
    }

    private void ensureStarted() {
        if (this.isStarted()) {
            return;
        }
        throw new IllegalStateException("Kafka scheduler has not been started");
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.kafka$utils$KafkaScheduler$$daemon = daemon;
        Scheduler$class.$init$(this);
        Logging$class.$init$(this);
        this.executor = null;
        this.kafka$utils$KafkaScheduler$$schedulerThreadId = new AtomicInteger(0);
    }
}

