/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.security.URIParameter;
import javax.security.auth.login.Configuration;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Cluster;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerThreadId;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.ReassignedPartitionsContext$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkPath$;
import kafka.utils.ZkUtils$;
import kafka.utils.ZkUtils$$anonfun$getConsumersPerTopic$1$;
import kafka.utils.ZkUtils$$anonfun$getReplicaAssignmentForTopics$1$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassManifest$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String TopicConfigPath;
    private final String TopicConfigChangesPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final boolean isSecure;
    private final List<ACL> DefaultAcls;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String TopicConfigPath() {
        return this.TopicConfigPath;
    }

    public String TopicConfigChangesPath() {
        return this.TopicConfigChangesPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public List<ACL> DefaultAcls() {
        return this.DefaultAcls;
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicConfigPath(String topic) {
        return new StringBuilder().append((Object)this.TopicConfigPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public int getController(ZkClient zkClient) {
        Option<String> option = this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            return KafkaController$.MODULE$.parseControllerId((String)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError(option);
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append(BoxesRunTime.boxToInteger(partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Object> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string2) {
                return Predef$.MODULE$.augmentString(string2).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient$5) {
        Seq brokerIds = (Seq)this.getChildrenParentMayNotExist(zkClient$5, this.BrokerIdsPath()).sorted(Ordering$String$.MODULE$);
        return ((TraversableLike)((TraversableLike)((TraversableLike)brokerIds.map(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string2) {
                return Predef$.MODULE$.augmentString(string2).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).map(new scala.Serializable(zkClient$5){
            public static final long serialVersionUID;
            private final ZkClient zkClient$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(int n) {
                return ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$5, n);
            }
            {
                this.zkClient$5 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Option<Broker> option) {
                return option.isDefined();
            }
        })).map(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Broker apply(Option<Broker> option) {
                return option.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<BrokerEndPoint> getAllBrokerEndPointsForChannel(ZkClient zkClient, SecurityProtocol protocolType$1) {
        return this.getAllBrokersInCluster(zkClient).map(new scala.Serializable(protocolType$1){
            public static final long serialVersionUID;
            private final SecurityProtocol protocolType$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final BrokerEndPoint apply(Broker broker) {
                return broker.getBrokerEndPoint(this.protocolType$1);
            }
            {
                this.protocolType$1 = securityProtocol;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String topic, int partition2) {
        return ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(zkClient, topic, partition2).map(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
                return leaderIsrAndControllerEpoch.leaderAndIsr();
            }
        });
    }

    public void setupCommonPaths(ZkClient zkClient$9) {
        ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerIdsPath(), this.BrokerTopicsPath(), this.TopicConfigChangesPath(), this.TopicConfigPath(), this.DeleteTopicsPath(), this.BrokerSequenceIdPath()}))).foreach(new scala.Serializable(zkClient$9){
            public static final long serialVersionUID;
            private final ZkClient zkClient$9;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String path) {
                ZkUtils$.MODULE$.makeSurePersistentPathExists(this.zkClient$9, path, ZkUtils$.MODULE$.makeSurePersistentPathExists$default$3());
                ZkUtils$.MODULE$.makeSureCorrectAclsAreSet(this.zkClient$9, path);
            }
            {
                this.zkClient$9 = zkClient;
            }
        });
    }

    public void makeSureCorrectAclsAreSet(ZkClient client$1, String path$7) {
        if (path$7 == null || path$7.isEmpty() || path$7.equals(this.ConsumersPath())) {
            return;
        }
        List acls = JavaConversions$.MODULE$.asScalaBuffer(client$1.getAcl(path$7).getKey()).toList();
        if (!this.DefaultAcls().equals(acls)) {
            client$1.setAcl(path$7, JavaConversions$.MODULE$.seqAsJavaList(this.DefaultAcls()));
        }
        this.getChildren(client$1, path$7).foreach(new scala.Serializable(client$1, path$7){
            public static final long serialVersionUID;
            private final ZkClient client$1;
            private final String path$7;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String child) {
                ZkUtils$.MODULE$.makeSureCorrectAclsAreSet(this.client$1, new StringBuilder().append((Object)this.path$7).append((Object)"/").append((Object)child).toString());
            }
            {
                this.client$1 = zkClient;
                this.path$7 = string2;
            }
        });
    }

    public Option<Object> getLeaderForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block6: {
            Option option2;
            block4: {
                block2: {
                    Option<Object> option3;
                    block5: {
                        block3: {
                            Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String leaderAndIsr = string2;
                            option3 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option3 instanceof Some)) break block3;
                            option2 = new Some<Integer>(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(((Map)((Some)option3).x()).get("leader").get())));
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option4 = option3;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                        option2 = None$.MODULE$;
                        break block4;
                    }
                    throw new MatchError(option3);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option5 = option;
                if (none$ != null ? !none$.equals(option5) : option5 != null) break block6;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getEpochForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
        Option<String> option = leaderAndIsrOpt;
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            String leaderAndIsr = string2 = (String)some.x();
            Option<Object> option2 = Json$.MODULE$.parseFull(leaderAndIsr);
            None$ none$ = None$.MODULE$;
            Option<Object> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
            }
            if (option2 instanceof Some) {
                return BoxesRunTime.unboxToInt(((Map)((Some)option2).x()).get("leader_epoch").get());
            }
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty").format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        }
        throw new MatchError(option);
    }

    public int getBrokerSequenceId(ZkClient zkClient, int MaxReservedBrokerId) {
        return this.getSequenceId(zkClient, this.BrokerSequenceIdPath(), this.getSequenceId$default$3()) + MaxReservedBrokerId;
    }

    public Seq<Object> getInSyncReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block6: {
            Seq seq;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String leaderAndIsr = string2;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            seq = (Seq)((Map)((Some)option2).x()).get("isr").get();
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Seq<Object> getReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block10: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block9: {
                        block3: {
                            Option option3;
                            block8: {
                                block4: {
                                    Option option4;
                                    block7: {
                                        block5: {
                                            Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.getTopicPath(topic))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string2 = (String)some.x();
                                            String jsonPartitionMap = string2;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object a = some2.x();
                                            Object m = a;
                                            option3 = ((Map)m).get("partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object a2 = some3.x();
                                            Object replicaMap = a2;
                                            option4 = ((Map)replicaMap).get(((Object)BoxesRunTime.boxToInteger(partition2)).toString());
                                            if (!(option4 instanceof Some)) break block5;
                                            seq = (Seq)((Some)option4).x();
                                            break block6;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option5 = option4;
                                        if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                        seq = (Seq)Seq$.MODULE$.empty();
                                        break block6;
                                    }
                                    throw new MatchError(option4);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option6 = option3;
                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                seq = (Seq)Seq$.MODULE$.empty();
                                break block6;
                            }
                            throw new MatchError(option3);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option7 = option2;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block9;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option8 = option;
                if (none$ != null ? !none$.equals(option8) : option8 != null) break block10;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public void registerBrokerInZk(ZkClient zkClient, int id$1, String host, int port, scala.collection.immutable.Map<SecurityProtocol, EndPoint> advertisedEndpoints$1, int timeout, int jmxPort) {
        String brokerIdPath$1 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(id$1)).toString();
        String timestamp = ((Object)BoxesRunTime.boxToLong(SystemTime$.MODULE$.milliseconds())).toString();
        String brokerInfo = Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(2)), Predef$.MODULE$.any2ArrowAssoc("host").$minus$greater(host), Predef$.MODULE$.any2ArrowAssoc("port").$minus$greater(BoxesRunTime.boxToInteger(port)), Predef$.MODULE$.any2ArrowAssoc("endpoints").$minus$greater(((TraversableOnce)advertisedEndpoints$1.values().map(new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(EndPoint endPoint) {
                return endPoint.connectionString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(String.class))), Predef$.MODULE$.any2ArrowAssoc("jmx_port").$minus$greater(BoxesRunTime.boxToInteger(jmxPort)), Predef$.MODULE$.any2ArrowAssoc("timestamp").$minus$greater(timestamp)})));
        Broker expectedBroker = new Broker(id$1, advertisedEndpoints$1);
        this.registerBrokerInZk(zkClient, brokerIdPath$1, brokerInfo, expectedBroker, timeout);
        this.info((Function0<String>)((Object)new scala.Serializable(id$1, advertisedEndpoints$1, brokerIdPath$1){
            public static final long serialVersionUID;
            private final int id$1;
            private final scala.collection.immutable.Map advertisedEndpoints$1;
            private final String brokerIdPath$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Registered broker %d at path %s with addresses: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.id$1), this.brokerIdPath$1, this.advertisedEndpoints$1.mkString(",")}));
            }
            {
                this.id$1 = n;
                this.advertisedEndpoints$1 = map2;
                this.brokerIdPath$1 = string2;
            }
        }));
    }

    private void registerBrokerInZk(ZkClient zkClient, String brokerIdPath, String brokerInfo, Broker expectedBroker, int timeout) {
        try {
            this.createEphemeralPathExpectConflictHandleZKBug(zkClient, brokerIdPath, brokerInfo, expectedBroker, (Function2<String, Object, Object>)((Object)new scala.Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String brokerString, Object broker) {
                    return Broker$.MODULE$.createBroker(((Broker)broker).id(), brokerString).equals((Broker)broker);
                }
            }), timeout);
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)brokerIdPath).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
    }

    public String getConsumerPartitionOwnerPath(String group, String topic, int partition2) {
        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topic);
        return new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append(BoxesRunTime.boxToInteger(partition2)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("leader").$minus$greater(BoxesRunTime.boxToInteger(leaderAndIsr.leader())), Predef$.MODULE$.any2ArrowAssoc("leader_epoch").$minus$greater(BoxesRunTime.boxToInteger(leaderAndIsr.leaderEpoch())), Predef$.MODULE$.any2ArrowAssoc("controller_epoch").$minus$greater(BoxesRunTime.boxToInteger(controllerEpoch)), Predef$.MODULE$.any2ArrowAssoc("isr").$minus$greater(leaderAndIsr.isr())})));
    }

    public String replicaAssignmentZkData(Map<String, Seq<Object>> map2) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("partitions").$minus$greater(map2)})));
    }

    public void makeSurePersistentPathExists(ZkClient client, String path, List<ACL> acls) {
        List<ACL> acl = acls;
        if (path == null || path.isEmpty() || path.equals(this.ConsumersPath())) {
            acl = JavaConversions$.MODULE$.asScalaBuffer(ZooDefs.Ids.OPEN_ACL_UNSAFE).toList();
        }
        if (!client.exists(path)) {
            ZkPath$.MODULE$.createPersistent(client, path, true, acl);
        }
    }

    public List makeSurePersistentPathExists$default$3() {
        return this.DefaultAcls();
    }

    private void createParentPath(ZkClient client, String path, List<ACL> acls) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            ZkPath$.MODULE$.createPersistent(client, parentDir, true, acls);
        }
    }

    private List createParentPath$default$3() {
        return this.DefaultAcls();
    }

    private void createEphemeralPath(ZkClient client, String path, String data, List<ACL> acls) {
        try {
            ZkPath$.MODULE$.createEphemeral(client, path, data, acls);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path, this.createParentPath$default$3());
            ZkPath$.MODULE$.createEphemeral(client, path, data, acls);
        }
    }

    private List createEphemeralPath$default$4() {
        return this.DefaultAcls();
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$4, String data$2) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$4, data$2, this.createEphemeralPath$default$4());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = this.readData(client, path$4)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string2 = (String)storedData$1.elem;
                String string3 = data$2;
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block6;
                this.info((Function0<String>)((Object)new scala.Serializable(path$4, data$2){
                    public static final long serialVersionUID;
                    private final String path$4;
                    private final String data$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)this.path$4).append((Object)" exists with value ").append((Object)this.data$2).append((Object)" during connection loss; this is ok").toString();
                    }
                    {
                        this.path$4 = string2;
                        this.data$2 = string3;
                    }
                }));
            }
            return;
        }
        this.info((Function0<String>)((Object)new scala.Serializable(path$4, data$2, storedData$1){
            public static final long serialVersionUID;
            private final String path$4;
            private final String data$2;
            private final ObjectRef storedData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"conflict in ").append((Object)this.path$4).append((Object)" data: ").append((Object)this.data$2).append((Object)" stored data: ").append((Object)((String)this.storedData$1.elem)).toString();
            }
            {
                this.path$4 = string2;
                this.data$2 = string3;
                this.storedData$1 = objectRef;
            }
        }));
        throw zkNodeExistsException2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createEphemeralPathExpectConflictHandleZKBug(ZkClient zkClient, String path$2, String data$1, Object expectedCallerData, Function2<String, Object, Object> checker, int backoffTime) {
        this.createEphemeralPathExpectConflict(zkClient, path$2, data$1);
        return;
    }

    public void createPersistentPath(ZkClient client, String path, String data, List<ACL> acls) {
        try {
            ZkPath$.MODULE$.createPersistent(client, path, data, acls);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path, this.createParentPath$default$3());
            ZkPath$.MODULE$.createPersistent(client, path, data, acls);
        }
    }

    public List createPersistentPath$default$4() {
        return this.DefaultAcls();
    }

    public String createPersistentPath$default$3() {
        return "";
    }

    public String createSequentialPersistentPath(ZkClient client, String path, String data, List<ACL> acls) {
        return ZkPath$.MODULE$.createPersistentSequential(client, path, data, acls);
    }

    public List createSequentialPersistentPath$default$4() {
        return this.DefaultAcls();
    }

    public String createSequentialPersistentPath$default$3() {
        return "";
    }

    public void updatePersistentPath(ZkClient client, String path, String data, List<ACL> acls) {
        try {
            client.writeData(path, data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path, this.createParentPath$default$3());
            try {
                ZkPath$.MODULE$.createPersistent(client, path, data, acls);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, data);
            }
        }
    }

    public List updatePersistentPath$default$4() {
        return this.DefaultAcls();
    }

    public Tuple2<Object, Object> conditionalUpdatePersistentPath(ZkClient client, String path$6, String data$4, int expectVersion$2, Option<Function3<ZkClient, String, String, Tuple2<Object, Object>>> optionalChecker) {
        Tuple2<Object, Object> exceptionResult1 = null;
        try {
            Stat stat$1 = client.writeDataReturnStat(path$6, data$4, expectVersion$2);
            this.debug((Function0<String>)((Object)new scala.Serializable(path$6, data$4, expectVersion$2, stat$1){
                public static final long serialVersionUID;
                private final String path$6;
                private final String data$4;
                private final int expectVersion$2;
                private final Stat stat$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$6, this.data$4, BoxesRunTime.boxToInteger(this.expectVersion$2), BoxesRunTime.boxToInteger(this.stat$1.getVersion())}));
                }
                {
                    this.path$6 = string2;
                    this.data$4 = string3;
                    this.expectVersion$2 = n;
                    this.stat$1 = stat;
                }
            }));
            exceptionResult1 = new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(stat$1.getVersion()));
        }
        catch (Exception exception) {
            this.warn((Function0<String>)((Object)new scala.Serializable(path$6, data$4, expectVersion$2, exception){
                public static final long serialVersionUID;
                private final String path$6;
                private final String data$4;
                private final int expectVersion$2;
                private final Exception e2$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$6, this.data$4, BoxesRunTime.boxToInteger(this.expectVersion$2), this.e2$1.getMessage()}));
                }
                {
                    this.path$6 = string2;
                    this.data$4 = string3;
                    this.expectVersion$2 = n;
                    this.e2$1 = exception;
                }
            }));
            exceptionResult1 = new Tuple2<Object, Object>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(-1));
        }
        catch (ZkBadVersionException zkBadVersionException) {
            Option<Function3<ZkClient, String, String, Tuple2<Object, Object>>> option = optionalChecker;
            if (option instanceof Some) {
                return (Tuple2)((Function3)((Some)option).x()).apply(client, path$6, data$4);
            }
            this.debug((Function0<String>)((Object)new scala.Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Checker method is not passed skipping zkData match";
                }
            }));
            this.warn((Function0<String>)((Object)new scala.Serializable(path$6, data$4, expectVersion$2, zkBadVersionException){
                public static final long serialVersionUID;
                private final String path$6;
                private final String data$4;
                private final int expectVersion$2;
                private final ZkBadVersionException e1$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$6, this.data$4, BoxesRunTime.boxToInteger(this.expectVersion$2), this.e1$1.getMessage()}));
                }
                {
                    this.path$6 = string2;
                    this.data$4 = string3;
                    this.expectVersion$2 = n;
                    this.e1$1 = zkBadVersionException;
                }
            }));
            exceptionResult1 = new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(-1));
        }
        return exceptionResult1;
    }

    public Option conditionalUpdatePersistentPath$default$5() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Object> conditionalUpdatePersistentPathIfExists(ZkClient client, String path$5, String data$3, int expectVersion$1) {
        Tuple2<Object, Object> exceptionResult2 = null;
        try {
            Stat stat$2 = client.writeDataReturnStat(path$5, data$3, expectVersion$1);
            this.debug((Function0<String>)((Object)new scala.Serializable(path$5, data$3, expectVersion$1, stat$2){
                public static final long serialVersionUID;
                private final String path$5;
                private final String data$3;
                private final int expectVersion$1;
                private final Stat stat$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$5, this.data$3, BoxesRunTime.boxToInteger(this.expectVersion$1), BoxesRunTime.boxToInteger(this.stat$2.getVersion())}));
                }
                {
                    this.path$5 = string2;
                    this.data$3 = string3;
                    this.expectVersion$1 = n;
                    this.stat$2 = stat;
                }
            }));
            return new Tuple2<Boolean, Integer>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(stat$2.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new scala.Serializable(path$5, data$3, expectVersion$1, exception){
                public static final long serialVersionUID;
                private final String path$5;
                private final String data$3;
                private final int expectVersion$1;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$5, this.data$3, BoxesRunTime.boxToInteger(this.expectVersion$1), this.e$1.getMessage()}));
                }
                {
                    this.path$5 = string2;
                    this.data$3 = string3;
                    this.expectVersion$1 = n;
                    this.e$1 = exception;
                }
            }));
            return new Tuple2<Object, Object>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(-1));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data, List<ACL> acls) {
        try {
            client.writeData(path, data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path, this.createParentPath$default$3());
            ZkPath$.MODULE$.createEphemeral(client, path, data, acls);
        }
    }

    public List updateEphemeralPath$default$4() {
        return this.DefaultAcls();
    }

    /*
     * WARNING - void declaration
     */
    public boolean deletePath(ZkClient client, String path$3) {
        void var3_3;
        boolean exceptionResult3 = false;
        try {
            exceptionResult3 = client.delete(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new scala.Serializable(path$3){
                public static final long serialVersionUID;
                private final String path$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$3).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$3 = string2;
                }
            }));
            exceptionResult3 = false;
        }
        return (boolean)var3_3;
    }

    public void deletePathRecursive(ZkClient client, String path$1) {
        try {
            client.deleteRecursive(path$1);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new scala.Serializable(path$1){
                public static final long serialVersionUID;
                private final String path$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$1).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$1 = string2;
                }
            }));
        }
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String dataStr = (String)client.readData(path, stat);
        return new Tuple2<String, Stat>(dataStr, stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient client, String path) {
        Stat stat = new Stat();
        Tuple2<Option<String>, Stat> exceptionResult4 = null;
        try {
            exceptionResult4 = new Tuple2(new Some(client.readData(path, stat)), stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            exceptionResult4 = new Tuple2<Option<String>, Stat>(None$.MODULE$, stat);
        }
        Tuple2<Option<String>, Stat> dataAndStat = exceptionResult4;
        return dataAndStat;
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        void var3_3;
        Seq<Nothing$> exceptionResult5 = null;
        try {
            exceptionResult5 = JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            exceptionResult5 = Nil$.MODULE$;
        }
        return var3_3;
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$7) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$7, this.BrokerIdsPath());
        nodes.foreach(new scala.Serializable(zkClient$7, cluster$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$7;
            private final Cluster cluster$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(String node) {
                String brokerZKString = ZkUtils$.MODULE$.readData(this.zkClient$7, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)node).toString())._1();
                return this.cluster$1.add(Broker$.MODULE$.createBroker(Predef$.MODULE$.augmentString(node).toInt(), brokerZKString));
            }
            {
                this.zkClient$7 = zkClient;
                this.cluster$1 = cluster;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient$8, Set<TopicAndPartition> topicAndPartitions) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topicAndPartitions.foreach(new scala.Serializable(zkClient$8, ret$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$8;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(TopicAndPartition topicAndPartition) {
                Option<LeaderIsrAndControllerEpoch> option;
                block4: {
                    Serializable serializable;
                    block3: {
                        block2: {
                            option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient$8, topicAndPartition.topic(), topicAndPartition.partition());
                            if (!(option instanceof Some)) break block2;
                            serializable = this.ret$1.put(topicAndPartition, ((Some)option).x());
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<LeaderIsrAndControllerEpoch> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        serializable = BoxedUnit.UNIT;
                    }
                    return serializable;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$8 = zkClient;
                this.ret$1 = hashMap;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> getReplicaAssignmentForTopics(ZkClient zkClient$1, Seq<String> topics) {
        void var3_3;
        HashMap ret$2 = new HashMap();
        topics.foreach(new scala.Serializable(zkClient$1, ret$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            public final HashMap ret$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic$2) {
                Option<String> option;
                block12: {
                    block11: {
                        block10: {
                            Option<String> jsonPartitionMapOpt = ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$1, ZkUtils$.MODULE$.getTopicPath(topic$2))._1();
                            option = jsonPartitionMapOpt;
                            if (!(option instanceof Some)) break block10;
                            Some some = (Some)option;
                            String string2 = (String)some.x();
                            String jsonPartitionMap = string2;
                            Option<Object> option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                            if (option2 instanceof Some) {
                                Some some2 = (Some)option2;
                                A a = some2.x();
                                A m = a;
                                Option<B> option3 = ((Map)m).get("partitions");
                                if (option3 instanceof Some) {
                                    A a2;
                                    Some some3 = (Some)option3;
                                    A repl = a2 = some3.x();
                                    Map replicaMap = (Map)repl;
                                    ((IterableLike)replicaMap.filter(new scala.Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(Tuple2<String, Seq<Object>> tuple2) {
                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                            return tuple22 != null;
                                        }
                                    })).foreach(new scala.Serializable(this, topic$2){
                                        public static final long serialVersionUID;
                                        private final anonfun.getReplicaAssignmentForTopics.1 $outer;
                                        public final String topic$2;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final void apply(Tuple2<String, Seq<Object>> tuple2) {
                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                            if (tuple22 != null) {
                                                String string2 = tuple22._1();
                                                Seq<Object> seq = tuple22._2();
                                                String partition$1 = string2;
                                                Seq<Object> replicas$1 = seq;
                                                this.$outer.ret$2.put(new TopicAndPartition(this.topic$2, Predef$.MODULE$.augmentString(partition$1).toInt()), replicas$1);
                                                ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, partition$1, replicas$1){
                                                    public static final long serialVersionUID;
                                                    private final anonfun$getReplicaAssignmentForTopics$1$$anonfun$apply$3 $outer;
                                                    private final String partition$1;
                                                    private final Seq replicas$1;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final String apply() {
                                                        return Predef$.MODULE$.augmentString("Replicas assigned to topic [%s], partition [%s] are [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$2, this.partition$1, this.replicas$1}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.partition$1 = string2;
                                                        this.replicas$1 = seq;
                                                    }
                                                }));
                                                return;
                                            }
                                            throw new MatchError(tuple22);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topic$2 = string2;
                                        }
                                    });
                                } else {
                                    None$ none$ = None$.MODULE$;
                                    Option<B> option4 = option3;
                                    if (none$ == null ? option4 != null : !none$.equals(option4)) {
                                        throw new MatchError(option3);
                                    }
                                }
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option<Object> option5 = option2;
                                if (none$ == null ? option5 != null : !none$.equals(option5)) {
                                    throw new MatchError(option2);
                                }
                            }
                            break block11;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block12;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$1 = zkClient;
                this.ret$2 = hashMap;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> getPartitionAssignmentForTopics(ZkClient zkClient$3, Seq<String> topics) {
        void var3_3;
        HashMap ret$3 = new HashMap();
        topics.foreach(new scala.Serializable(zkClient$3, ret$3){
            public static final long serialVersionUID;
            private final ZkClient zkClient$3;
            private final HashMap ret$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final HashMap<String, Map<Object, Seq<Object>>> apply(String topic$3) {
                Option<String> option;
                block8: {
                    Map<A, B> map2;
                    block5: {
                        block2: {
                            Option<Object> option2;
                            block7: {
                                block3: {
                                    Option<B> option3;
                                    block6: {
                                        block4: {
                                            A a;
                                            Option<String> jsonPartitionMapOpt = ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$3, ZkUtils$.MODULE$.getTopicPath(topic$3))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string2 = (String)some.x();
                                            String jsonPartitionMap = string2;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            A a2 = some2.x();
                                            A m = a2;
                                            option3 = ((Map)m).get("partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            A replicaMap = a = some3.x();
                                            Map m1 = (Map)replicaMap;
                                            map2 = m1.map(new scala.Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final Tuple2<Object, Seq<Object>> apply(Tuple2<String, Seq<Object>> p) {
                                                    return new Tuple2<Object, Seq<Object>>(BoxesRunTime.boxToInteger(Predef$.MODULE$.augmentString(p._1()).toInt()), p._2());
                                                }
                                            }, scala.collection.Map$.MODULE$.canBuildFrom());
                                            break block5;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<B> option4 = option3;
                                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                        map2 = (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                                        break block5;
                                    }
                                    throw new MatchError(option3);
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Object> option5 = option2;
                                if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                map2 = (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                                break block5;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                        map2 = (Map<A, B>)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                    }
                    Map<A, B> partitionMap$1 = map2;
                    ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, topic$3, partitionMap$1){
                        public static final long serialVersionUID;
                        private final String topic$3;
                        private final Map partitionMap$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Partition map for /brokers/topics/%s is %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3, this.partitionMap$1}));
                        }
                        {
                            this.topic$3 = string2;
                            this.partitionMap$1 = map2;
                        }
                    }));
                    return this.ret$3.$plus$eq(Predef$.MODULE$.any2ArrowAssoc(topic$3).$minus$greater(partitionMap$1));
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$3 = zkClient;
                this.ret$3 = hashMap;
            }
        });
        return var3_3;
    }

    public scala.collection.mutable.Map<String, Seq<Object>> getPartitionsForTopics(ZkClient zkClient, Seq<String> topics) {
        return this.getPartitionAssignmentForTopics(zkClient, topics).map((Function1<Object, Seq<Object>>)((Object)new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Map<Object, Seq<Object>>> topicAndPartitionMap) {
                String topic$4 = topicAndPartitionMap._1();
                Map<Object, Seq<Object>> partitionMap$2 = topicAndPartitionMap._2();
                ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, topic$4, partitionMap$2){
                    public static final long serialVersionUID;
                    private final String topic$4;
                    private final Map partitionMap$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("partition assignment of /brokers/topics/%s is %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4, this.partitionMap$2}));
                    }
                    {
                        this.topic$4 = string2;
                        this.partitionMap$2 = map2;
                    }
                }));
                return Predef$.MODULE$.any2ArrowAssoc(topic$4).$minus$greater(partitionMap$2.keys().toSeq().sortWith((Function2<Object, Object, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(int s, int t) {
                        return this.apply$mcZII$sp(s, t);
                    }

                    public boolean apply$mcZII$sp(int v1, int v2) {
                        return v1 < v2;
                    }
                })));
            }
        }), Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option<String> option;
        block4: {
            Map map2;
            block3: {
                block2: {
                    String string2;
                    Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = jsonPartitionMapOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionMap = string2 = (String)some.x();
                    Map<TopicAndPartition, Seq<Object>> reassignedPartitions = this.parsePartitionReassignmentData(jsonPartitionMap);
                    map2 = reassignedPartitions.map((Function1<TopicAndPartition, Seq<Object>>)((Object)new scala.Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Tuple2<TopicAndPartition, ReassignedPartitionsContext> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                            return Predef$.MODULE$.any2ArrowAssoc(p._1()).$minus$greater(new ReassignedPartitionsContext(p._2(), ReassignedPartitionsContext$.MODULE$.init$default$2()));
                        }
                    }), scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                map2 = scala.collection.Map$.MODULE$.empty();
            }
            return map2;
        }
        throw new MatchError(option);
    }

    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parsePartitionReassignmentDataWithoutDedup(String jsonData) {
        Option<Object> option;
        block6: {
            Seq seq;
            block4: {
                block2: {
                    Option option2;
                    block5: {
                        block3: {
                            option = Json$.MODULE$.parseFull(jsonData);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object a = some.x();
                            Object m = a;
                            option2 = ((Map)m).get("partitions");
                            if (!(option2 instanceof Some)) break block3;
                            seq = ((Seq)((Some)option2).x()).map(new scala.Serializable(){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Tuple2<TopicAndPartition, Seq<Object>> apply(Map<String, Object> p) {
                                    String topic = (String)p.get("topic").get();
                                    int partition2 = BoxesRunTime.unboxToInt(p.get("partition").get());
                                    Seq newReplicas = (Seq)p.get("replicas").get();
                                    return Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(topic, partition2)).$minus$greater(newReplicas);
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        return this.parsePartitionReassignmentDataWithoutDedup(jsonData).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block9: {
            ObjectRef topics$1;
            block8: {
                block7: {
                    topics$1 = new ObjectRef(List$.MODULE$.empty());
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object a = some.x();
                    Object m = a;
                    Option option2 = ((Map)m).get("topics");
                    if (option2 instanceof Some) {
                        Object a2;
                        Some some2 = (Some)option2;
                        Object partitionsSeq = a2 = some2.x();
                        Seq mapPartitionSeq = (Seq)partitionsSeq;
                        mapPartitionSeq.foreach(new scala.Serializable(topics$1){
                            public static final long serialVersionUID;
                            private final ObjectRef topics$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Map<String, Object> p) {
                                String topic = (String)p.get("topic").get();
                                this.topics$1.elem = ((List)this.topics$1.elem).$plus$plus(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
                            }
                            {
                                this.topics$1 = objectRef;
                            }
                        });
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError(option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return (List)topics$1.elem;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("version").$minus$greater(BoxesRunTime.boxToInteger(1)), Predef$.MODULE$.any2ArrowAssoc("partitions").$minus$greater(partitionsToBeReassigned.map((Function1<TopicAndPartition, Seq<Object>>)((Object)new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Map<String, Object> apply(Tuple2<TopicAndPartition, Seq<Object>> e) {
                return (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc("topic").$minus$greater(e._1().topic()), Predef$.MODULE$.any2ArrowAssoc("partition").$minus$greater(BoxesRunTime.boxToInteger(e._1().partition())), Predef$.MODULE$.any2ArrowAssoc("replicas").$minus$greater(e._2())}));
            }
        }), Iterable$.MODULE$.canBuildFrom()))})));
    }

    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        String zkPath$1 = this.ReassignPartitionsPath();
        int n = partitionsToBeReassigned.size();
        if (n == 0) {
            this.deletePath(zkClient, zkPath$1);
            this.info((Function0<String>)((Object)new scala.Serializable(zkPath$1){
                public static final long serialVersionUID;
                private final String zkPath$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("No more partitions need to be reassigned. Deleting zk path %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1}));
                }
                {
                    this.zkPath$1 = string2;
                }
            }));
        } else {
            String jsonData$1 = this.getPartitionReassignmentZkData(partitionsToBeReassigned);
            try {
                this.updatePersistentPath(zkClient, zkPath$1, jsonData$1, this.updatePersistentPath$default$4());
                this.info((Function0<String>)((Object)new scala.Serializable(jsonData$1){
                    public static final long serialVersionUID;
                    private final String jsonData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Updated partition reassignment path with %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.jsonData$1}));
                    }
                    {
                        this.jsonData$1 = string2;
                    }
                }));
            }
            catch (Throwable throwable) {
                throw new AdminOperationException(throwable.toString());
            }
            catch (ZkNoNodeException zkNoNodeException) {
                this.createPersistentPath(zkClient, zkPath$1, jsonData$1, this.createPersistentPath$default$4());
                this.debug((Function0<String>)((Object)new scala.Serializable(zkPath$1, jsonData$1){
                    public static final long serialVersionUID;
                    private final String zkPath$1;
                    private final String jsonData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Created path %s with %s for partition reassignment").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1, this.jsonData$1}));
                    }
                    {
                        this.zkPath$1 = string2;
                        this.jsonData$1 = string3;
                    }
                }));
            }
        }
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option<String> option;
        block4: {
            GenTraversable<TopicAndPartition> genTraversable;
            block3: {
                block2: {
                    Option<String> jsonPartitionListOpt = this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = jsonPartitionListOpt;
                    if (!(option instanceof Some)) break block2;
                    genTraversable = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData((String)((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                genTraversable = Set$.MODULE$.empty();
            }
            return genTraversable;
        }
        throw new MatchError(option);
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<ConsumerThreadId>> getConsumersPerTopic(ZkClient zkClient$6, String group$1, boolean excludeInternalTopics$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$6, dirs.consumerRegistryDir());
        HashMap<String, List<ConsumerThreadId>> consumersPerTopicMap$1 = new HashMap<String, List<ConsumerThreadId>>();
        consumers.foreach(new scala.Serializable(zkClient$6, group$1, excludeInternalTopics$1, consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$6;
            private final String group$1;
            private final boolean excludeInternalTopics$1;
            public final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String consumer) {
                TopicCount topicCount = TopicCount$.MODULE$.constructTopicCount(this.group$1, consumer, this.zkClient$6, this.excludeInternalTopics$1);
                ((IterableLike)topicCount.getConsumerThreadIdsPerTopic().filter((Function1<String, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<String, Set<ConsumerThreadId>> tuple2) {
                        Tuple2<String, Set<ConsumerThreadId>> tuple22 = tuple2;
                        return tuple22 != null;
                    }
                }))).foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.getConsumersPerTopic.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<String, Set<ConsumerThreadId>> tuple2) {
                        Tuple2<String, Set<ConsumerThreadId>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            String string2;
                            String topic$5 = string2 = tuple22._1();
                            ((IterableLike)tuple22._2()).foreach(new scala.Serializable(this, topic$5){
                                public static final long serialVersionUID;
                                private final anonfun$getConsumersPerTopic$1$$anonfun$apply$8 $outer;
                                private final String topic$5;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<List<ConsumerThreadId>> apply(ConsumerThreadId consumerThreadId) {
                                    Option<GenTraversable<ConsumerThreadId>> option;
                                    Option<B> option2 = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.get(this.topic$5);
                                    if (option2 instanceof Some) {
                                        ConsumerThreadId consumerThreadId2 = consumerThreadId;
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$5, ((List)((Some)option2).x()).$colon$colon(consumerThreadId2));
                                    } else {
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$5, List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ConsumerThreadId[]{consumerThreadId})));
                                    }
                                    return option;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$5 = string2;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public anonfun.getConsumersPerTopic.1 kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.zkClient$6 = zkClient;
                this.group$1 = string2;
                this.excludeInternalTopics$1 = bl;
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        ((HashMap)consumersPerTopicMap$1.filter((Function1<String, Object>)((Object)new scala.Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<ConsumerThreadId>> tuple2) {
                Tuple2<String, List<ConsumerThreadId>> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new scala.Serializable(consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<List<ConsumerThreadId>> apply(Tuple2<String, List<ConsumerThreadId>> tuple2) {
                Tuple2<String, List<ConsumerThreadId>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return this.consumersPerTopicMap$1.put(tuple22._1(), ((SeqLike)tuple22._2()).sortWith(new scala.Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(ConsumerThreadId s, ConsumerThreadId t) {
                            return s.$less(t);
                        }
                    }));
                }
                throw new MatchError(tuple22);
            }
            {
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        return consumersPerTopicMap$1;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int brokerId) {
        Option<String> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    option = this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    option2 = new Some<Broker>(Broker$.MODULE$.createBroker(brokerId, (String)((Some)option).x()));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getSequenceId(ZkClient client, String path, List<ACL> acls) {
        int exceptionResult6 = 0;
        try {
            Stat stat = client.writeDataReturnStat(path, "", -1);
            exceptionResult6 = stat.getVersion();
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, this.BrokerSequenceIdPath(), this.createParentPath$default$3());
            int exceptionResult7 = 0;
            try {
                ZkPath$.MODULE$.createPersistent(client, this.BrokerSequenceIdPath(), "", acls);
                exceptionResult7 = 0;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                Stat stat = client.writeDataReturnStat(this.BrokerSequenceIdPath(), "", -1);
                exceptionResult7 = stat.getVersion();
            }
            exceptionResult6 = exceptionResult7;
        }
        return exceptionResult6;
    }

    public List getSequenceId$default$3() {
        return this.DefaultAcls();
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? (Seq)Seq$.MODULE$.empty() : topics;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient$4) {
        Seq<String> topics = this.getChildrenParentMayNotExist(zkClient$4, this.BrokerTopicsPath());
        return topics == null ? Set$.MODULE$.empty() : ((TraversableOnce)((GenericTraversableTemplate)topics.map(new scala.Serializable(zkClient$4){
            public static final long serialVersionUID;
            private final ZkClient zkClient$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<TopicAndPartition> apply(String topic$6) {
                return ((TraversableLike)ZkUtils$.MODULE$.getChildren(this.zkClient$4, ZkUtils$.MODULE$.getTopicPartitionsPath(topic$6)).map(new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String string2) {
                        return Predef$.MODULE$.augmentString(string2).toInt();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map(new scala.Serializable(this, topic$6){
                    public static final long serialVersionUID;
                    private final String topic$6;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(int n) {
                        return new TopicAndPartition(this.topic$6, n);
                    }
                    {
                        this.topic$6 = string2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.zkClient$4 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms())).toSet();
    }

    public Seq<String> getConsumerGroups(ZkClient zkClient) {
        return this.getChildren(zkClient, this.ConsumersPath());
    }

    public Seq<String> getTopicsByConsumerGroup(ZkClient zkClient, String consumerGroup) {
        return this.getChildrenParentMayNotExist(zkClient, new ZKGroupDirs(consumerGroup).consumerGroupOwnersDir());
    }

    public Set<String> getAllConsumerGroupsForTopic(ZkClient zkClient$2, String topic$1) {
        Seq<String> groups = this.getChildrenParentMayNotExist(zkClient$2, this.ConsumersPath());
        return groups == null ? Set$.MODULE$.empty() : (Set)groups.foldLeft(Set$.MODULE$.empty(), new scala.Serializable(zkClient$2, topic$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$2;
            private final String topic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Set<String> apply(Set<String> consumerGroupsForTopic, String group) {
                Seq<String> topics = ZkUtils$.MODULE$.getChildren(this.zkClient$2, new ZKGroupDirs(group).consumerGroupOffsetsDir());
                return topics.contains(this.topic$1) ? consumerGroupsForTopic.$plus(group) : consumerGroupsForTopic;
            }
            {
                this.zkClient$2 = zkClient;
                this.topic$1 = string2;
            }
        });
    }

    private final void liftedTree1$1(BooleanRef booleanRef, File file) {
        try {
            URI config_uri = file.toURI();
            Configuration login_conf = Configuration.getInstance("JavaLoginConfig", new URIParameter(config_uri));
            booleanRef.elem = login_conf.getAppConfigurationEntry("Client") != null;
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.TopicConfigPath = "/config/topics";
        this.TopicConfigChangesPath = "/config/changes";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
        this.BrokerSequenceIdPath = "/brokers/seqid";
        String loginConfigurationFile = System.getProperty("java.security.auth.login.config");
        BooleanRef isSecure$1 = new BooleanRef(false);
        if (loginConfigurationFile != null && loginConfigurationFile.length() > 0) {
            File config_file$1 = new File(loginConfigurationFile);
            if (config_file$1.canRead()) {
                this.liftedTree1$1(isSecure$1, config_file$1);
            } else {
                throw new RuntimeException(new StringBuilder().append((Object)"File ").append((Object)loginConfigurationFile).append((Object)" cannot be read.").toString());
            }
        }
        this.isSecure = isSecure$1.elem;
        this.DefaultAcls = this.isSecure() ? JavaConversions$.MODULE$.asScalaBuffer(ZooDefs.Ids.CREATOR_ALL_ACL).$plus$plus((GenTraversableOnce<ACL>)JavaConversions$.MODULE$.asScalaBuffer(ZooDefs.Ids.READ_ACL_UNSAFE)).toList() : JavaConversions$.MODULE$.asScalaBuffer(ZooDefs.Ids.OPEN_ACL_UNSAFE).toList();
    }
}

