/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.timer.Timer$;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel;
import scala.Function1;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001%\u0011Q\u0001V5nKJT!a\u0001\u0003\u0002\u000bQLW.\u001a:\u000b\u0005\u00151\u0011!B;uS2\u001c(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0003\n\u0011\u0005-\u0001R\"\u0001\u0007\u000b\u00055q\u0011\u0001\u00027b]\u001eT\u0011aD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0012\u0019\t1qJ\u00196fGR\u0004\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u00111bU2bY\u0006|%M[3di\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0007uCN\\W\t_3dkR|'\u000f\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}q\u0011\u0001B;uS2L!!\t\u000f\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0007i&\u001c7.T:\u0011\u0005M)\u0013B\u0001\u0014\u0015\u0005\u0011auN\\4\t\u0011!\u0002!\u0011!Q\u0001\n%\n\u0011b\u001e5fK2\u001c\u0016N_3\u0011\u0005MQ\u0013BA\u0016\u0015\u0005\rIe\u000e\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005I\u000591\u000f^1si6\u001b\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00032gQ*d\u0007\u0005\u00023\u00015\t!\u0001C\u0003\u001a]\u0001\u0007!\u0004C\u0004$]A\u0005\t\u0019\u0001\u0013\t\u000f!r\u0003\u0013!a\u0001S!9QF\fI\u0001\u0002\u0004!\u0003B\u0002\u001d\u0001A\u0003%\u0011(\u0001\u0006eK2\f\u00170U;fk\u0016\u00042a\u0007\u001e=\u0013\tYDD\u0001\u0006EK2\f\u00170U;fk\u0016\u0004\"AM\u001f\n\u0005y\u0012!!\u0004+j[\u0016\u0014H+Y:l\u0019&\u001cH\u000f\u0003\u0004A\u0001\u0001\u0006I!Q\u0001\fi\u0006\u001c8nQ8v]R,'\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002E9\u00051\u0011\r^8nS\u000eL!AR\"\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019A\u0005\u0001)A\u0005\u0013\u0006YA/[7j]\u001e<\u0006.Z3m!\t\u0011$*\u0003\u0002L\u0005\tYA+[7j]\u001e<\u0006.Z3m\u0011\u0019i\u0005\u0001)A\u0005\u001d\u0006i!/Z1e/JLG/\u001a'pG.\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u000f\u0002\u000b1|7m[:\n\u0005M\u0003&A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\rU\u0003\u0001\u0015!\u0003W\u0003!\u0011X-\u00193M_\u000e\\\u0007CA,[\u001b\u0005A&BA-Q\u0003Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017BA.Y\u0005!\u0011V-\u00193M_\u000e\\\u0007BB/\u0001A\u0003%a,A\u0005xe&$X\rT8dWB\u0011qkX\u0005\u0003Ab\u0013\u0011b\u0016:ji\u0016dunY6\t\u000b\t\u0004A\u0011A2\u0002\u0007\u0005$G\r\u0006\u0002eOB\u00111#Z\u0005\u0003MR\u0011A!\u00168ji\")\u0001.\u0019a\u0001S\u0006IA/[7feR\u000b7o\u001b\t\u0003e)L!a\u001b\u0002\u0003\u0013QKW.\u001a:UCN\\\u0007\"B7\u0001\t\u0013q\u0017!E1eIRKW.\u001a:UCN\\WI\u001c;ssR\u0011Am\u001c\u0005\u0006a2\u0004\r!]\u0001\u000fi&lWM\u001d+bg.,e\u000e\u001e:z!\t\u0011$/\u0003\u0002t\u0005\tqA+[7feR\u000b7o[#oiJL\bBB;\u0001A\u0003%a/\u0001\u0005sK&t7/\u001a:u!\u0011\u0019r/\u001d3\n\u0005a$\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015Q\b\u0001\"\u0001|\u00031\tGM^1oG\u0016\u001cEn\\2l)\tax\u0010\u0005\u0002\u0014{&\u0011a\u0010\u0006\u0002\b\u0005>|G.Z1o\u0011\u0019\t\t!\u001fa\u0001I\u0005IA/[7f_V$Xj\u001d\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0003\u0011\u0019\u0018N_3\u0015\u0003%B3\u0001AA\u0006!\u0011\ti!a\u0004\u000e\u0003\u0011I1!!\u0005\u0005\u0005)!\bN]3bIN\fg-Z\u0004\n\u0003+\u0011\u0011\u0011!E\u0003\u0003/\tQ\u0001V5nKJ\u00042AMA\r\r!\t!!!A\t\u0006\u0005m1\u0003BA\r\u0015IAqaLA\r\t\u0003\ty\u0002\u0006\u0002\u0002\u0018!Q\u00111EA\r#\u0003%\t!!\n\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0005\u0016\u0004I\u0005%2FAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UB#\u0001\u0006b]:|G/\u0019;j_:LA!!\u000f\u00020\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005u\u0012\u0011DI\u0001\n\u0003\ty$\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005#fA\u0015\u0002*!Q\u0011QIA\r#\u0003%\t!!\n\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class Timer
implements ScalaObject {
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function1<TimerTaskEntry, BoxedUnit> reinsert;

    public static final long init$default$4() {
        return Timer$.MODULE$.init$default$4();
    }

    public static final int init$default$3() {
        return Timer$.MODULE$.init$default$3();
    }

    public static final long init$default$2() {
        return Timer$.MODULE$.init$default$2();
    }

    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.kafka$utils$timer$Timer$$addTimerTaskEntry(new TimerTaskEntry(timerTask));
            return;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public final void kafka$utils$timer$Timer$$addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry)) {
            this.taskExecutor.submit(timerTaskEntry.timerTask());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            while (true) {
                if (bucket == null) {
                    boolean bl = true;
                    return bl;
                }
                this.timingWheel.advanceClock(bucket.getExpiration());
                bucket.flush(this.reinsert);
                bucket = (TimerTaskList)this.delayQueue.poll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int size() {
        return this.taskCounter.get();
    }

    public Timer(ExecutorService taskExecutor, long tickMs, int wheelSize, long startMs) {
        this.taskExecutor = taskExecutor;
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = new $anonfun$1(this);
    }
}

