/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.utils.SystemTime$;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import scala.Function1;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0001\u0005!\u0011Q\u0002V5nKJ$\u0016m]6MSN$(BA\u0002\u0005\u0003\u0015!\u0018.\\3s\u0015\t)a!A\u0003vi&d7OC\u0001\b\u0003\u0015Y\u0017MZ6b'\u0011\u0001\u0011\"E\r\u0011\u0005)yQ\"A\u0006\u000b\u00051i\u0011\u0001\u00027b]\u001eT\u0011AD\u0001\u0005U\u00064\u0018-\u0003\u0002\u0011\u0017\t1qJ\u00196fGR\u0004\"AE\f\u000e\u0003MQ!\u0001F\u000b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u0017\u001b\u0005!Q\u000f^5m\u0013\tA2CA\u0004EK2\f\u00170\u001a3\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tA\u0001\u0011\t\u0011)A\u0005E\u0005YA/Y:l\u0007>,h\u000e^3s\u0007\u0001\u0001\"a\t\u0014\u000e\u0003\u0011R!!J\n\u0002\r\u0005$x.\\5d\u0013\t9CEA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-j\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011)\u0001\u0004\u0011\u0003BB\u0018\u0001A\u0003%\u0001'\u0001\u0003s_>$\bC\u0001\u00172\u0013\t\u0011$A\u0001\bUS6,'\u000fV1tW\u0016sGO]=\t\rQ\u0002\u0001\u0015!\u00036\u0003))\u0007\u0010]5sCRLwN\u001c\t\u0003GYJ!a\u000e\u0013\u0003\u0015\u0005#x.\\5d\u0019>tw\rC\u0003:\u0001\u0011\u0005!(A\u0007tKR,\u0005\u0010]5sCRLwN\u001c\u000b\u0003wy\u0002\"A\u0007\u001f\n\u0005uZ\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007fa\u0002\r\u0001Q\u0001\rKb\u0004\u0018N]1uS>tWj\u001d\t\u00035\u0005K!AQ\u000e\u0003\t1{gn\u001a\u0005\u0006\t\u0002!\t!R\u0001\u000eO\u0016$X\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0003\u0001CQa\u0012\u0001\u0005\u0002!\u000bqAZ8sK\u0006\u001c\u0007\u000e\u0006\u0002J\u0019B\u0011!DS\u0005\u0003\u0017n\u0011A!\u00168ji\")QJ\u0012a\u0001\u001d\u0006\ta\r\u0005\u0003\u001b\u001fFK\u0015B\u0001)\u001c\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002-%&\u00111K\u0001\u0002\n)&lWM\u001d+bg.DQ!\u0016\u0001\u0005\u0002Y\u000b1!\u00193e)\tIu\u000bC\u0003Y)\u0002\u0007\u0001'\u0001\buS6,'\u000fV1tW\u0016sGO]=\t\u000bi\u0003A\u0011A.\u0002\rI,Wn\u001c<f)\tIE\fC\u0003Y3\u0002\u0007\u0001\u0007C\u0003_\u0001\u0011\u0005q,A\u0003gYV\u001c\b\u000e\u0006\u0002JA\")Q*\u0018a\u0001CB!!d\u0014\u0019J\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003!9W\r\u001e#fY\u0006LHC\u0001!f\u0011\u00151'\r1\u0001h\u0003\u0011)h.\u001b;\u0011\u0005IA\u0017BA5\u0014\u0005!!\u0016.\\3V]&$\b\"B6\u0001\t\u0003a\u0017!C2p[B\f'/\u001a+p)\ti\u0007\u000f\u0005\u0002\u001b]&\u0011qn\u0007\u0002\u0004\u0013:$\b\"B9k\u0001\u0004\t\u0012!\u00013)\u0005\u0001\u0019\bC\u0001;v\u001b\u0005!\u0011B\u0001<\u0005\u0005)!\bN]3bIN\fg-\u001a")
public class TimerTaskList
implements Delayed,
ScalaObject {
    private final AtomicInteger taskCounter;
    private final TimerTaskEntry root;
    private final AtomicLong expiration;

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    public void foreach(Function1<TimerTask, BoxedUnit> f) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry entry2 = this.root.next();
            while (entry2 != this.root) {
                TimerTaskEntry nextEntry = entry2.next();
                f.apply(entry2.timerTask());
                entry2 = nextEntry;
            }
            return;
        }
    }

    public void add(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry tail = this.root.prev();
            timerTaskEntry.next_$eq(this.root);
            timerTaskEntry.prev_$eq(tail);
            timerTaskEntry.list_$eq(this);
            tail.next_$eq(timerTaskEntry);
            this.root.prev_$eq(timerTaskEntry);
            BoxesRunTime.boxToInteger(this.taskCounter.incrementAndGet());
            return;
        }
    }

    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            Serializable serializable;
            if (timerTaskEntry.list() == null) {
                serializable = BoxedUnit.UNIT;
            } else {
                timerTaskEntry.next().prev_$eq(timerTaskEntry.prev());
                timerTaskEntry.prev().next_$eq(timerTaskEntry.next());
                timerTaskEntry.next_$eq(null);
                timerTaskEntry.prev_$eq(null);
                timerTaskEntry.list_$eq(null);
                serializable = BoxesRunTime.boxToInteger(this.taskCounter.decrementAndGet());
            }
            return;
        }
    }

    public void flush(Function1<TimerTaskEntry, BoxedUnit> f) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry head2 = this.root.next();
            while (head2 != this.root) {
                this.remove(head2);
                f.apply(head2);
                head2 = this.root.next();
            }
            this.expiration.set(-1L);
            return;
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(package$.MODULE$.max(this.getExpiration() - SystemTime$.MODULE$.milliseconds(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        TimerTaskList other = (TimerTaskList)d;
        return this.getExpiration() < other.getExpiration() ? -1 : (this.getExpiration() > other.getExpiration() ? 1 : 0);
    }

    public TimerTaskList(AtomicInteger taskCounter) {
        this.taskCounter = taskCounter;
        this.root = new TimerTaskEntry(null);
        this.root.next_$eq(this.root);
        this.root.prev_$eq(this.root);
        this.expiration = new AtomicLong(-1L);
    }
}

