/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel$;
import scala.Array$;
import scala.ScalaObject;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u000154Q!\u0001\u0002\u0001\u0005!\u00111\u0002V5nS:<w\u000b[3fY*\u00111\u0001B\u0001\u0006i&lWM\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT\u0011aB\u0001\u0006W\u000647.Y\n\u0004\u0001%\t\u0002C\u0001\u0006\u0010\u001b\u0005Y!B\u0001\u0007\u000e\u0003\u0011a\u0017M\\4\u000b\u00039\tAA[1wC&\u0011\u0001c\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t1\u0001\u0011\t\u0011)A\u00055\u00051A/[2l\u001bN\u001c\u0001\u0001\u0005\u0002\u00137%\u0011Ad\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003%9\b.Z3m'&TX\r\u0005\u0002\u0013A%\u0011\u0011e\u0005\u0002\u0004\u0013:$\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000fM$\u0018M\u001d;Ng\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0006uCN\\7i\\;oi\u0016\u0014\bCA\u0014/\u001b\u0005A#BA\u0015+\u0003\u0019\tGo\\7jG*\u00111\u0006L\u0001\u000bG>t7-\u001e:sK:$(BA\u0017\u000e\u0003\u0011)H/\u001b7\n\u0005=B#!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0003\u0015\tX/Z;f!\r\u0019DGN\u0007\u0002U%\u0011QG\u000b\u0002\u000b\t\u0016d\u0017-_)vKV,\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u00055!\u0016.\\3s)\u0006\u001c8\u000eT5ti\")1\b\u0001C\u0001y\u00051A(\u001b8jiz\"b!\u0010 @\u0001\u0006\u0013\u0005CA\u001c\u0001\u0011\u0015A\"\b1\u0001\u001b\u0011\u0015q\"\b1\u0001 \u0011\u0015\u0019#\b1\u0001\u001b\u0011\u0015)#\b1\u0001'\u0011\u0015\t$\b1\u00013\u0011\u0019!\u0005\u0001)A\u00055\u0005A\u0011N\u001c;feZ\fG\u000e\u0003\u0004G\u0001\u0001\u0006IaR\u0001\bEV\u001c7.\u001a;t!\r\u0011\u0002JN\u0005\u0003\u0013N\u0011Q!\u0011:sCfDaa\u0013\u0001!B\u0013Q\u0012aC2veJ,g\u000e\u001e+j[\u0016Da!\u0014\u0001!B\u0013i\u0014!D8wKJ4Gn\\<XQ\u0016,G\u000e\u000b\u0002M\u001fB\u0011!\u0003U\u0005\u0003#N\u0011\u0001B^8mCRLG.\u001a\u0005\u0007'\u0002\u0001K\u0011\u0002+\u0002!\u0005$Gm\u0014<fe\u001adwn^,iK\u0016dG#A+\u0011\u0005I1\u0016BA,\u0014\u0005\u0011)f.\u001b;\t\u000be\u0003A\u0011\u0001.\u0002\u0007\u0005$G\r\u0006\u0002\\=B\u0011!\u0003X\u0005\u0003;N\u0011qAQ8pY\u0016\fg\u000eC\u0003`1\u0002\u0007\u0001-\u0001\buS6,'\u000fV1tW\u0016sGO]=\u0011\u0005]\n\u0017B\u00012\u0003\u00059!\u0016.\\3s)\u0006\u001c8.\u00128uefDQ\u0001\u001a\u0001\u0005\u0002\u0015\fA\"\u00193wC:\u001cWm\u00117pG.$\"!\u00164\t\u000b\u001d\u001c\u0007\u0019\u0001\u000e\u0002\rQLW.Z'tQ\t\u0001\u0011\u000e\u0005\u0002kW6\tA!\u0003\u0002m\t\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class TimingWheel
implements ScalaObject {
    private final long tickMs;
    private final int wheelSize;
    public final AtomicInteger kafka$utils$timer$TimingWheel$$taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final TimerTaskList[] buckets;
    private long currentTime;
    private volatile TimingWheel overflowWheel;

    private void addOverflowWheel() {
        TimingWheel timingWheel = this;
        synchronized (timingWheel) {
            BoxedUnit boxedUnit;
            if (this.overflowWheel == null) {
                this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.kafka$utils$timer$TimingWheel$$taskCounter, this.queue);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        boolean bl;
        long expiration = timerTaskEntry.timerTask().expirationMs();
        if (expiration < this.currentTime + this.tickMs) {
            bl = false;
        } else if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets[(int)(virtualId % (long)this.wheelSize)];
            bucket.add(timerTaskEntry);
            Serializable serializable = bucket.setExpiration(virtualId * this.tickMs) ? BoxesRunTime.boxToBoolean(this.queue.offer(bucket)) : BoxedUnit.UNIT;
            bl = true;
        } else {
            if (this.overflowWheel == null) {
                this.addOverflowWheel();
            }
            bl = this.overflowWheel.add(timerTaskEntry);
        }
        return bl;
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
            }
        }
    }

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.kafka$utils$timer$TimingWheel$$taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.buckets = (TimerTaskList[])Array$.MODULE$.tabulate(wheelSize, new $anonfun$1(this), ClassManifest$.MODULE$.classType(TimerTaskList.class));
        this.currentTime = startMs - startMs % tickMs;
        this.overflowWheel = null;
    }
}

