/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

public class Node {
    private final int id;
    private final String host;
    private final int port;

    public Node(int id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public static Node noNode() {
        return new Node(-1, "", -1);
    }

    public int id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.host == null ? 0 : this.host.hashCode());
        result2 = 31 * result2 + this.id;
        result2 = 31 * result2 + this.port;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return "Node(" + this.id + ", " + this.host + ", " + this.port + ")";
    }
}

