/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel
implements ScatteringByteChannel,
GatheringByteChannel {
    private static final Logger log = LoggerFactory.getLogger(Channel.class);
    private TransportLayer transportLayer;
    private Authenticator authenticator;

    public Channel(TransportLayer transportLayer, Authenticator authenticator) throws IOException {
        this.transportLayer = transportLayer;
        this.authenticator = authenticator;
    }

    @Override
    public void close() throws IOException {
        this.transportLayer.close();
        this.authenticator.close();
    }

    public Principal principal() throws IOException {
        return this.authenticator.principal();
    }

    public int connect(boolean read2, boolean write2) throws IOException {
        if (this.transportLayer.isReady() && this.authenticator.isComplete()) {
            return 0;
        }
        int status = 0;
        if (!this.transportLayer.isReady()) {
            status = this.transportLayer.handshake(read2, write2);
        }
        if (status == 0 && !this.authenticator.isComplete()) {
            status = this.authenticator.authenticate(read2, write2);
        }
        return status;
    }

    @Override
    public boolean isOpen() {
        return this.transportLayer.isOpen();
    }

    public SocketChannel socketChannel() {
        return this.transportLayer.socketChannel();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.transportLayer.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.transportLayer.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.transportLayer.write(srcs, offset, length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.transportLayer.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.transportLayer.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.transportLayer.read(dsts, offset, length);
    }

    public boolean finishConnect() throws IOException {
        return this.transportLayer.finishConnect();
    }

    public boolean isReady() {
        return this.transportLayer.isReady() && this.authenticator.isComplete();
    }

    public DataInputStream getInputStream() throws IOException {
        return this.transportLayer.inStream();
    }

    public DataOutputStream getOutputStream() throws IOException {
        return this.transportLayer.outStream();
    }
}

