/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import com.sun.security.auth.UserPrincipal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextTransportLayer
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(PlainTextTransportLayer.class);
    private SocketChannel socketChannel = null;
    private DataInputStream inStream = null;
    private DataOutputStream outStream = null;
    private UserPrincipal principal = new UserPrincipal("ANONYMOUS");

    public PlainTextTransportLayer(SocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.socket().close();
        this.socketChannel.close();
    }

    @Override
    public boolean flush(ByteBuffer buf) throws IOException {
        int remaining = buf.remaining();
        if (remaining > 0) {
            int written = this.socketChannel.write(buf);
            return written >= remaining;
        }
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.socketChannel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.socketChannel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    @Override
    public int handshake(boolean read2, boolean write2) throws IOException {
        return 0;
    }

    @Override
    public DataInputStream inStream() throws IOException {
        if (this.inStream == null) {
            this.inStream = new DataInputStream(this.socketChannel.socket().getInputStream());
        }
        return this.inStream;
    }

    @Override
    public DataOutputStream outStream() throws IOException {
        if (this.outStream == null) {
            this.outStream = new DataOutputStream(this.socketChannel.socket().getOutputStream());
        }
        return this.outStream;
    }

    @Override
    public Principal peerPrincipal() throws IOException {
        return this.principal;
    }

    @Override
    public SSLSession sslSession() throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("sslSession not supported for PlainTextTransportLayer");
    }
}

