/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;

public class Protocol {
    public static final Schema REQUEST_HEADER = new Schema(new Field("api_key", Type.INT16, "The id of the request type."), new Field("api_version", Type.INT16, "The version of the API."), new Field("correlation_id", Type.INT32, "A user-supplied integer value that will be passed back with the response"), new Field("client_id", Type.STRING, "A user specified identifier for the client making the request."));
    public static final Schema RESPONSE_HEADER = new Schema(new Field("correlation_id", Type.INT32, "The user-supplied value passed in with the request"));
    public static final Schema METADATA_REQUEST_V0 = new Schema(new Field("topics", new ArrayOf(Type.STRING), "An array of topics to fetch metadata for. If no topics are specified fetch metadtata for all topics."));
    public static final Schema BROKER = new Schema(new Field("node_id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    public static final Schema PARTITION_METADATA_V0 = new Schema(new Field("partition_error_code", Type.INT16, "The error code for the partition, if any."), new Field("partition_id", Type.INT32, "The id of the partition."), new Field("leader", Type.INT32, "The id of the broker acting as leader for this partition."), new Field("replicas", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."));
    public static final Schema TOPIC_METADATA_V0 = new Schema(new Field("topic_error_code", Type.INT16, "The error code for the given topic."), new Field("topic", Type.STRING, "The name of the topic"), new Field("partition_metadata", new ArrayOf(PARTITION_METADATA_V0), "Metadata for each partition of the topic."));
    public static final Schema METADATA_RESPONSE_V0 = new Schema(new Field("brokers", new ArrayOf(BROKER), "Host and port information for all brokers."), new Field("topic_metadata", new ArrayOf(TOPIC_METADATA_V0)));
    public static final Schema[] METADATA_REQUEST = new Schema[]{METADATA_REQUEST_V0};
    public static final Schema[] METADATA_RESPONSE = new Schema[]{METADATA_RESPONSE_V0};
    public static final Schema TOPIC_PRODUCE_DATA_V0 = new Schema(new Field("topic", Type.STRING), new Field("data", new ArrayOf(new Schema(new Field("partition", Type.INT32), new Field("record_set", Type.BYTES)))));
    public static final Schema PRODUCE_REQUEST_V0 = new Schema(new Field("acks", Type.INT16, "The number of nodes that should replicate the produce before returning. -1 indicates the full ISR."), new Field("timeout", Type.INT32, "The time to await a response in ms."), new Field("topic_data", new ArrayOf(TOPIC_PRODUCE_DATA_V0)));
    public static final Schema PRODUCE_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(new Schema(new Field("partition", Type.INT32), new Field("error_code", Type.INT16), new Field("base_offset", Type.INT64))))))));
    public static final Schema[] PRODUCE_REQUEST = new Schema[]{PRODUCE_REQUEST_V0};
    public static final Schema[] PRODUCE_RESPONSE = new Schema[]{PRODUCE_RESPONSE_V0};
    public static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Message offset to be committed."), new Field("timestamp", Type.INT64, "Timestamp of the commit"), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."));
    public static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V1 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Message offset to be committed."), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."));
    public static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to commit."), new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V0), "Partitions to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V1 = new Schema(new Field("topic", Type.STRING, "Topic to commit."), new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V1), "Partitions to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V0), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V1 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("group_generation_id", Type.INT32, "The generation of the consumer group."), new Field("consumer_id", Type.STRING, "The consumer id assigned by the group coordinator."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V0), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_REQUEST_V2 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("group_generation_id", Type.INT32, "The generation of the consumer group."), new Field("consumer_id", Type.STRING, "The consumer id assigned by the group coordinator."), new Field("retention_time", Type.INT64, "Time period in ms to retain the offset."), new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V1), "Topics to commit offsets."));
    public static final Schema OFFSET_COMMIT_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16));
    public static final Schema OFFSET_COMMIT_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(OFFSET_COMMIT_RESPONSE_PARTITION_V0)));
    public static final Schema OFFSET_COMMIT_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(OFFSET_COMMIT_RESPONSE_TOPIC_V0)));
    public static final Schema[] OFFSET_COMMIT_REQUEST = new Schema[]{OFFSET_COMMIT_REQUEST_V0, OFFSET_COMMIT_REQUEST_V1, OFFSET_COMMIT_REQUEST_V2};
    public static final Schema[] OFFSET_COMMIT_RESPONSE = new Schema[]{OFFSET_COMMIT_RESPONSE_V0, OFFSET_COMMIT_RESPONSE_V0, OFFSET_COMMIT_RESPONSE_V0};
    public static final Schema OFFSET_FETCH_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."));
    public static final Schema OFFSET_FETCH_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to fetch offset."), new Field("partitions", new ArrayOf(OFFSET_FETCH_REQUEST_PARTITION_V0), "Partitions to fetch offsets."));
    public static final Schema OFFSET_FETCH_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("topics", new ArrayOf(OFFSET_FETCH_REQUEST_TOPIC_V0), "Topics to fetch offsets."));
    public static final Schema OFFSET_FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("offset", Type.INT64, "Last committed message offset."), new Field("metadata", Type.STRING, "Any associated metadata the client wants to keep."), new Field("error_code", Type.INT16));
    public static final Schema OFFSET_FETCH_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(OFFSET_FETCH_RESPONSE_PARTITION_V0)));
    public static final Schema OFFSET_FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(OFFSET_FETCH_RESPONSE_TOPIC_V0)));
    public static final Schema[] OFFSET_FETCH_REQUEST = new Schema[]{OFFSET_FETCH_REQUEST_V0};
    public static final Schema[] OFFSET_FETCH_RESPONSE = new Schema[]{OFFSET_FETCH_RESPONSE_V0};
    public static final Schema LIST_OFFSET_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("timestamp", Type.INT64, "Timestamp."), new Field("max_num_offsets", Type.INT32, "Maximum offsets to return."));
    public static final Schema LIST_OFFSET_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to list offset."), new Field("partitions", new ArrayOf(LIST_OFFSET_REQUEST_PARTITION_V0), "Partitions to list offset."));
    public static final Schema LIST_OFFSET_REQUEST_V0 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("topics", new ArrayOf(LIST_OFFSET_REQUEST_TOPIC_V0), "Topics to list offsets."));
    public static final Schema LIST_OFFSET_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16), new Field("offsets", new ArrayOf(Type.INT64), "A list of offsets."));
    public static final Schema LIST_OFFSET_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(LIST_OFFSET_RESPONSE_PARTITION_V0)));
    public static final Schema LIST_OFFSET_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(LIST_OFFSET_RESPONSE_TOPIC_V0)));
    public static final Schema[] LIST_OFFSET_REQUEST = new Schema[]{LIST_OFFSET_REQUEST_V0};
    public static final Schema[] LIST_OFFSET_RESPONSE = new Schema[]{LIST_OFFSET_RESPONSE_V0};
    public static final Schema FETCH_REQUEST_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("fetch_offset", Type.INT64, "Message offset."), new Field("max_bytes", Type.INT32, "Maximum bytes to fetch."));
    public static final Schema FETCH_REQUEST_TOPIC_V0 = new Schema(new Field("topic", Type.STRING, "Topic to fetch."), new Field("partitions", new ArrayOf(FETCH_REQUEST_PARTITION_V0), "Partitions to fetch."));
    public static final Schema FETCH_REQUEST_V0 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("max_wait_time", Type.INT32, "Maximum time in ms to wait for the response."), new Field("min_bytes", Type.INT32, "Minimum bytes to accumulate in the response."), new Field("topics", new ArrayOf(FETCH_REQUEST_TOPIC_V0), "Topics to fetch."));
    public static final Schema FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition", Type.INT32, "Topic partition id."), new Field("error_code", Type.INT16), new Field("high_watermark", Type.INT64, "Last committed offset."), new Field("record_set", Type.BYTES));
    public static final Schema FETCH_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partition_responses", new ArrayOf(FETCH_RESPONSE_PARTITION_V0)));
    public static final Schema FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(FETCH_RESPONSE_TOPIC_V0)));
    public static final Schema[] FETCH_REQUEST = new Schema[]{FETCH_REQUEST_V0};
    public static final Schema[] FETCH_RESPONSE = new Schema[]{FETCH_RESPONSE_V0};
    public static final Schema CONSUMER_METADATA_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."));
    public static final Schema CONSUMER_METADATA_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("coordinator", BROKER, "Host and port information for the coordinator for a consumer group."));
    public static final Schema[] CONSUMER_METADATA_REQUEST = new Schema[]{CONSUMER_METADATA_REQUEST_V0};
    public static final Schema[] CONSUMER_METADATA_RESPONSE = new Schema[]{CONSUMER_METADATA_RESPONSE_V0};
    public static final Schema JOIN_GROUP_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("session_timeout", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in ms."), new Field("topics", new ArrayOf(Type.STRING), "An array of topics to subscribe to."), new Field("consumer_id", Type.STRING, "The assigned consumer id or an empty string for a new consumer."), new Field("partition_assignment_strategy", Type.STRING, "The strategy for the coordinator to assign partitions."));
    public static final Schema JOIN_GROUP_RESPONSE_TOPIC_V0 = new Schema(new Field("topic", Type.STRING), new Field("partitions", new ArrayOf(Type.INT32)));
    public static final Schema JOIN_GROUP_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16), new Field("group_generation_id", Type.INT32, "The generation of the consumer group."), new Field("consumer_id", Type.STRING, "The consumer id assigned by the group coordinator."), new Field("assigned_partitions", new ArrayOf(JOIN_GROUP_RESPONSE_TOPIC_V0)));
    public static final Schema[] JOIN_GROUP_REQUEST = new Schema[]{JOIN_GROUP_REQUEST_V0};
    public static final Schema[] JOIN_GROUP_RESPONSE = new Schema[]{JOIN_GROUP_RESPONSE_V0};
    public static final Schema HEARTBEAT_REQUEST_V0 = new Schema(new Field("group_id", Type.STRING, "The consumer group id."), new Field("group_generation_id", Type.INT32, "The generation of the consumer group."), new Field("consumer_id", Type.STRING, "The consumer id assigned by the group coordinator."));
    public static final Schema HEARTBEAT_RESPONSE_V0 = new Schema(new Field("error_code", Type.INT16));
    public static final Schema[] HEARTBEAT_REQUEST = new Schema[]{HEARTBEAT_REQUEST_V0};
    public static final Schema[] HEARTBEAT_RESPONSE = new Schema[]{HEARTBEAT_RESPONSE_V0};
    public static final Schema[][] REQUESTS = new Schema[ApiKeys.MAX_API_KEY + 1][];
    public static final Schema[][] RESPONSES = new Schema[ApiKeys.MAX_API_KEY + 1][];
    public static final short[] CURR_VERSION = new short[ApiKeys.MAX_API_KEY + 1];

    static {
        Protocol.REQUESTS[ApiKeys.PRODUCE.id] = PRODUCE_REQUEST;
        Protocol.REQUESTS[ApiKeys.FETCH.id] = FETCH_REQUEST;
        Protocol.REQUESTS[ApiKeys.LIST_OFFSETS.id] = LIST_OFFSET_REQUEST;
        Protocol.REQUESTS[ApiKeys.METADATA.id] = METADATA_REQUEST;
        Protocol.REQUESTS[ApiKeys.LEADER_AND_ISR.id] = new Schema[0];
        Protocol.REQUESTS[ApiKeys.STOP_REPLICA.id] = new Schema[0];
        Protocol.REQUESTS[ApiKeys.UPDATE_METADATA_KEY.id] = new Schema[0];
        Protocol.REQUESTS[ApiKeys.CONTROLLED_SHUTDOWN_KEY.id] = new Schema[0];
        Protocol.REQUESTS[ApiKeys.OFFSET_COMMIT.id] = OFFSET_COMMIT_REQUEST;
        Protocol.REQUESTS[ApiKeys.OFFSET_FETCH.id] = OFFSET_FETCH_REQUEST;
        Protocol.REQUESTS[ApiKeys.CONSUMER_METADATA.id] = CONSUMER_METADATA_REQUEST;
        Protocol.REQUESTS[ApiKeys.JOIN_GROUP.id] = JOIN_GROUP_REQUEST;
        Protocol.REQUESTS[ApiKeys.HEARTBEAT.id] = HEARTBEAT_REQUEST;
        Protocol.RESPONSES[ApiKeys.PRODUCE.id] = PRODUCE_RESPONSE;
        Protocol.RESPONSES[ApiKeys.FETCH.id] = FETCH_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LIST_OFFSETS.id] = LIST_OFFSET_RESPONSE;
        Protocol.RESPONSES[ApiKeys.METADATA.id] = METADATA_RESPONSE;
        Protocol.RESPONSES[ApiKeys.LEADER_AND_ISR.id] = new Schema[0];
        Protocol.RESPONSES[ApiKeys.STOP_REPLICA.id] = new Schema[0];
        Protocol.RESPONSES[ApiKeys.UPDATE_METADATA_KEY.id] = new Schema[0];
        Protocol.RESPONSES[ApiKeys.CONTROLLED_SHUTDOWN_KEY.id] = new Schema[0];
        Protocol.RESPONSES[ApiKeys.OFFSET_COMMIT.id] = OFFSET_COMMIT_RESPONSE;
        Protocol.RESPONSES[ApiKeys.OFFSET_FETCH.id] = OFFSET_FETCH_RESPONSE;
        Protocol.RESPONSES[ApiKeys.CONSUMER_METADATA.id] = CONSUMER_METADATA_RESPONSE;
        Protocol.RESPONSES[ApiKeys.JOIN_GROUP.id] = JOIN_GROUP_RESPONSE;
        Protocol.RESPONSES[ApiKeys.HEARTBEAT.id] = HEARTBEAT_RESPONSE;
        for (ApiKeys api : ApiKeys.values()) {
            Protocol.CURR_VERSION[api.id] = (short)(REQUESTS[api.id].length - 1);
        }
        for (ApiKeys api : ApiKeys.values()) {
            if (REQUESTS[api.id].length == RESPONSES[api.id].length) continue;
            throw new IllegalStateException(REQUESTS[api.id].length + " request versions for api " + api.name + " but " + RESPONSES[api.id].length + " response versions.");
        }
    }
}

