/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    Struct(Schema schema, Object[] values2) {
        this.schema = schema;
        this.values = values2;
    }

    public Struct(Schema schema) {
        this.schema = schema;
        this.values = new Object[this.schema.numFields()];
    }

    public Schema schema() {
        return this.schema;
    }

    private Object getFieldOrDefault(Field field) {
        Object value2 = this.values[field.index];
        if (value2 != null) {
            return value2;
        }
        if (field.defaultValue != Field.NO_DEFAULT) {
            return field.defaultValue;
        }
        throw new SchemaException("Missing value for field '" + field.name + "' which has no default value.");
    }

    public Object get(Field field) {
        this.validateField(field);
        return this.getFieldOrDefault(field);
    }

    public Object get(String name) {
        Field field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("No such field: " + name);
        }
        return this.getFieldOrDefault(field);
    }

    public boolean hasField(String name) {
        return this.schema.get(name) != null;
    }

    public Struct getStruct(Field field) {
        return (Struct)this.get(field);
    }

    public Struct getStruct(String name) {
        return (Struct)this.get(name);
    }

    public Short getShort(Field field) {
        return (Short)this.get(field);
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getInt(Field field) {
        return (Integer)this.get(field);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getLong(Field field) {
        return (Long)this.get(field);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Object[] getArray(Field field) {
        return (Object[])this.get(field);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public String getString(Field field) {
        return (String)this.get(field);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public ByteBuffer getBytes(Field field) {
        return (ByteBuffer)this.get(field);
    }

    public ByteBuffer getBytes(String name) {
        return (ByteBuffer)this.get(name);
    }

    public Struct set(Field field, Object value2) {
        this.validateField(field);
        this.values[field.index] = value2;
        return this;
    }

    public Struct set(String name, Object value2) {
        Field field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("Unknown field: " + name);
        }
        this.values[field.index] = value2;
        return this;
    }

    public Struct instance(Field field) {
        this.validateField(field);
        if (field.type() instanceof Schema) {
            return new Struct((Schema)field.type());
        }
        if (field.type() instanceof ArrayOf) {
            ArrayOf array = (ArrayOf)field.type();
            return new Struct((Schema)array.type());
        }
        throw new SchemaException("Field '" + field.name + "' is not a container type, it is of type " + field.type());
    }

    public Struct instance(String field) {
        return this.instance(this.schema.get(field));
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int sizeOf() {
        return this.schema.sizeOf(this);
    }

    public void writeTo(ByteBuffer buffer) {
        this.schema.write(buffer, this);
    }

    private void validateField(Field field) {
        if (this.schema != field.schema) {
            throw new SchemaException("Attempt to access field '" + field.name + "' from a different schema instance.");
        }
        if (field.index > this.values.length) {
            throw new SchemaException("Invalid field index: " + field.index);
        }
    }

    public void validate() {
        this.schema.validate(this);
    }

    public ByteBuffer[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.sizeOf());
        this.writeTo(buffer);
        return new ByteBuffer[]{buffer};
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            Field f = this.schema.get(i);
            b.append(f.name);
            b.append('=');
            if (f.type() instanceof ArrayOf) {
                Object[] arrayValue = (Object[])this.values[i];
                b.append('[');
                for (int j = 0; j < arrayValue.length; ++j) {
                    b.append(arrayValue[j]);
                    if (j >= arrayValue.length - 1) continue;
                    b.append(',');
                }
                b.append(']');
            } else {
                b.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        for (int i = 0; i < this.values.length; ++i) {
            Field f = this.schema.get(i);
            if (f.type() instanceof ArrayOf) {
                Object[] arrayObject;
                for (Object arrayItem : arrayObject = (Object[])this.get(f)) {
                    result2 = 31 * result2 + arrayItem.hashCode();
                }
                continue;
            }
            result2 = 31 * result2 + this.get(f).hashCode();
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.schema != other.schema) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Field f = this.schema.get(i);
            Boolean result2 = f.type() instanceof ArrayOf ? Boolean.valueOf(Arrays.equals((Object[])this.get(f), (Object[])other.get(f))) : Boolean.valueOf(this.get(f).equals(other.get(f)));
            if (result2.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

