/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ConsumerMetadataRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.ProduceRequest;

public abstract class AbstractRequest
extends AbstractRequestResponse {
    public AbstractRequest(Struct struct) {
        super(struct);
    }

    public abstract AbstractRequestResponse getErrorResponse(Throwable var1);

    public static AbstractRequest getRequest(int requestId, ByteBuffer buffer) {
        switch (ApiKeys.forId(requestId)) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer);
            }
            case FETCH: {
                return FetchRequest.parse(buffer);
            }
            case LIST_OFFSETS: {
                return ListOffsetRequest.parse(buffer);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer);
            }
            case CONSUMER_METADATA: {
                return ConsumerMetadataRequest.parse(buffer);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer);
            }
        }
        return null;
    }
}

