/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;

public class HeartbeatRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.HEARTBEAT.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String GROUP_GENERATION_ID_KEY_NAME = "group_generation_id";
    private static final String CONSUMER_ID_KEY_NAME = "consumer_id";
    private final String groupId;
    private final int groupGenerationId;
    private final String consumerId;

    public HeartbeatRequest(String groupId, int groupGenerationId, String consumerId) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(GROUP_GENERATION_ID_KEY_NAME, (Object)groupGenerationId);
        this.struct.set(CONSUMER_ID_KEY_NAME, (Object)consumerId);
        this.groupId = groupId;
        this.groupGenerationId = groupGenerationId;
        this.consumerId = consumerId;
    }

    public HeartbeatRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.groupGenerationId = struct.getInt(GROUP_GENERATION_ID_KEY_NAME);
        this.consumerId = struct.getString(CONSUMER_ID_KEY_NAME);
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupGenerationId() {
        return this.groupGenerationId;
    }

    public String consumerId() {
        return this.consumerId;
    }

    public static HeartbeatRequest parse(ByteBuffer buffer) {
        return new HeartbeatRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }

    @Override
    public AbstractRequestResponse getErrorResponse(Throwable e) {
        return new HeartbeatResponse(Errors.forException(e).code());
    }
}

