/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class JoinGroupResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.JOIN_GROUP.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String GENERATION_ID_KEY_NAME = "group_generation_id";
    private static final String CONSUMER_ID_KEY_NAME = "consumer_id";
    private static final String ASSIGNED_PARTITIONS_KEY_NAME = "assigned_partitions";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    public static final int UNKNOWN_GENERATION_ID = -1;
    public static final String UNKNOWN_CONSUMER_ID = "";
    private final short errorCode;
    private final int generationId;
    private final String consumerId;
    private final List<TopicPartition> assignedPartitions;

    public JoinGroupResponse(short errorCode, int generationId, String consumerId, List<TopicPartition> assignedPartitions) {
        super(new Struct(CURRENT_SCHEMA));
        Map<String, List<Integer>> partitionsByTopic = CollectionUtils.groupDataByTopic(assignedPartitions);
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(CONSUMER_ID_KEY_NAME, (Object)consumerId);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, List<Integer>> entries : partitionsByTopic.entrySet()) {
            Struct topicData = this.struct.instance(ASSIGNED_PARTITIONS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            topicData.set(PARTITIONS_KEY_NAME, (Object)entries.getValue().toArray());
            topicArray.add(topicData);
        }
        this.struct.set(ASSIGNED_PARTITIONS_KEY_NAME, (Object)topicArray.toArray());
        this.errorCode = errorCode;
        this.generationId = generationId;
        this.consumerId = consumerId;
        this.assignedPartitions = assignedPartitions;
    }

    public JoinGroupResponse(short errorCode) {
        this(errorCode, -1, UNKNOWN_CONSUMER_ID, Collections.emptyList());
    }

    public JoinGroupResponse(Struct struct) {
        super(struct);
        this.assignedPartitions = new ArrayList<TopicPartition>();
        for (Object topicDataObj : struct.getArray(ASSIGNED_PARTITIONS_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : topicData.getArray(PARTITIONS_KEY_NAME)) {
                this.assignedPartitions.add(new TopicPartition(topic, (Integer)partitionObj));
            }
        }
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        this.generationId = struct.getInt(GENERATION_ID_KEY_NAME);
        this.consumerId = struct.getString(CONSUMER_ID_KEY_NAME);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int generationId() {
        return this.generationId;
    }

    public String consumerId() {
        return this.consumerId;
    }

    public List<TopicPartition> assignedPartitions() {
        return this.assignedPartitions;
    }

    public static JoinGroupResponse parse(ByteBuffer buffer) {
        return new JoinGroupResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

