/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.MetadataResponse;

public class MetadataRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.METADATA.id);
    private static final String TOPICS_KEY_NAME = "topics";
    private final List<String> topics;

    public MetadataRequest(List<String> topics) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.topics = topics;
    }

    public MetadataRequest(Struct struct) {
        super(struct);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        this.topics = new ArrayList<String>();
        for (Object topicObj : topicArray) {
            this.topics.add((String)topicObj);
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(Throwable e) {
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>();
        for (String topic : this.topics) {
            topicErrors.put(topic, Errors.forException(e));
        }
        return new MetadataResponse(topicErrors);
    }

    public List<String> topics() {
        return this.topics;
    }

    public static MetadataRequest parse(ByteBuffer buffer) {
        return new MetadataRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

