/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.URIParameter;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthUtils.class);
    public static final String LOGIN_CONTEXT_SERVER = "KafkaServer";
    public static final String LOGIN_CONTEXT_CLIENT = "KafkaClient";
    public static final String SERVICE_NAME = "serviceName";

    public static Configuration getConfiguration(String jaasConfigFilePath) {
        Configuration loginConf = null;
        if (jaasConfigFilePath != null && jaasConfigFilePath.length() > 0) {
            File configFile = new File(jaasConfigFilePath);
            if (!configFile.canRead()) {
                throw new RuntimeException("File " + jaasConfigFilePath + " cannot be read.");
            }
            try {
                URI configURI = configFile.toURI();
                loginConf = Configuration.getInstance("JavaLoginConfig", new URIParameter(configURI));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return loginConf;
    }

    public static String getJaasConfig(String loginContextName, String key) throws IOException {
        AppConfigurationEntry[] configurationEntries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + loginContextName + "' entry in this configuration.";
            throw new IOException(errorMessage);
        }
        for (AppConfigurationEntry entry2 : configurationEntries) {
            Object val = entry2.getOptions().get(key);
            if (val == null) continue;
            return (String)val;
        }
        return null;
    }

    public static String getDefaultRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }
}

