/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Date;
import org.apache.kafka.common.utils.Time;

public class SystemTime
implements Time {
    @Override
    public long milliseconds() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanoseconds() {
        return System.nanoTime();
    }

    @Override
    public void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public long currentElapsedTime() {
        return System.nanoTime() / 1000000L;
    }

    @Override
    public long currentWallTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Date elapsedTimeToDate(long elapsedTime) {
        long wallTime = this.currentWallTime() + elapsedTime - this.currentElapsedTime();
        return new Date(wallTime);
    }
}

