/*
 * Decompiled with CFR 0.152.
 */
package scalaprops;

import java.math.BigInteger;
import scala.runtime.BoxesRunTime;
import scalaprops.F2Polynomial$;

public final class F2Polynomial {
    private final BigInteger pol;

    public static F2Polynomial X() {
        return F2Polynomial$.MODULE$.X();
    }

    private F2Polynomial(BigInteger pol) {
        this.pol = pol;
    }

    private BigInteger pol() {
        return this.pol;
    }

    public F2Polynomial(String value, int radix) {
        this(new BigInteger(value, radix));
    }

    public F2Polynomial(String value) {
        this(new BigInteger(value, 2));
    }

    public int degree() {
        return F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$degree(this.pol());
    }

    public F2Polynomial add(F2Polynomial that) {
        return new F2Polynomial(this.pol().xor(that.pol()));
    }

    public F2Polynomial mul(F2Polynomial that) {
        if (this.degree() >= that.degree()) {
            return new F2Polynomial(F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$mul(this.pol(), that.pol()));
        }
        return new F2Polynomial(F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$mul(that.pol(), this.pol()));
    }

    public int getCoefficient(int index) {
        if (this.pol().testBit(index)) {
            return 1;
        }
        return 0;
    }

    public F2Polynomial mod(F2Polynomial that) {
        return new F2Polynomial(F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$mod(this.pol(), that.pol()));
    }

    public F2Polynomial power(BigInteger pow) {
        return new F2Polynomial(this.power(this.pol(), pow));
    }

    private BigInteger power(BigInteger x, BigInteger power) {
        BigInteger z = BigInteger.ONE;
        BigInteger v = x;
        BigInteger pow = power;
        while (!BoxesRunTime.equals((Object)pow, (Object)BigInteger.ZERO)) {
            if (pow.and(BigInteger.ONE).testBit(0)) {
                z = F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$mul(z, v);
            }
            v = F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$mul(v, v);
            pow = pow.shiftRight(1);
        }
        return z;
    }

    public F2Polynomial powerMod(BigInteger pow, F2Polynomial mod) {
        return new F2Polynomial(F2Polynomial$.MODULE$.scalaprops$F2Polynomial$$$powerMod(this.pol(), pow, mod.pol()));
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int base) {
        return this.pol().toString(base);
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof F2Polynomial) {
            F2Polynomial that = (F2Polynomial)object;
            return BoxesRunTime.equals((Object)this.pol(), (Object)that.pol());
        }
        return false;
    }

    public int hashCode() {
        return this.pol().hashCode();
    }
}

