/*
 * Decompiled with CFR 0.152.
 */
package scalaprops;

import java.nio.ByteBuffer;
import java.util.Arrays;
import scala.Int$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scalaprops.MersenneTwister64$;
import scalaprops.Rand;

public final class MersenneTwister64
extends Rand {
    private final long[] mt0;
    private final int mti0;

    public static int defaultSeed() {
        return MersenneTwister64$.MODULE$.defaultSeed();
    }

    public static MersenneTwister64 fromArray(long[] lArray) {
        return MersenneTwister64$.MODULE$.fromArray(lArray);
    }

    public static MersenneTwister64 fromBytes(byte[] byArray) {
        return MersenneTwister64$.MODULE$.fromBytes(byArray);
    }

    public static MersenneTwister64 fromSeed(int n) {
        return MersenneTwister64$.MODULE$.fromSeed(n);
    }

    public static MersenneTwister64 fromSeed(long[] lArray, int n) {
        return MersenneTwister64$.MODULE$.fromSeed(lArray, n);
    }

    public static MersenneTwister64 fromTime(long l) {
        return MersenneTwister64$.MODULE$.fromTime(l);
    }

    public static int[] seedFromInt(int n, int n2) {
        return MersenneTwister64$.MODULE$.seedFromInt(n, n2);
    }

    public static MersenneTwister64 standard(long l) {
        return MersenneTwister64$.MODULE$.standard(l);
    }

    public static int fromSeed$default$1() {
        return MersenneTwister64$.MODULE$.fromSeed$default$1();
    }

    public static long fromTime$default$1() {
        return MersenneTwister64$.MODULE$.fromTime$default$1();
    }

    public MersenneTwister64(long[] mt0, int mti0) {
        this.mt0 = mt0;
        this.mti0 = mti0;
    }

    private long[] mt0() {
        return this.mt0;
    }

    private int mti0() {
        return this.mti0;
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof MersenneTwister64) {
            MersenneTwister64 that = (MersenneTwister64)object;
            return this.$eq$eq$eq(that);
        }
        return false;
    }

    public int hashCode() {
        return this.mti0();
    }

    public boolean $eq$eq$eq(MersenneTwister64 that) {
        return this == that || this.mti0() == that.mti0() && Arrays.equals(this.mt0(), that.mt0());
    }

    @Override
    public MersenneTwister64 next() {
        return (MersenneTwister64)this.nextLong()._1();
    }

    public byte[] getSeedBytes() {
        byte[] bytes = new byte[2500];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int i = 0; i < 312; ++i) {
            bb.putLong(this.mt0()[i]);
        }
        bb.putInt(this.mti0());
        return bytes;
    }

    public MersenneTwister64 setSeedBytes(byte[] bytes) {
        long[] mt = (long[])this.mt0().clone();
        byte[] bs = bytes.length < 2500 ? Arrays.copyOf(bytes, 2500) : bytes;
        ByteBuffer bb = ByteBuffer.wrap(bs);
        for (int i = 0; i < 312; ++i) {
            mt[i] = bb.getLong();
        }
        int mti = bb.getInt();
        return new MersenneTwister64(mt, mti);
    }

    @Override
    public Rand reseed(long n) {
        return this.next();
    }

    @Override
    public MersenneTwister64 setIntSeed(int seed) {
        return MersenneTwister64$.MODULE$.fromTime(Int$.MODULE$.int2long(seed));
    }

    public Tuple2<MersenneTwister64, Object> nextLong() {
        long[] lArray;
        int mti = this.mti0();
        long x = 0L;
        if (mti >= 312) {
            int kk;
            long[] mt = (long[])this.mt0().clone();
            for (kk = 0; kk < 156; ++kk) {
                x = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 156] ^ x >>> 1 ^ MersenneTwister64$.MODULE$.scalaprops$MersenneTwister64$$$mag01(x);
            }
            while (kk < 311) {
                x = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -156] ^ x >>> 1 ^ MersenneTwister64$.MODULE$.scalaprops$MersenneTwister64$$$mag01(x);
                ++kk;
            }
            x = mt[311] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[311] = mt[155] ^ x >>> 1 ^ MersenneTwister64$.MODULE$.scalaprops$MersenneTwister64$$$mag01(x);
            mti = 0;
            lArray = mt;
        } else {
            lArray = this.mt0();
        }
        long[] mt1 = lArray;
        x = mt1[mti];
        x ^= x >>> 29 & 0x5555555555555555L;
        x ^= x << 17 & 0x71D67FFFEDA60000L;
        x ^= x << 37 & 0xFFF7EEE000000000L;
        x ^= x >>> 43;
        return Tuple2$.MODULE$.apply((Object)new MersenneTwister64(mt1, ++mti), (Object)BoxesRunTime.boxToLong((long)x));
    }

    @Override
    public Tuple2<Rand, Object> nextInt() {
        return this.nextIntFromNextLong();
    }

    public String toString() {
        return Predef$.MODULE$.wrapLongArray(this.mt0()).mkString("MersenneTwister64(Array(", ",", new StringBuilder(4).append("), ").append(this.mti0()).append(")").toString());
    }
}

